import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { setTitle } from "@kie-tools/runtime-tools-components/dist/utils/Utils";
import { ClockIcon } from "@patternfly/react-icons/dist/js/icons/clock-icon";
import { BanIcon } from "@patternfly/react-icons/dist/js/icons/ban-icon";
import { UndoIcon } from "@patternfly/react-icons/dist/js/icons/undo-icon";
import { ErrorCircleOIcon } from "@patternfly/react-icons/dist/js/icons/error-circle-o-icon";
import { CheckCircleIcon } from "@patternfly/react-icons/dist/js/icons/check-circle-icon";
import { OnRunningIcon } from "@patternfly/react-icons/dist/js/icons/on-running-icon";
import { PausedIcon } from "@patternfly/react-icons/dist/js/icons/paused-icon";
import { JobStatus, WorkflowInstanceState, } from "@kie-tools/runtime-tools-swf-gateway-api/dist/types";
export const JobsIconCreator = (state) => {
    switch (state) {
        case JobStatus.Error:
            return (_jsxs(_Fragment, { children: [_jsx(ErrorCircleOIcon, { className: "pf-u-mr-sm", color: "var(--pf-global--danger-color--100)" }), "Error"] }));
        case JobStatus.Canceled:
            return (_jsxs(_Fragment, { children: [_jsx(BanIcon, { className: "pf-u-mr-sm" }), "Canceled"] }));
        case JobStatus.Executed:
            return (_jsxs(_Fragment, { children: [_jsx(CheckCircleIcon, { className: "pf-u-mr-sm", color: "var(--pf-global--success-color--100)" }), "Executed"] }));
        case JobStatus.Retry:
            return (_jsxs(_Fragment, { children: [_jsx(UndoIcon, { className: "pf-u-mr-sm" }), "Retry"] }));
        case JobStatus.Scheduled:
            return (_jsxs(_Fragment, { children: [_jsx(ClockIcon, { className: "pf-u-mr-sm" }), "Scheduled"] }));
    }
};
export const handleRetry = async (workflowInstance, drive, onRetrySuccess, onRetryFailure) => {
    try {
        await drive.handleWorkflowRetry(workflowInstance);
        onRetrySuccess();
    }
    catch (error) {
        onRetryFailure(JSON.stringify(error.message));
    }
};
export const handleSkip = async (workflowInstance, drive, onSkipSuccess, onSkipFailure) => {
    try {
        await drive.handleWorkflowSkip(workflowInstance);
        onSkipSuccess();
    }
    catch (error) {
        onSkipFailure(JSON.stringify(error.message));
    }
};
export const handleNodeInstanceRetrigger = (workflowInstance, driver, node, onRetriggerSuccess, onRetriggerFailure) => {
    driver
        .handleNodeInstanceRetrigger(workflowInstance, node)
        .then(() => {
        onRetriggerSuccess();
    })
        .catch((error) => {
        onRetriggerFailure(JSON.stringify(error.message));
    });
};
export const handleNodeInstanceCancel = (workflowInstance, driver, node, onCancelSuccess, onCancelFailure) => {
    driver
        .handleNodeInstanceCancel(workflowInstance, node)
        .then(() => {
        onCancelSuccess();
    })
        .catch((error) => {
        onCancelFailure(JSON.stringify(error.message));
    });
};
export const jobCancel = async (drive, job, setModalTitle, setModalContent) => {
    const response = await drive.cancelJob(job);
    setModalTitle(setTitle(response.modalTitle, "Job cancel"));
    setModalContent(response.modalContent);
};
export const handleJobRescheduleUtil = async (repeatInterval, repeatLimit, scheduleDate, selectedJob, handleRescheduleAction, driver, setRescheduleError) => {
    const response = await driver.rescheduleJob(selectedJob, repeatInterval, repeatLimit, scheduleDate);
    if (response && response.modalTitle === "success") {
        handleRescheduleAction();
    }
    else if (response && response.modalTitle === "failure") {
        handleRescheduleAction();
        setRescheduleError(response.modalContent);
    }
};
export const getWorkflowInstanceDescription = (workflowInstance) => {
    return {
        id: workflowInstance.id,
        name: workflowInstance.processName,
        description: workflowInstance.businessKey,
    };
};
export const WorkflowInstanceIconCreator = (state) => {
    switch (state) {
        case WorkflowInstanceState.Active:
            return (_jsxs(_Fragment, { children: [_jsx(OnRunningIcon, { className: "pf-u-mr-sm" }), "Active"] }));
        case WorkflowInstanceState.Completed:
            return (_jsxs(_Fragment, { children: [_jsx(CheckCircleIcon, { className: "pf-u-mr-sm", color: "var(--pf-global--success-color--100)" }), "Completed"] }));
        case WorkflowInstanceState.Aborted:
            return (_jsxs(_Fragment, { children: [_jsx(BanIcon, { className: "pf-u-mr-sm" }), "Aborted"] }));
        case WorkflowInstanceState.Suspended:
            return (_jsxs(_Fragment, { children: [_jsx(PausedIcon, { className: "pf-u-mr-sm" }), "Suspended"] }));
        case WorkflowInstanceState.Error:
            return (_jsxs(_Fragment, { children: [_jsx(ErrorCircleOIcon, { className: "pf-u-mr-sm", color: "var(--pf-global--danger-color--100)" }), "Error"] }));
    }
};
//# sourceMappingURL=Utils.js.map