import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { Table, TableBody, TableHeader } from "@patternfly/react-table/dist/js/components/Table";
import { useEffect, useState } from "react";
import { WorkflowInstanceState } from "@kie-tools/runtime-tools-swf-gateway-api/dist/types";
import _ from "lodash";
import { ServerErrors } from "@kie-tools/runtime-tools-components/dist/components/ServerErrors";
import { KogitoEmptyState, KogitoEmptyStateType, } from "@kie-tools/runtime-tools-components/dist/components/KogitoEmptyState";
import { KogitoSpinner } from "@kie-tools/runtime-tools-components/dist/components/KogitoSpinner";
import { ItemDescriptor } from "@kie-tools/runtime-tools-components/dist/components/ItemDescriptor";
import { EndpointLink } from "@kie-tools/runtime-tools-components/dist/components/EndpointLink";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { getWorkflowInstanceDescription, WorkflowInstanceIconCreator } from "../utils/WorkflowListUtils";
import { HistoryIcon } from "@patternfly/react-icons/dist/js/icons/history-icon";
import Moment from "react-moment";
import WorkflowListActionsKebab from "../WorkflowListActionsKebab/WorkflowListActionsKebab";
import { Checkbox } from "@patternfly/react-core/dist/js/components/Checkbox";
import DisablePopup from "../DisablePopup/DisablePopup";
import ErrorPopover from "../ErrorPopover/ErrorPopover";
import "../styles.css";
const WorkflowListChildTable = ({ parentWorkflowId, selectedInstances, setSelectedInstances, workflowInstances, setWorkflowInstances, driver, onSkipClick, onRetryClick, onAbortClick, setSelectableInstances, ouiaId, ouiaSafe, }) => {
    const [rows, setRows] = useState([]);
    const [isLoading, setIsLoading] = useState(false);
    const [showNoDataEmptyState, setShowNoDataEmptyState] = useState(false);
    const [error, setError] = useState(undefined);
    const columnNames = ["__Select", "Id", "Status", "Created", "Last update", "__Actions"];
    const columns = columnNames.map((it) => ({
        title: it.startsWith("__") ? "" : it,
    }));
    const handleClick = (childWorkflowInstance) => {
        driver.openWorkflow(childWorkflowInstance);
    };
    const checkBoxSelect = (workflowInstance) => {
        const clonedWorkflowInstances = [...workflowInstances];
        clonedWorkflowInstances.forEach((instance) => {
            var _a;
            if (instance.id === parentWorkflowId) {
                (_a = instance.childWorkflowInstances) === null || _a === void 0 ? void 0 : _a.forEach((childInstance) => {
                    if (childInstance.id === workflowInstance.id) {
                        if (childInstance.isSelected) {
                            childInstance.isSelected = false;
                            setSelectedInstances(selectedInstances.filter((selectedInstance) => selectedInstance.id !== childInstance.id));
                        }
                        else {
                            childInstance.isSelected = true;
                            setSelectedInstances([...selectedInstances, childInstance]);
                        }
                    }
                });
            }
        });
        setWorkflowInstances(clonedWorkflowInstances);
    };
    const createRows = (childWorkflowInstances) => {
        if (!_.isEmpty(childWorkflowInstances)) {
            const tempRows = [];
            childWorkflowInstances.forEach((child) => {
                var _a;
                const cells = [
                    {
                        title: (_jsx(_Fragment, { children: ((_a = child.addons) === null || _a === void 0 ? void 0 : _a.includes("workflow-management")) && child.serviceUrl !== null ? (_jsx(Checkbox, { isChecked: child.isSelected, onChange: () => {
                                    checkBoxSelect(child);
                                }, "aria-label": "workflow-list-checkbox", id: `checkbox-${child.id}`, name: `checkbox-${child.id}` })) : (_jsx(DisablePopup, { workflowInstanceData: child, component: _jsx(Checkbox, { "aria-label": "workflow-list-checkbox-disabled", id: `checkbox-${child.id}`, isDisabled: true }) })) })),
                    },
                    {
                        title: (_jsxs(_Fragment, { children: [_jsx("a", { className: "kogito-workflow-list__link", onClick: () => handleClick(child), ...componentOuiaProps(ouiaId, "workflow-description", ouiaSafe), children: _jsx("strong", { children: _jsx(ItemDescriptor, { itemDescription: getWorkflowInstanceDescription(child) }) }) }), _jsx(EndpointLink, { serviceUrl: child.serviceUrl, isLinkShown: false })] })),
                    },
                    {
                        title: child.state === WorkflowInstanceState.Error ? (_jsx(ErrorPopover, { workflowInstanceData: child, onSkipClick: onSkipClick, onRetryClick: onRetryClick })) : (WorkflowInstanceIconCreator(child.state)),
                    },
                    {
                        title: child.start ? _jsx(Moment, { fromNow: true, children: new Date(`${child.start}`) }) : "",
                    },
                    {
                        title: child.lastUpdate ? (_jsxs("span", { children: [" ", _jsx(HistoryIcon, { className: "pf-u-mr-sm" }), " Updated", " ", _jsx(Moment, { fromNow: true, children: new Date(`${child.lastUpdate}`) })] })) : (""),
                    },
                    {
                        title: (_jsx(WorkflowListActionsKebab, { workflowInstance: child, onSkipClick: onSkipClick, onRetryClick: onRetryClick, onAbortClick: onAbortClick }, child.id)),
                    },
                ];
                cells.forEach((cellInRow, index) => {
                    cellInRow.props = componentOuiaProps(columnNames[index].toLowerCase(), "workflow-list-cell", true);
                });
                tempRows.push({
                    cells: cells,
                });
            });
            setRows(tempRows);
            setShowNoDataEmptyState(false);
        }
        else {
            setShowNoDataEmptyState(true);
        }
    };
    const getChildWorkflowInstances = async () => {
        try {
            setIsLoading(true);
            const response = await driver.getChildWorkflowsQuery(parentWorkflowId);
            workflowInstances.forEach((workflowInstance) => {
                if (workflowInstance.id === parentWorkflowId) {
                    response.forEach((child) => {
                        var _a;
                        child.isSelected = false;
                        if (child.serviceUrl && ((_a = child.addons) === null || _a === void 0 ? void 0 : _a.includes("workflow-management"))) {
                            setSelectableInstances((prev) => prev + 1);
                        }
                    });
                    workflowInstance.childWorkflowInstances = response;
                }
            });
            createRows(response);
        }
        catch (error) {
            setError(error);
        }
        finally {
            setIsLoading(false);
        }
    };
    useEffect(() => {
        var _a;
        if (workflowInstances.length > 0) {
            const workflowInstance = workflowInstances.find((instance) => instance.id === parentWorkflowId);
            createRows((_a = workflowInstance === null || workflowInstance === void 0 ? void 0 : workflowInstance.childWorkflowInstances) !== null && _a !== void 0 ? _a : []);
        }
    }, [workflowInstances]);
    useEffect(() => {
        getChildWorkflowInstances();
    }, []);
    if (isLoading) {
        return _jsx(KogitoSpinner, { spinnerText: "Loading child instances..." });
    }
    if (error) {
        return _jsx(ServerErrors, { error: error, variant: "large" });
    }
    if (!isLoading && showNoDataEmptyState) {
        return (_jsx(KogitoEmptyState, { type: KogitoEmptyStateType.Info, title: `No child workflow instances`, body: `This workflow has no related sub workflows` }));
    }
    return (_jsxs(Table, { "aria-label": "Workflow List Child Table", cells: columns, rows: rows, variant: "compact", className: "kogito-management-console__compact-table", ...componentOuiaProps(ouiaId, "workflow-list-child-table", ouiaSafe ? ouiaSafe : !isLoading), children: [_jsx(TableHeader, {}), _jsx(TableBody, {})] }));
};
export default WorkflowListChildTable;
//# sourceMappingURL=WorkflowListChildTable.js.map