import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import * as React from "react";
import { useCallback, useEffect, useImperativeHandle, useRef, useState } from "react";
import { Drawer, DrawerContent, DrawerContentBody, DrawerPanelBody, DrawerPanelContent, } from "@patternfly/react-core/dist/js/components/Drawer";
import { WorkspaceEdit } from "@kie-tools-core/workspace/dist/api";
import { MonacoEditorOperation } from "../monaco/DashbuilderMonacoEditorApi";
import { DashbuilderMonacoEditor } from "../monaco/DashbuilderMonacoEditor";
import { ChannelType, StateControlCommand } from "@kie-tools-core/editor/dist/api";
import { Dashbuilder } from "../dashbuilder/Dashbuilder";
import { Toolbar } from "./Toolbar";
const INITIAL_CONTENT = `datasets:
- uuid: products
  content: >-
            [
              ["Computers", "Scanner", 5, 3],
              ["Computers", "Printer", 7, 4],
              ["Computers", "Laptop", 3, 2],
              ["Electronics", "Camera", 10, 7],
              ["Electronics", "Headphones", 5, 9]
            ]
  columns:
    - id: Section
      type: LABEL
    - id: Product
      type: LABEL
    - id: Quantity
      type: NUMBER
    - id: Quantity2
      type: NUMBER
pages:
- components:
    - html: Welcome to Dashbuilder!
      properties:
        font-size: xx-large
        margin-bottom: 30px
    - settings:
        type: BARCHART
        dataSetLookup:
            uuid: products
            group:
                - columnGroup:
                    source: Product
                  groupFunctions:
                    - source: Product
                    - source: Quantity
                      function: SUM
                    - source: Quantity2
                      function: SUM
    - settings:
        type: TABLE
        dataSetLookup:
            uuid: products`;
const UPDATE_TIME = 1000;
const RefForwardingDashbuilderEditor = (props, forwardedRef) => {
    const [initialContent, setInitialContent] = useState({ originalContent: INITIAL_CONTENT, path: "empty.dash.yml" });
    const [renderContent, setRenderContent] = useState("");
    const [showPreview, setShowPreview] = useState(false);
    const dashbuilderMonacoEditorRef = useRef(null);
    useEffect(() => {
        const timer = setInterval(() => {
            var _a;
            setRenderContent(((_a = dashbuilderMonacoEditorRef.current) === null || _a === void 0 ? void 0 : _a.getContent()) || "");
        }, UPDATE_TIME);
        return () => clearTimeout(timer);
    }, [renderContent]);
    const isVsCode = useCallback(() => {
        return props.channelType === ChannelType.VSCODE_DESKTOP || props.channelType === ChannelType.VSCODE_WEB;
    }, [props]);
    useImperativeHandle(forwardedRef, () => {
        return {
            setContent: (normalizedPosixPathRelativeToTheWorkspaceRoot, newContent) => {
                try {
                    setInitialContent({
                        originalContent: newContent,
                        path: normalizedPosixPathRelativeToTheWorkspaceRoot,
                    });
                    return Promise.resolve();
                }
                catch (e) {
                    console.error(e);
                    return Promise.reject();
                }
            },
            getContent: () => {
                var _a;
                return Promise.resolve(((_a = dashbuilderMonacoEditorRef.current) === null || _a === void 0 ? void 0 : _a.getContent()) || "");
            },
            getPreview: () => {
                return Promise.resolve("");
            },
            undo: () => {
                var _a;
                return ((_a = dashbuilderMonacoEditorRef.current) === null || _a === void 0 ? void 0 : _a.undo()) || Promise.resolve();
            },
            redo: () => {
                var _a;
                return ((_a = dashbuilderMonacoEditorRef.current) === null || _a === void 0 ? void 0 : _a.redo()) || Promise.resolve();
            },
            validate: () => {
                return [];
            },
            setTheme: (theme) => {
                var _a;
                return ((_a = dashbuilderMonacoEditorRef.current) === null || _a === void 0 ? void 0 : _a.setTheme(theme)) || Promise.resolve();
            },
            moveCursorToPosition: (position) => {
                var _a;
                (_a = dashbuilderMonacoEditorRef.current) === null || _a === void 0 ? void 0 : _a.moveCursorToPosition(position);
            },
        };
    }, []);
    const onContentChanged = useCallback((newContent, operation) => {
        var _a, _b;
        if (operation === MonacoEditorOperation.EDIT) {
            props.onNewEdit(new WorkspaceEdit(newContent));
        }
        else if (operation === MonacoEditorOperation.UNDO) {
            if (!isVsCode()) {
                (_a = dashbuilderMonacoEditorRef.current) === null || _a === void 0 ? void 0 : _a.undo();
            }
            props.onStateControlCommandUpdate(StateControlCommand.UNDO);
        }
        else if (operation === MonacoEditorOperation.REDO) {
            if (!isVsCode()) {
                (_b = dashbuilderMonacoEditorRef.current) === null || _b === void 0 ? void 0 : _b.redo();
            }
            props.onStateControlCommandUpdate(StateControlCommand.REDO);
        }
    }, [props, isVsCode]);
    useEffect(() => {
        props.onReady.call(null);
        onContentChanged(initialContent.originalContent);
    }, [initialContent, onContentChanged, props.onReady]);
    const panelContent = (_jsx(DrawerPanelContent, { isResizable: true, defaultSize: showPreview ? "100%" : "50%", children: _jsx(DrawerPanelBody, { hasNoPadding: true, children: _jsx(Dashbuilder, { content: renderContent }) }) }));
    return (_jsxs("div", { style: { height: "100vh", position: "relative" }, children: [_jsx(Toolbar, { onPreviewChange: (v) => setShowPreview(v), preview: showPreview }), _jsx(Drawer, { isExpanded: true, isInline: true, children: _jsx(DrawerContent, { panelContent: panelContent, children: _jsx(DrawerContentBody, { style: { overflow: "hidden" }, children: initialContent.path !== "" && (_jsx(DashbuilderMonacoEditor, { channelType: props.channelType, content: initialContent.originalContent, fileName: initialContent.path, onContentChange: onContentChanged, ref: dashbuilderMonacoEditorRef })) }) }) })] }));
};
export const DashbuilderEditor = React.forwardRef(RefForwardingDashbuilderEditor);
//# sourceMappingURL=DashbuilderEditor.js.map