"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.usePrevious = usePrevious;
var react_1 = require("react");
function usePrevious(value) {
    var ref = (0, react_1.useRef)();
    (0, react_1.useEffect)(function () {
        if (ref.current !== value) {
            ref.current = value;
        }
    }, [value]);
    return ref.current;
}
//# sourceMappingURL=usePrevious.js.map