/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.experimental;

import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.OperationType;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.experimental.DraftChuLDAPLogSchema00Entry;
import com.unboundid.ldap.sdk.experimental.ExperimentalMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class DraftChuLDAPLogSchema00BindEntry
extends DraftChuLDAPLogSchema00Entry {
    @NotNull
    public static final String ATTR_BIND_METHOD = "reqMethod";
    @NotNull
    public static final String ATTR_PROTOCOL_VERSION = "reqVersion";
    private static final long serialVersionUID = 864660009992589945L;
    private final int protocolVersion;
    @NotNull
    private final String bindMethod;
    @Nullable
    private final String saslMechanism;

    public DraftChuLDAPLogSchema00BindEntry(@NotNull Entry entry) throws LDAPException {
        super(entry, OperationType.BIND);
        String versionString = entry.getAttributeValue(ATTR_PROTOCOL_VERSION);
        if (versionString == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExperimentalMessages.ERR_LOGSCHEMA_DECODE_MISSING_REQUIRED_ATTR.get(entry.getDN(), ATTR_PROTOCOL_VERSION));
        }
        try {
            this.protocolVersion = Integer.parseInt(versionString);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExperimentalMessages.ERR_LOGSCHEMA_DECODE_BIND_VERSION_ERROR.get(entry.getDN(), ATTR_PROTOCOL_VERSION, versionString), e);
        }
        String rawMethod = entry.getAttributeValue(ATTR_BIND_METHOD);
        if (rawMethod == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExperimentalMessages.ERR_LOGSCHEMA_DECODE_MISSING_REQUIRED_ATTR.get(entry.getDN(), ATTR_BIND_METHOD));
        }
        String lowerMethod = StaticUtils.toLowerCase(rawMethod);
        if (lowerMethod.equals("simple")) {
            this.bindMethod = "SIMPLE";
            this.saslMechanism = null;
        } else if (lowerMethod.startsWith("sasl/")) {
            this.bindMethod = "SASL";
            this.saslMechanism = rawMethod.substring(5);
        } else {
            this.bindMethod = rawMethod;
            this.saslMechanism = null;
        }
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    @NotNull
    public String getBindMethod() {
        return this.bindMethod;
    }

    @Nullable
    public String getSASLMechanism() {
        return this.saslMechanism;
    }
}

