/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.pipeline;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.AbstractPipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.BucketMetricsParser;
import org.elasticsearch.search.aggregations.pipeline.CumulativeSumPipelineAggregator;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public class CumulativeSumPipelineAggregationBuilder
extends AbstractPipelineAggregationBuilder<CumulativeSumPipelineAggregationBuilder> {
    public static final String NAME = "cumulative_sum";
    private String format;
    public static final ConstructingObjectParser<CumulativeSumPipelineAggregationBuilder, String> PARSER = new ConstructingObjectParser("cumulative_sum", false, (args, name) -> new CumulativeSumPipelineAggregationBuilder((String)name, (List)args[0]));

    public CumulativeSumPipelineAggregationBuilder(String name, String bucketsPath) {
        super(name, NAME, new String[]{bucketsPath});
    }

    CumulativeSumPipelineAggregationBuilder(String name, List<String> bucketsPath) {
        super(name, NAME, bucketsPath.toArray(new String[0]));
    }

    public CumulativeSumPipelineAggregationBuilder(StreamInput in) throws IOException {
        super(in, NAME);
        this.format = in.readOptionalString();
    }

    @Override
    protected final void doWriteTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.format);
    }

    public CumulativeSumPipelineAggregationBuilder format(String format) {
        if (format == null) {
            throw new IllegalArgumentException("[format] must not be null: [" + this.name + "]");
        }
        this.format = format;
        return this;
    }

    public String format() {
        return this.format;
    }

    protected DocValueFormat formatter() {
        if (this.format != null) {
            return new DocValueFormat.Decimal(this.format);
        }
        return DocValueFormat.RAW;
    }

    @Override
    protected PipelineAggregator createInternal(Map<String, Object> metadata) {
        return new CumulativeSumPipelineAggregator(this.name, this.bucketsPaths, this.formatter(), metadata);
    }

    @Override
    protected void validate(PipelineAggregationBuilder.ValidationContext context) {
        if (this.bucketsPaths.length != 1) {
            context.addBucketPathValidationError("must contain a single entry for aggregation [" + this.name + "]");
        }
        context.validateParentAggSequentiallyOrdered(NAME, this.name);
    }

    @Override
    protected final XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.format != null) {
            builder.field(BucketMetricsParser.FORMAT.getPreferredName(), this.format);
        }
        return builder;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.format);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        CumulativeSumPipelineAggregationBuilder other = (CumulativeSumPipelineAggregationBuilder)obj;
        return Objects.equals(this.format, other.format);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    static {
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), BUCKETS_PATH_FIELD);
        PARSER.declareString(CumulativeSumPipelineAggregationBuilder::format, PipelineAggregator.Parser.FORMAT);
    }
}

