/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Enumerated;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.protocol.AddResponseProtocolOp;
import com.unboundid.ldap.protocol.DeleteResponseProtocolOp;
import com.unboundid.ldap.protocol.ExtendedResponseProtocolOp;
import com.unboundid.ldap.protocol.ModifyDNResponseProtocolOp;
import com.unboundid.ldap.protocol.ModifyResponseProtocolOp;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.OperationType;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.ldap.sdk.unboundidds.extensions.MultiUpdateChangesApplied;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class MultiUpdateExtendedResult
extends ExtendedResult {
    @NotNull
    public static final String MULTI_UPDATE_RESULT_OID = "1.3.6.1.4.1.30221.2.6.18";
    private static final long serialVersionUID = -2529988892013489969L;
    @NotNull
    private final List<ObjectPair<OperationType, LDAPResult>> results;
    @Nullable
    private final MultiUpdateChangesApplied changesApplied;

    public MultiUpdateExtendedResult(@NotNull ExtendedResult extendedResult) throws LDAPException {
        super(extendedResult);
        ASN1OctetString value = extendedResult.getValue();
        if (value == null) {
            this.changesApplied = MultiUpdateChangesApplied.NONE;
            this.results = Collections.emptyList();
            return;
        }
        try {
            ASN1Element[] outerSequenceElements = ASN1Sequence.decodeAsSequence(value.getValue()).elements();
            int cav = ASN1Enumerated.decodeAsEnumerated(outerSequenceElements[0]).intValue();
            this.changesApplied = MultiUpdateChangesApplied.valueOf(cav);
            if (this.changesApplied == null) {
                throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_MULTI_UPDATE_RESULT_INVALID_CHANGES_APPLIED.get(cav));
            }
            ASN1Element[] responseSetElements = ASN1Sequence.decodeAsSequence(outerSequenceElements[1]).elements();
            ArrayList<ObjectPair<OperationType, LDAPResult>> rl = new ArrayList<ObjectPair<OperationType, LDAPResult>>(responseSetElements.length);
            block10: for (ASN1Element rse : responseSetElements) {
                ASN1Element[] elements = ASN1Sequence.decodeAsSequence(rse).elements();
                Control[] controls = elements.length == 2 ? Control.decodeControls(ASN1Sequence.decodeAsSequence(elements[1])) : null;
                switch (elements[0].getType()) {
                    case 105: {
                        rl.add(new ObjectPair<OperationType, LDAPResult>(OperationType.ADD, AddResponseProtocolOp.decodeProtocolOp(elements[0]).toLDAPResult(controls)));
                        continue block10;
                    }
                    case 107: {
                        rl.add(new ObjectPair<OperationType, LDAPResult>(OperationType.DELETE, DeleteResponseProtocolOp.decodeProtocolOp(elements[0]).toLDAPResult(controls)));
                        continue block10;
                    }
                    case 120: {
                        rl.add(new ObjectPair<OperationType, ExtendedResult>(OperationType.EXTENDED, ExtendedResponseProtocolOp.decodeProtocolOp(elements[0]).toExtendedResult(controls)));
                        continue block10;
                    }
                    case 103: {
                        rl.add(new ObjectPair<OperationType, LDAPResult>(OperationType.MODIFY, ModifyResponseProtocolOp.decodeProtocolOp(elements[0]).toLDAPResult(controls)));
                        continue block10;
                    }
                    case 109: {
                        rl.add(new ObjectPair<OperationType, LDAPResult>(OperationType.MODIFY_DN, ModifyDNResponseProtocolOp.decodeProtocolOp(elements[0]).toLDAPResult(controls)));
                        continue block10;
                    }
                    default: {
                        throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_MULTI_UPDATE_RESULT_DECODE_INVALID_OP_TYPE.get(StaticUtils.toHex(elements[0].getType())));
                    }
                }
            }
            this.results = Collections.unmodifiableList(rl);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_MULTI_UPDATE_RESULT_CANNOT_DECODE_VALUE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    public MultiUpdateExtendedResult(int messageID, @NotNull ResultCode resultCode, @Nullable String diagnosticMessage, @Nullable String matchedDN, @Nullable String[] referralURLs, @Nullable MultiUpdateChangesApplied changesApplied, @Nullable List<ObjectPair<OperationType, LDAPResult>> results, Control ... controls) throws LDAPException {
        super(messageID, resultCode, diagnosticMessage, matchedDN, referralURLs, MULTI_UPDATE_RESULT_OID, MultiUpdateExtendedResult.encodeValue(changesApplied, results), controls);
        this.changesApplied = changesApplied;
        this.results = results == null ? Collections.emptyList() : Collections.unmodifiableList(results);
    }

    @Nullable
    private static ASN1OctetString encodeValue(@Nullable MultiUpdateChangesApplied changesApplied, @Nullable List<ObjectPair<OperationType, LDAPResult>> results) throws LDAPException {
        if (results == null || results.isEmpty()) {
            return null;
        }
        ArrayList<ASN1Sequence> opElements = new ArrayList<ASN1Sequence>(results.size());
        for (ObjectPair<OperationType, LDAPResult> p : results) {
            ASN1Element protocolOpElement;
            OperationType t = p.getFirst();
            LDAPResult r = p.getSecond();
            switch (t) {
                case ADD: {
                    protocolOpElement = new AddResponseProtocolOp(r).encodeProtocolOp();
                    break;
                }
                case DELETE: {
                    protocolOpElement = new DeleteResponseProtocolOp(r).encodeProtocolOp();
                    break;
                }
                case EXTENDED: {
                    protocolOpElement = new ExtendedResponseProtocolOp(r).encodeProtocolOp();
                    break;
                }
                case MODIFY: {
                    protocolOpElement = new ModifyResponseProtocolOp(r).encodeProtocolOp();
                    break;
                }
                case MODIFY_DN: {
                    protocolOpElement = new ModifyDNResponseProtocolOp(r).encodeProtocolOp();
                    break;
                }
                default: {
                    throw new LDAPException(ResultCode.PARAM_ERROR, ExtOpMessages.ERR_MULTI_UPDATE_RESULT_INVALID_OP_TYPE.get(t.name()));
                }
            }
            Control[] controls = r.getResponseControls();
            if (controls == null || controls.length == 0) {
                opElements.add(new ASN1Sequence(protocolOpElement));
                continue;
            }
            opElements.add(new ASN1Sequence(protocolOpElement, Control.encodeControls(controls)));
        }
        ASN1Sequence valueSequence = new ASN1Sequence(new ASN1Enumerated(changesApplied.intValue()), new ASN1Sequence(opElements));
        return new ASN1OctetString(valueSequence.encode());
    }

    @Nullable
    public MultiUpdateChangesApplied getChangesApplied() {
        return this.changesApplied;
    }

    @NotNull
    public List<ObjectPair<OperationType, LDAPResult>> getResults() {
        return this.results;
    }

    @Override
    @NotNull
    public String getExtendedResultName() {
        return ExtOpMessages.INFO_EXTENDED_RESULT_NAME_MULTI_UPDATE.get();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        Control[] responseControls;
        String[] referralURLs;
        String matchedDN;
        buffer.append("MultiUpdateExtendedResult(resultCode=");
        buffer.append(this.getResultCode());
        int messageID = this.getMessageID();
        if (messageID >= 0) {
            buffer.append(", messageID=");
            buffer.append(messageID);
        }
        buffer.append(", changesApplied=");
        buffer.append(this.changesApplied.name());
        buffer.append(", results={");
        Iterator<ObjectPair<OperationType, LDAPResult>> resultIterator = this.results.iterator();
        while (resultIterator.hasNext()) {
            resultIterator.next().getSecond().toString(buffer);
            if (!resultIterator.hasNext()) continue;
            buffer.append(", ");
        }
        String diagnosticMessage = this.getDiagnosticMessage();
        if (diagnosticMessage != null) {
            buffer.append(", diagnosticMessage='");
            buffer.append(diagnosticMessage);
            buffer.append('\'');
        }
        if ((matchedDN = this.getMatchedDN()) != null) {
            buffer.append(", matchedDN='");
            buffer.append(matchedDN);
            buffer.append('\'');
        }
        if ((referralURLs = this.getReferralURLs()).length > 0) {
            buffer.append(", referralURLs={");
            for (int i = 0; i < referralURLs.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append('\'');
                buffer.append(referralURLs[i]);
                buffer.append('\'');
            }
            buffer.append('}');
        }
        if ((responseControls = this.getResponseControls()).length > 0) {
            buffer.append(", responseControls={");
            for (int i = 0; i < responseControls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(responseControls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

