/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import com.google.common.base.Strings;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.indexer.IndexingDetailInformation;
import org.apache.james.mailbox.indexer.ReIndexer;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.task.Task;
import org.apache.james.task.TaskId;
import org.apache.james.task.TaskManager;
import org.apache.james.task.TaskNotFoundException;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.routes.ReindexingRunningOptionsParser;
import org.apache.james.webadmin.service.PreviousReIndexingService;
import org.apache.james.webadmin.tasks.TaskFromRequest;
import org.apache.james.webadmin.tasks.TaskFromRequestRegistry;
import org.apache.james.webadmin.tasks.TaskRegistrationKey;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.apache.james.webadmin.utils.JsonTransformer;
import spark.Request;
import spark.ResponseTransformer;
import spark.Route;
import spark.Service;

public class MailboxesRoutes
implements Routes {
    private static final String BASE_PATH = "/mailboxes";
    private static final String RE_INDEX_FAILED_MESSAGES_QUERY_PARAM = "reIndexFailedMessagesOf";
    private static final String MAILBOX_PARAM = ":mailbox";
    private static final String UID_PARAM = ":uid";
    private static final String MAILBOX_PATH = "/mailboxes/:mailbox";
    private static final String MESSAGE_PATH = "/mailboxes/:mailbox/mails/:uid";
    static final TaskRegistrationKey RE_INDEX = TaskRegistrationKey.of((String)"reIndex");
    static final String TASK_PARAMETER = "task";
    public static final String ALL_MAILBOXES_TASKS = "allMailboxesTasks";
    public static final String ONE_MAILBOX_TASKS = "oneMailboxTasks";
    public static final String ONE_MAIL_TASKS = "oneMailTasks";
    private final TaskManager taskManager;
    private final JsonTransformer jsonTransformer;
    private final Set<TaskFromRequestRegistry.TaskRegistration> allMailboxesTaskRegistration;
    private final Set<TaskFromRequestRegistry.TaskRegistration> oneMailboxTaskRegistration;
    private final Set<TaskFromRequestRegistry.TaskRegistration> oneMailTaskRegistration;

    private static TaskFromRequest wrap(TaskFromRequest toBeWrapped) {
        return request -> {
            try {
                return toBeWrapped.fromRequest(request);
            }
            catch (MailboxNotFoundException e) {
                throw ErrorResponder.builder().statusCode(404).type(ErrorResponder.ErrorType.NOT_FOUND).message("mailbox not found").cause((Exception)((Object)e)).haltError();
            }
        };
    }

    private static MailboxId extractMailboxId(MailboxId.Factory mailboxIdFactory, Request request) {
        try {
            return mailboxIdFactory.fromString(request.params(MAILBOX_PARAM));
        }
        catch (Exception e) {
            throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Error while parsing 'mailbox'").cause(e).haltError();
        }
    }

    @Inject
    MailboxesRoutes(TaskManager taskManager, JsonTransformer jsonTransformer, @Named(value="allMailboxesTasks") Set<TaskFromRequestRegistry.TaskRegistration> allMailboxesTaskRegistration, @Named(value="oneMailboxTasks") Set<TaskFromRequestRegistry.TaskRegistration> oneMailboxTaskRegistration, @Named(value="oneMailTasks") Set<TaskFromRequestRegistry.TaskRegistration> oneMailTaskRegistration) {
        this.taskManager = taskManager;
        this.jsonTransformer = jsonTransformer;
        this.allMailboxesTaskRegistration = allMailboxesTaskRegistration;
        this.oneMailboxTaskRegistration = oneMailboxTaskRegistration;
        this.oneMailTaskRegistration = oneMailTaskRegistration;
    }

    public String getBasePath() {
        return BASE_PATH;
    }

    public void define(Service service) {
        this.allMailboxesOperations().ifPresent(route -> service.post(BASE_PATH, route, (ResponseTransformer)this.jsonTransformer));
        this.oneMailboxOperations().ifPresent(route -> service.post(MAILBOX_PATH, route, (ResponseTransformer)this.jsonTransformer));
        this.oneMail().ifPresent(route -> service.post(MESSAGE_PATH, route, (ResponseTransformer)this.jsonTransformer));
    }

    private Optional<Route> allMailboxesOperations() {
        return TaskFromRequestRegistry.builder().parameterName(TASK_PARAMETER).registrations(this.allMailboxesTaskRegistration).buildAsRouteOptional(this.taskManager);
    }

    private Optional<Route> oneMailboxOperations() {
        return TaskFromRequestRegistry.builder().parameterName(TASK_PARAMETER).registrations(this.oneMailboxTaskRegistration).buildAsRouteOptional(this.taskManager);
    }

    private Optional<Route> oneMail() {
        return TaskFromRequestRegistry.builder().parameterName(TASK_PARAMETER).registrations(this.oneMailTaskRegistration).buildAsRouteOptional(this.taskManager);
    }

    public static class ReIndexOneMailTaskRegistration
    extends TaskFromRequestRegistry.TaskRegistration {
        @Inject
        public ReIndexOneMailTaskRegistration(ReIndexer reIndexer, MailboxId.Factory mailboxIdFactory) {
            super(RE_INDEX, ReIndexOneMailTaskRegistration.toTask(reIndexer, mailboxIdFactory));
        }

        public static TaskFromRequest toTask(ReIndexer reIndexer, MailboxId.Factory mailboxIdFactory) {
            return MailboxesRoutes.wrap(request -> reIndexer.reIndex(MailboxesRoutes.extractMailboxId(mailboxIdFactory, request), ReIndexOneMailTaskRegistration.extractUid(request)));
        }

        private static MessageUid extractUid(Request request) {
            try {
                return MessageUid.of((long)Long.parseLong(request.params(MailboxesRoutes.UID_PARAM)));
            }
            catch (NumberFormatException e) {
                throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("'uid' needs to be a parsable long").cause((Exception)e).haltError();
            }
        }
    }

    public static class ReIndexOneMailboxTaskRegistration
    extends TaskFromRequestRegistry.TaskRegistration {
        @Inject
        public ReIndexOneMailboxTaskRegistration(ReIndexer reIndexer, MailboxId.Factory mailboxIdFactory) {
            super(RE_INDEX, ReIndexOneMailboxTaskRegistration.toTask(reIndexer, mailboxIdFactory));
        }

        private static TaskFromRequest toTask(ReIndexer reIndexer, MailboxId.Factory mailboxIdFactory) {
            return MailboxesRoutes.wrap(request -> reIndexer.reIndex(MailboxesRoutes.extractMailboxId(mailboxIdFactory, request), ReindexingRunningOptionsParser.parse(request)));
        }
    }

    public static class ReIndexAllMailboxesTaskRegistration
    extends TaskFromRequestRegistry.TaskRegistration {
        @Inject
        public ReIndexAllMailboxesTaskRegistration(ReIndexer reIndexer, PreviousReIndexingService previousReIndexingService, MailboxId.Factory mailboxIdFactory) {
            super(RE_INDEX, MailboxesRoutes.wrap(request -> ReIndexAllMailboxesTaskRegistration.reIndexAll(previousReIndexingService, reIndexer, request)));
        }

        private static Task reIndexAll(PreviousReIndexingService previousReIndexingService, ReIndexer reIndexer, Request request) throws MailboxException {
            boolean indexingCorrection;
            boolean bl = indexingCorrection = !Strings.isNullOrEmpty((String)request.queryParams(MailboxesRoutes.RE_INDEX_FAILED_MESSAGES_QUERY_PARAM));
            if (indexingCorrection) {
                IndexingDetailInformation indexingDetailInformation = ReIndexAllMailboxesTaskRegistration.retrieveIndexingExecutionDetails(previousReIndexingService, request);
                return reIndexer.reIndex(indexingDetailInformation.failures(), ReindexingRunningOptionsParser.parse(request));
            }
            return reIndexer.reIndex(ReindexingRunningOptionsParser.parse(request));
        }

        private static IndexingDetailInformation retrieveIndexingExecutionDetails(PreviousReIndexingService previousReIndexingService, Request request) {
            TaskId taskId = ReIndexAllMailboxesTaskRegistration.getTaskId(request);
            try {
                return previousReIndexingService.retrieveIndexingExecutionDetails(taskId);
            }
            catch (PreviousReIndexingService.NotAnIndexingRetriableTask | PreviousReIndexingService.TaskNotYetFinishedException e) {
                throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Invalid task id").cause((Exception)e).haltError();
            }
            catch (TaskNotFoundException e) {
                throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("TaskId %s does not exist", new Object[]{taskId.asString()}).cause((Exception)((Object)e)).haltError();
            }
        }

        private static TaskId getTaskId(Request request) {
            try {
                String id = request.queryParams(MailboxesRoutes.RE_INDEX_FAILED_MESSAGES_QUERY_PARAM);
                return TaskId.fromString((String)id);
            }
            catch (Exception e) {
                throw ErrorResponder.builder().statusCode(400).cause(e).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Invalid task id").haltError();
            }
        }
    }
}

