/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Map;

public enum DefaultConsistencyLevel implements ConsistencyLevel
{
    ANY(0),
    ONE(1),
    TWO(2),
    THREE(3),
    QUORUM(4),
    ALL(5),
    LOCAL_ONE(10),
    LOCAL_QUORUM(6),
    EACH_QUORUM(7),
    SERIAL(8),
    LOCAL_SERIAL(9);

    private final int protocolCode;
    private static final Map<Integer, DefaultConsistencyLevel> BY_CODE;

    private DefaultConsistencyLevel(int protocolCode) {
        this.protocolCode = protocolCode;
    }

    @Override
    public int getProtocolCode() {
        return this.protocolCode;
    }

    @NonNull
    public static DefaultConsistencyLevel fromCode(int code) {
        DefaultConsistencyLevel level = BY_CODE.get(code);
        if (level == null) {
            throw new IllegalArgumentException("Unknown code: " + code);
        }
        return level;
    }

    @Override
    public boolean isDcLocal() {
        return this == LOCAL_ONE || this == LOCAL_QUORUM || this == LOCAL_SERIAL;
    }

    @Override
    public boolean isSerial() {
        return this == SERIAL || this == LOCAL_SERIAL;
    }

    private static Map<Integer, DefaultConsistencyLevel> mapByCode(DefaultConsistencyLevel[] levels) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (DefaultConsistencyLevel level : levels) {
            builder.put((Object)level.protocolCode, (Object)level);
        }
        return builder.build();
    }

    static {
        BY_CODE = DefaultConsistencyLevel.mapByCode(DefaultConsistencyLevel.values());
    }
}

