/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;

public interface Content {
    public static final int BUFFER_SIZE = 16384;

    public InputStream getInputStream() throws IOException;

    public long size() throws MailboxException;

    default public Publisher<ByteBuffer> reactiveBytes() {
        try {
            return ReactorUtils.toChunks((InputStream)this.getInputStream(), (int)16384).subscribeOn(Schedulers.boundedElastic());
        }
        catch (IOException e) {
            return Flux.error((Throwable)e);
        }
    }
}

