/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util;

import jakarta.mail.util.SharedByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;

public class ClassLoaderUtils {
    public static String getSystemResourceAsString(String filename, Charset charset) {
        try {
            return IOUtils.toString((InputStream)ClassLoader.getSystemResourceAsStream(filename), (Charset)charset);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSystemResourceAsString(String filename) {
        return ClassLoaderUtils.getSystemResourceAsString(filename, StandardCharsets.US_ASCII);
    }

    public static byte[] getSystemResourceAsByteArray(String filename) {
        try {
            return IOUtils.toByteArray((InputStream)ClassLoader.getSystemResourceAsStream(filename));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static SharedByteArrayInputStream getSystemResourceAsSharedStream(String filename) {
        return new SharedByteArrayInputStream(ClassLoaderUtils.getSystemResourceAsByteArray(filename));
    }
}

