/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util.io;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang3.NotImplementedException;

public class CurrentPositionInputStream
extends InputStream {
    private final InputStream wrapped;
    private long position;

    public CurrentPositionInputStream(InputStream wrapped) {
        this.wrapped = wrapped;
        this.position = 0L;
    }

    @Override
    public int read() throws IOException {
        int read = this.wrapped.read();
        if (read > 0) {
            ++this.position;
        }
        return read;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int read = this.wrapped.read(b);
        return this.increaseSize(read);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.wrapped.read(b, off, len);
        return this.increaseSize(read);
    }

    @Override
    public long skip(long n) throws IOException {
        long skipped = this.wrapped.skip(n);
        return this.increaseSize(skipped);
    }

    @Override
    public int available() throws IOException {
        return this.wrapped.available();
    }

    @Override
    public void close() throws IOException {
        this.wrapped.close();
    }

    @Override
    public void mark(int readlimit) {
        throw new NotImplementedException("'mark' is not supported'");
    }

    @Override
    public void reset() {
        throw new NotImplementedException("'reset' is not supported'");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    public long getPosition() {
        return this.position;
    }

    private <T extends Number> T increaseSize(T chunkSize) {
        long longValue = chunkSize.longValue();
        if (longValue > 0L) {
            this.position += longValue;
        }
        return chunkSize;
    }
}

