/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.IteratorCloseable;

class IteratorFlatMap<IN, OUT>
implements IteratorCloseable<OUT> {
    private boolean finished = false;
    private Iterator<OUT> current = null;
    private Iterator<IN> input;
    private final Function<IN, Iterator<OUT>> mapper;

    IteratorFlatMap(Iterator<IN> iter, Function<IN, Iterator<OUT>> mapper) {
        this.input = iter;
        this.mapper = mapper;
    }

    @Override
    public boolean hasNext() {
        if (this.finished) {
            return false;
        }
        if (this.current != null) {
            if (this.current.hasNext()) {
                return true;
            }
            Iter.close(this.current);
            this.current = null;
        }
        while (this.input.hasNext()) {
            IN x = this.input.next();
            this.current = this.mapper.apply(x);
            if (this.current == null) continue;
            if (!this.current.hasNext()) {
                Iter.close(this.current);
                continue;
            }
            return true;
        }
        if (this.current != null) {
            Iter.close(this.current);
        }
        this.current = null;
        this.finished = true;
        return false;
    }

    @Override
    public OUT next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.current.next();
    }

    @Override
    public void forEachRemaining(Consumer<? super OUT> action) {
        if (this.finished) {
            return;
        }
        if (this.current != null) {
            this.current.forEachRemaining(action);
            Iter.close(this.current);
            this.current = null;
        }
        this.input.forEachRemaining((? super E x) -> {
            this.current = this.mapper.apply(x);
            if (this.current == null) {
                return;
            }
            this.current.forEachRemaining(action);
            Iter.close(this.current);
        });
        this.current = null;
    }

    @Override
    public void close() {
        if (this.current != null) {
            Iter.close(this.current);
        }
        Iter.close(this.input);
    }
}

