/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.api;

import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.JsonLdOptions;
import com.apicatalog.jsonld.JsonLdVersion;
import com.apicatalog.jsonld.api.CommonApi;
import com.apicatalog.jsonld.api.ContextApi;
import com.apicatalog.jsonld.api.LoaderApi;
import com.apicatalog.jsonld.document.Document;
import com.apicatalog.jsonld.document.JsonDocument;
import com.apicatalog.jsonld.loader.DocumentLoader;
import com.apicatalog.jsonld.processor.FlatteningProcessor;
import com.apicatalog.jsonld.uri.UriUtils;
import jakarta.json.JsonStructure;
import java.net.URI;

public final class FlatteningApi
implements CommonApi<FlatteningApi>,
LoaderApi<FlatteningApi>,
ContextApi<FlatteningApi> {
    private final URI documentUri;
    private final Document document;
    private Document context;
    private URI contextUri;
    private JsonLdOptions options;

    public FlatteningApi(URI documentUri) {
        this.document = null;
        this.documentUri = documentUri;
        this.context = null;
        this.contextUri = null;
        this.options = new JsonLdOptions();
    }

    public FlatteningApi(Document document) {
        this.document = document;
        this.documentUri = null;
        this.context = null;
        this.contextUri = null;
        this.options = new JsonLdOptions();
    }

    @Override
    public FlatteningApi options(JsonLdOptions options) {
        if (options == null) {
            throw new IllegalArgumentException("Parameter 'options' is null.");
        }
        this.options = options;
        return this;
    }

    @Override
    public FlatteningApi mode(JsonLdVersion processingMode) {
        this.options.setProcessingMode(processingMode);
        return this;
    }

    @Override
    public FlatteningApi base(URI baseUri) {
        this.options.setBase(baseUri);
        return this;
    }

    public FlatteningApi compactArrays(boolean enable) {
        this.options.setCompactArrays(enable);
        return this;
    }

    public FlatteningApi compactArrays() {
        return this.compactArrays(true);
    }

    @Override
    public FlatteningApi loader(DocumentLoader loader) {
        this.options.setDocumentLoader(loader);
        return this;
    }

    @Override
    public FlatteningApi ordered(boolean enable) {
        this.options.setOrdered(enable);
        return this;
    }

    @Override
    public FlatteningApi context(URI contextUri) {
        this.contextUri = contextUri;
        return this;
    }

    @Override
    public FlatteningApi context(String contextLocation) {
        URI contextUri = null;
        if (contextLocation != null && (contextUri = UriUtils.create(contextLocation)) == null) {
            throw new IllegalArgumentException("Context location must be valid URI or null but is [" + contextLocation + ".");
        }
        return this.context(contextUri);
    }

    @Override
    public FlatteningApi context(JsonStructure context2) {
        this.context = context2 != null ? JsonDocument.of(context2) : null;
        return this;
    }

    @Override
    public FlatteningApi context(Document context2) {
        this.context = context2;
        return this;
    }

    public JsonStructure get() throws JsonLdError {
        if (this.document != null && this.context != null) {
            return FlatteningProcessor.flatten(this.document, this.context, this.options);
        }
        if (this.document != null && this.contextUri != null) {
            return FlatteningProcessor.flatten(this.document, this.contextUri, this.options);
        }
        if (this.document != null) {
            return FlatteningProcessor.flatten(this.document, (Document)null, this.options);
        }
        if (this.documentUri != null && this.context != null) {
            return FlatteningProcessor.flatten(this.documentUri, this.context, this.options);
        }
        if (this.documentUri != null && this.contextUri != null) {
            return FlatteningProcessor.flatten(this.documentUri, this.contextUri, this.options);
        }
        if (this.documentUri != null) {
            return FlatteningProcessor.flatten(this.documentUri, (Document)null, this.options);
        }
        throw new IllegalStateException();
    }
}

