/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra;

import java.util.Map;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVisitorBase;
import org.apache.jena.sparql.algebra.OpWalker;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.op.OpGraph;
import org.apache.jena.sparql.algebra.op.OpQuadPattern;
import org.apache.jena.sparql.core.BasicPattern;

public class OpPrefixesUsed {
    public static PrefixMapping used(Op op, PrefixMapping pmap) {
        PrefixMappingImpl pmap2 = new PrefixMappingImpl();
        PrefixFinder finder = new PrefixFinder(pmap2, pmap.getNsPrefixMap());
        OpWalker.walk(op, finder);
        return pmap2;
    }

    static class PrefixFinder
    extends OpVisitorBase {
        Map<String, String> pmap;
        PrefixMapping usedPMap;

        public PrefixFinder(PrefixMapping pmap2, Map<String, String> pmap) {
            this.pmap = pmap;
            this.usedPMap = pmap2;
        }

        @Override
        public void visit(OpGraph opGraph) {
            this.node(opGraph.getNode());
        }

        @Override
        public void visit(OpQuadPattern quadPattern) {
            this.node(quadPattern.getGraphNode());
            this.visit(quadPattern.getBasicPattern());
        }

        @Override
        public void visit(OpBGP opBGP) {
            BasicPattern p = opBGP.getPattern();
            this.visit(opBGP.getPattern());
        }

        private void visit(BasicPattern pattern) {
            for (Triple t : pattern) {
                this.node(t.getSubject());
                this.node(t.getPredicate());
                this.node(t.getObject());
            }
        }

        @Override
        public void visit(OpFilter opFilter) {
        }

        private void node(Node n) {
            if (!n.isURI()) {
                return;
            }
            String uri = n.getURI();
            if (this.usedPMap.shortForm(uri) != uri) {
                return;
            }
            for (Map.Entry<String, String> e2 : this.pmap.entrySet()) {
                String k = e2.getKey();
                String v = e2.getValue();
                if (!uri.startsWith(v)) continue;
                this.usedPMap.setNsPrefix(k, v);
                return;
            }
        }
    }
}

