/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.sandbox.search;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.sandbox.search.AggregatedQueryLeafProfilerResult;
import org.apache.lucene.sandbox.search.QueryLeafProfilerThreadAggregator;
import org.apache.lucene.sandbox.search.QueryProfilerResult;
import org.apache.lucene.sandbox.search.QueryProfilerTimer;
import org.apache.lucene.sandbox.search.QueryProfilerTimingType;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.CollectionUtil;

class QueryProfilerBreakdown {
    private static final Collection<QueryProfilerTimingType> QUERY_LEVEL_TIMING_TYPE = Arrays.stream(QueryProfilerTimingType.values()).filter(t -> !t.isLeafLevel()).toList();
    private final Map<QueryProfilerTimingType, QueryProfilerTimer> queryProfilerTimers = new HashMap<QueryProfilerTimingType, QueryProfilerTimer>();
    private final QueryLeafProfilerThreadAggregator queryLeafProfilerAggregator = new QueryLeafProfilerThreadAggregator();

    public QueryProfilerBreakdown() {
        for (QueryProfilerTimingType timingType : QUERY_LEVEL_TIMING_TYPE) {
            this.queryProfilerTimers.put(timingType, new QueryProfilerTimer());
        }
    }

    public final QueryProfilerTimer getTimer(QueryProfilerTimingType timingType) {
        if (timingType.isLeafLevel()) {
            return this.queryLeafProfilerAggregator.getTimer(timingType);
        }
        return this.queryProfilerTimers.get((Object)timingType);
    }

    public final QueryProfilerResult getQueryProfilerResult(Query query2, List<QueryProfilerResult> childrenProfileResults) {
        long queryStartTime = Long.MAX_VALUE;
        long queryTotalTime = 0L;
        HashMap<Object, Long> breakdownMap = CollectionUtil.newHashMap(QUERY_LEVEL_TIMING_TYPE.size() * 2);
        for (QueryProfilerTimingType type : QUERY_LEVEL_TIMING_TYPE) {
            QueryProfilerTimer timer = this.queryProfilerTimers.get((Object)type);
            if (timer.getCount() > 0L) {
                queryStartTime = Math.min(queryStartTime, timer.getEarliestTimerStartTime());
                queryTotalTime += timer.getApproximateTiming();
            }
            breakdownMap.put(type.toString(), this.queryProfilerTimers.get((Object)type).getApproximateTiming());
            breakdownMap.put(type.toString() + "_count", this.queryProfilerTimers.get((Object)type).getCount());
        }
        List<AggregatedQueryLeafProfilerResult> threadProfilerResults = this.queryLeafProfilerAggregator.getAggregatedQueryLeafProfilerResults();
        queryStartTime = Math.min(queryStartTime, this.queryLeafProfilerAggregator.getQueryStartTime());
        return new QueryProfilerResult(this.getTypeFromQuery(query2), this.getDescriptionFromQuery(query2), Collections.unmodifiableMap(breakdownMap), threadProfilerResults, childrenProfileResults, queryStartTime, queryTotalTime += this.queryLeafProfilerAggregator.getQueryTotalTime());
    }

    private String getTypeFromQuery(Query query2) {
        if (query2.getClass().getSimpleName().isEmpty()) {
            return query2.getClass().getSuperclass().getSimpleName();
        }
        return query2.getClass().getSimpleName();
    }

    private String getDescriptionFromQuery(Query query2) {
        return query2.toString();
    }
}

