/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.comparators;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.Pruning;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.comparators.UpdateableDocIdSetIterator;

public class DocComparator
extends FieldComparator<Integer> {
    private final int[] docIDs;
    private final boolean enableSkipping;
    private int bottom;
    private int topValue;
    private boolean topValueSet;
    private boolean bottomValueSet;
    private boolean hitsThresholdReached;

    public DocComparator(int numHits, boolean reverse, Pruning pruning) {
        this.docIDs = new int[numHits];
        this.enableSkipping = !reverse && pruning != Pruning.NONE;
    }

    @Override
    public int compare(int slot1, int slot2) {
        return this.docIDs[slot1] - this.docIDs[slot2];
    }

    @Override
    public LeafFieldComparator getLeafComparator(LeafReaderContext context2) {
        return new DocLeafComparator(context2);
    }

    @Override
    public void setTopValue(Integer value) {
        this.topValue = value;
        this.topValueSet = true;
    }

    @Override
    public Integer value(int slot) {
        return this.docIDs[slot];
    }

    private class DocLeafComparator
    implements LeafFieldComparator {
        private final int docBase;
        private final int minDoc;
        private final int maxDoc;
        private final UpdateableDocIdSetIterator competitiveIterator;

        public DocLeafComparator(LeafReaderContext context2) {
            this.docBase = context2.docBase;
            if (DocComparator.this.enableSkipping) {
                this.minDoc = DocComparator.this.topValue;
                this.maxDoc = context2.reader().maxDoc();
                this.competitiveIterator = new UpdateableDocIdSetIterator();
                this.competitiveIterator.update(DocIdSetIterator.all(this.maxDoc));
            } else {
                this.minDoc = -1;
                this.maxDoc = -1;
                this.competitiveIterator = null;
            }
        }

        @Override
        public void setBottom(int slot) {
            DocComparator.this.bottom = DocComparator.this.docIDs[slot];
            DocComparator.this.bottomValueSet = true;
            this.updateIterator();
        }

        @Override
        public int compareBottom(int doc) {
            return DocComparator.this.bottom - (this.docBase + doc);
        }

        @Override
        public int compareTop(int doc) {
            int docValue = this.docBase + doc;
            return Integer.compare(DocComparator.this.topValue, docValue);
        }

        @Override
        public void copy(int slot, int doc) throws IOException {
            DocComparator.this.docIDs[slot] = this.docBase + doc;
        }

        @Override
        public void setScorer(Scorable scorer) throws IOException {
            this.updateIterator();
        }

        @Override
        public DocIdSetIterator competitiveIterator() {
            return this.competitiveIterator;
        }

        @Override
        public void setHitsThresholdReached() {
            DocComparator.this.hitsThresholdReached = true;
            this.updateIterator();
        }

        private void updateIterator() {
            if (!DocComparator.this.enableSkipping || !DocComparator.this.hitsThresholdReached) {
                return;
            }
            if (DocComparator.this.bottomValueSet) {
                this.competitiveIterator.update(DocIdSetIterator.empty());
            } else if (DocComparator.this.topValueSet) {
                if (this.docBase + this.maxDoc <= this.minDoc) {
                    this.competitiveIterator.update(DocIdSetIterator.empty());
                } else {
                    int segmentMinDoc = Math.max(this.competitiveIterator.docID(), this.minDoc - this.docBase);
                    segmentMinDoc = Math.max(0, segmentMinDoc);
                    this.competitiveIterator.update(DocIdSetIterator.range(segmentMinDoc, this.maxDoc));
                }
            }
        }
    }
}

