/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.edgegraph;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.locationtech.jts.edgegraph.HalfEdge;
import org.locationtech.jts.geom.Coordinate;

public class EdgeGraph {
    private Map vertexMap = new HashMap();

    protected HalfEdge createEdge(Coordinate orig) {
        return new HalfEdge(orig);
    }

    private HalfEdge create(Coordinate p0, Coordinate p1) {
        HalfEdge e0 = this.createEdge(p0);
        HalfEdge e1 = this.createEdge(p1);
        e0.link(e1);
        return e0;
    }

    public HalfEdge addEdge(Coordinate orig, Coordinate dest) {
        if (!EdgeGraph.isValidEdge(orig, dest)) {
            return null;
        }
        HalfEdge eAdj = (HalfEdge)this.vertexMap.get(orig);
        HalfEdge eSame = null;
        if (eAdj != null) {
            eSame = eAdj.find(dest);
        }
        if (eSame != null) {
            return eSame;
        }
        HalfEdge e2 = this.insert(orig, dest, eAdj);
        return e2;
    }

    public static boolean isValidEdge(Coordinate orig, Coordinate dest) {
        int cmp = dest.compareTo(orig);
        return cmp != 0;
    }

    private HalfEdge insert(Coordinate orig, Coordinate dest, HalfEdge eAdj) {
        HalfEdge e2 = this.create(orig, dest);
        if (eAdj != null) {
            eAdj.insert(e2);
        } else {
            this.vertexMap.put(orig, e2);
        }
        HalfEdge eAdjDest = (HalfEdge)this.vertexMap.get(dest);
        if (eAdjDest != null) {
            eAdjDest.insert(e2.sym());
        } else {
            this.vertexMap.put(dest, e2.sym());
        }
        return e2;
    }

    public Collection getVertexEdges() {
        return this.vertexMap.values();
    }

    public HalfEdge findEdge(Coordinate orig, Coordinate dest) {
        HalfEdge e2 = (HalfEdge)this.vertexMap.get(orig);
        if (e2 == null) {
            return null;
        }
        return e2.find(dest);
    }
}

