/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.impl.console.commands.help.wikidoc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.karaf.shell.impl.console.commands.help.wikidoc.WikiVisitor;
import org.apache.karaf.util.StringEscapeUtils;

public class WikiParser {
    WikiVisitor visitor;

    public WikiParser(WikiVisitor visitor) {
        this.visitor = visitor;
    }

    public void parse(Reader reader) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(reader);
        while ((line = br.readLine()) != null) {
            if (line.startsWith("#")) continue;
            this.parse(line);
        }
    }

    public void parse(String line) {
        String token;
        String unescaped = StringEscapeUtils.unescapeJava(line);
        Tokenizer tokenizer = new Tokenizer(unescaped);
        boolean bold = false;
        boolean first = true;
        while ((token = tokenizer.nextToken("\u001b[h*")) != null) {
            if (first) {
                int i;
                first = false;
                int tabs = 0;
                for (i = 0; i < token.length() && token.charAt(i) == '\t'; ++i) {
                    ++tabs;
                }
                token = token.substring(tabs);
                for (i = 0; i < tabs; ++i) {
                    token = "    " + token;
                }
                for (i = 0; i < token.length() && token.charAt(i) == ' '; ++i) {
                }
                this.visitor.startPara(i);
                token = token.substring(i);
            }
            if ("\u001b".equals(token)) {
                this.parseEsc(tokenizer, token);
                continue;
            }
            if ("[".equals(token)) {
                this.parseLink(tokenizer);
                continue;
            }
            if ("h".equals(token)) {
                this.parseHeading(tokenizer);
                continue;
            }
            if ("*".equals(token)) {
                this.parseEnumeration(tokenizer);
                continue;
            }
            if ("**".equals(token)) {
                bold = !bold;
                this.visitor.bold(bold);
                continue;
            }
            this.visitor.text(token);
        }
        if (first) {
            this.visitor.startPara(0);
        }
        this.visitor.endPara();
    }

    private void parseEsc(Tokenizer tokenizer, String token) {
        this.visitor.text(token + tokenizer.nextToken("\u001b[h*") + tokenizer.nextToken("\u001b[]"));
    }

    private void parseEnumeration(Tokenizer tokenizer) {
        String text = tokenizer.nextToken("-\n");
        this.visitor.enumeration(text.trim());
    }

    private void parseHeading(Tokenizer tokenizer) {
        String level = tokenizer.nextToken("123456789");
        if (level == null) {
            this.visitor.text("h");
            return;
        }
        if (!level.matches("[123456789]")) {
            this.visitor.text("h" + level);
            return;
        }
        String dot = tokenizer.nextToken(".\n");
        if (!".".equals(dot)) {
            this.visitor.text("h" + level + dot);
            return;
        }
        String heading = tokenizer.nextToken("\n");
        if (heading == null) {
            heading = "";
        }
        this.visitor.heading(Integer.parseInt(level), heading.trim());
    }

    private void parseLink(Tokenizer tokenizer) {
        String token = tokenizer.nextToken("]");
        this.visitor.link(token, "");
        tokenizer.nextToken("]");
    }

    public static class Tokenizer {
        final String str;
        int pos;

        public Tokenizer(String str) {
            this.str = str;
        }

        public String nextToken(String delim) {
            StringBuilder sb = new StringBuilder();
            boolean escape = false;
            boolean del = false;
            while (this.pos < this.str.length()) {
                char c = this.str.charAt(this.pos++);
                if (escape) {
                    escape = false;
                    sb.append(c);
                    continue;
                }
                if (c == '\\') {
                    if (del) {
                        --this.pos;
                        break;
                    }
                    escape = true;
                    continue;
                }
                if (delim.indexOf(c) >= 0) {
                    if (sb.length() == 0 || del) {
                        sb.append(c);
                        del = true;
                        continue;
                    }
                    --this.pos;
                    break;
                }
                if (del) {
                    --this.pos;
                    break;
                }
                sb.append(c);
            }
            return sb.length() > 0 ? sb.toString() : null;
        }
    }
}

