/*
 * Decompiled with CFR 0.152.
 */
package org.testng.log4testng;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.testng.Assert;

public class Logger {
    private static int i = 0;
    private static final int TRACE = i++;
    private static final int DEBUG = i++;
    private static final int INFO = i++;
    private static final int WARN = i++;
    private static final int ERROR = i++;
    private static final int FATAL = i++;
    private static final int LEVEL_COUNT = i;
    private static final String PREFIX = "log4testng.";
    private static final String LOGGER_PREFIX = "log4testng.logger.";
    private static final String ROOT_LOGGER = "log4testng.rootLogger";
    private static final String DEBUG_PROPERTY = "log4testng.debug";
    private static PrintStream err = System.err;
    private static PrintStream out = System.out;
    private static final String[] levelNames = new String[LEVEL_COUNT];
    private static final Map<String, Integer> levelMap;
    private static boolean initialized;
    private static final Map<String, Integer> loggerLevels;
    private static final Map<Class, Logger> loggers;
    private static int rootLoggerLevel;
    private static boolean debug;
    private final int level;
    private final Class klass;
    private final String m_className;

    public static synchronized Logger getLogger(Class pClass) {
        Logger.initialize();
        Logger logger = loggers.get(pClass);
        if (logger != null) {
            return logger;
        }
        int level = Logger.getLevel(pClass);
        logger = new Logger(pClass, level);
        loggers.put(pClass, logger);
        return logger;
    }

    public boolean isTraceEnabled() {
        return this.isLevelEnabled(TRACE);
    }

    public void trace(Object message) {
        this.log(TRACE, message, null);
    }

    public void trace(Object message, Throwable t) {
        this.log(TRACE, message, t);
    }

    public boolean isDebugEnabled() {
        return this.isLevelEnabled(DEBUG);
    }

    public void debug(Object message) {
        this.log(DEBUG, message, null);
    }

    public void debug(Object message, Throwable t) {
        this.log(DEBUG, message, t);
    }

    public boolean isInfoEnabled() {
        return this.isLevelEnabled(INFO);
    }

    public void info(Object message) {
        this.log(INFO, message, null);
    }

    public void info(Object message, Throwable t) {
        this.log(INFO, message, t);
    }

    public void warn(Object message) {
        this.log(WARN, message, null);
    }

    public void warn(Object message, Throwable t) {
        this.log(WARN, message, t);
    }

    public void error(Object message) {
        this.log(ERROR, message, null);
    }

    public void error(Object message, Throwable t) {
        this.log(ERROR, message, t);
    }

    public void fatal(Object message) {
        this.log(FATAL, message, null);
    }

    public void fatal(Object message, Throwable t) {
        this.log(FATAL, message, t);
    }

    private Logger(Class pClass, int pLevel) {
        this.level = pLevel;
        this.klass = pClass;
        this.m_className = pClass.getName().substring(pClass.getName().lastIndexOf(46) + 1);
    }

    private static synchronized void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("log4testng.properties");
        if (is == null) {
            return;
        }
        Properties properties = new Properties();
        try {
            properties.load(is);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Logger.checkProperties(properties);
    }

    private static void checkProperties(Properties pProperties) {
        String debugStr = pProperties.getProperty(DEBUG_PROPERTY);
        if (debugStr != null) {
            if (debugStr.equalsIgnoreCase("true")) {
                debug = true;
            } else if (debugStr.equalsIgnoreCase("false")) {
                debug = false;
            } else {
                throw new IllegalArgumentException("Unknown log4testng.debug value " + debugStr);
            }
        }
        Logger.loglog4testng("log4testng.debug set to " + debug);
        String rootLevelStr = pProperties.getProperty(ROOT_LOGGER);
        if (rootLevelStr != null) {
            Integer ilevel = levelMap.get(rootLevelStr.toUpperCase());
            if (ilevel == null) {
                throw new IllegalArgumentException("Unknown level for log4testng.rootLogger " + rootLevelStr + " in log4testng.properties");
            }
            rootLoggerLevel = ilevel;
            Logger.loglog4testng("Root level logger set to " + rootLevelStr + " level.");
        }
        Iterator<Map.Entry<Object, Object>> it = pProperties.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Object, Object> entry = it.next();
            String logger = (String)entry.getKey();
            String level = (String)entry.getValue();
            if (!logger.startsWith(PREFIX)) {
                throw new IllegalArgumentException("Illegal property value: " + logger);
            }
            if (logger.equals(DEBUG_PROPERTY) || logger.equals(ROOT_LOGGER)) continue;
            if (!logger.startsWith(LOGGER_PREFIX)) {
                throw new IllegalArgumentException("Illegal property value: " + logger);
            }
            Integer ilevel = levelMap.get(level.toUpperCase());
            if (ilevel == null) {
                throw new IllegalArgumentException("Unknown level " + level + " for logger " + logger + " in log4testng.properties");
            }
            loggerLevels.put(logger.substring(LOGGER_PREFIX.length()), ilevel);
            Logger.loglog4testng("logger " + logger + " set to " + ilevel + " level.");
        }
    }

    private static int getLevel(Class pClass) {
        String name = pClass.getName();
        Logger.loglog4testng("Getting level for logger " + name);
        while (true) {
            Integer level;
            if ((level = loggerLevels.get(name)) != null) {
                Logger.loglog4testng("Found level " + level + " for logger " + name);
                return level;
            }
            int dot = name.lastIndexOf(46);
            if (dot != -1) {
                Logger.loglog4testng("Found level " + rootLoggerLevel + " for root logger");
                return rootLoggerLevel;
            }
            name = name.substring(0, dot);
        }
    }

    private boolean isLevelEnabled(int pLevel) {
        return this.level <= pLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void log(int pLevel, Object pMessage, Throwable pT) {
        if (this.isLevelEnabled(pLevel)) {
            PrintStream ps;
            PrintStream printStream = ps = pLevel >= ERROR ? err : out;
            if (null != pT) {
                PrintStream printStream2 = ps;
                synchronized (printStream2) {
                    ps.println("[" + this.m_className + "] [" + levelNames[pLevel] + "] " + pMessage);
                    pT.printStackTrace(ps);
                }
            } else {
                ps.println("[" + this.m_className + "] [" + levelNames[pLevel] + "] " + pMessage);
            }
        }
    }

    private static void loglog4testng(String pmessage) {
        if (debug) {
            out.println("[log4testng] [debug] " + pmessage);
        }
    }

    private static synchronized void testInitialize(Properties pProperties, PrintStream pOut, PrintStream pErr) {
        initialized = true;
        loggers.clear();
        rootLoggerLevel = WARN;
        debug = false;
        out = pOut;
        err = pErr;
        Logger.checkProperties(pProperties);
    }

    private static void testDebugDefault() {
        Properties props = new Properties();
        ByteArrayOutputStream out1 = new ByteArrayOutputStream();
        ByteArrayOutputStream err1 = new ByteArrayOutputStream();
        PrintStream out2 = new PrintStream(out1);
        PrintStream err2 = new PrintStream(err1);
        props.put(ROOT_LOGGER, "WARN");
        Logger.testInitialize(props, out2, err2);
        Assert.assertEquals(out1.toString(), "");
        Assert.assertEquals(err1.toString(), "");
    }

    private static void testDebugOn() {
        Properties props = new Properties();
        ByteArrayOutputStream out1 = new ByteArrayOutputStream();
        ByteArrayOutputStream err1 = new ByteArrayOutputStream();
        PrintStream out2 = new PrintStream(out1);
        PrintStream err2 = new PrintStream(err1);
        props.put(DEBUG_PROPERTY, "true");
        props.put(ROOT_LOGGER, "WARN");
        Logger.testInitialize(props, out2, err2);
        Assert.assertTrue(out1.toString().startsWith("[log4testng][debug]"));
        Assert.assertEquals(err1.toString(), "");
    }

    private static void testDebugOff() {
        Properties props = new Properties();
        ByteArrayOutputStream out1 = new ByteArrayOutputStream();
        ByteArrayOutputStream err1 = new ByteArrayOutputStream();
        PrintStream out2 = new PrintStream(out1);
        PrintStream err2 = new PrintStream(err1);
        props.put(DEBUG_PROPERTY, "false");
        props.put(ROOT_LOGGER, "WARN");
        Logger.testInitialize(props, out2, err2);
        Assert.assertEquals(out1.toString(), "");
        Assert.assertEquals(err1.toString(), "");
    }

    private static void testDebugError() {
        Properties props = new Properties();
        ByteArrayOutputStream out1 = new ByteArrayOutputStream();
        ByteArrayOutputStream err1 = new ByteArrayOutputStream();
        PrintStream out2 = new PrintStream(out1);
        PrintStream err2 = new PrintStream(err1);
        props.put(DEBUG_PROPERTY, "unknown");
        props.put(ROOT_LOGGER, "WARN");
        try {
            Logger.testInitialize(props, out2, err2);
            throw new RuntimeException("failure");
        }
        catch (IllegalArgumentException pEx) {
            Assert.assertEquals(out1.toString(), "");
            Assert.assertEquals(err1.toString(), "");
            return;
        }
    }

    private static void testRootLoggerDefault() {
        Properties props = new Properties();
        ByteArrayOutputStream out1 = new ByteArrayOutputStream();
        ByteArrayOutputStream err1 = new ByteArrayOutputStream();
        PrintStream out2 = new PrintStream(out1);
        PrintStream err2 = new PrintStream(err1);
        Logger.testInitialize(props, out2, err2);
        Logger strLogger = Logger.getLogger(String.class);
        strLogger.trace("trace should not appear");
        Assert.assertEquals(out1.toString(), "");
        Assert.assertEquals(err1.toString(), "");
        strLogger.debug("debug should not appear");
        Assert.assertEquals(out1.toString(), "");
        Assert.assertEquals(err1.toString(), "");
        strLogger.info("info should not appear");
        Assert.assertEquals(out1.toString(), "");
        Assert.assertEquals(err1.toString(), "");
        strLogger.warn("warn should appear");
        int outlength = out1.toString().length();
        Assert.assertTrue(out1.toString().startsWith("[java.lang.String] [WARN] warn should appear"));
        Assert.assertEquals(err1.toString(), "");
        strLogger.error("error should appear");
        Assert.assertEquals(out1.toString().length(), outlength);
        Assert.assertTrue(err1.toString().startsWith("[java.lang.String] [ERROR] error should appear"));
        strLogger.fatal("fatal should appear");
        Assert.assertEquals(out1.toString().length(), outlength);
        Assert.assertTrue(err1.toString().contains("[java.lang.String] [FATAL] fatal should appear"));
    }

    private static void testRootLoggerSet() {
        Properties props = new Properties();
        ByteArrayOutputStream out1 = new ByteArrayOutputStream();
        ByteArrayOutputStream err1 = new ByteArrayOutputStream();
        PrintStream out2 = new PrintStream(out1);
        PrintStream err2 = new PrintStream(err1);
        props.put(ROOT_LOGGER, "DEBUG");
        Logger.testInitialize(props, out2, err2);
        Logger strLogger = Logger.getLogger(String.class);
        strLogger.trace("trace should appear");
        Assert.assertEquals(out1.toString(), "");
        Assert.assertEquals(err1.toString(), "");
        strLogger.debug("debug should appear");
        Assert.assertTrue(out1.toString().startsWith("[java.lang.String] [DEBUG] debug should appear"));
        Assert.assertEquals(err1.toString(), "");
    }

    private static void testRootLoggerSetError() {
        Properties props = new Properties();
        ByteArrayOutputStream out1 = new ByteArrayOutputStream();
        ByteArrayOutputStream err1 = new ByteArrayOutputStream();
        PrintStream out2 = new PrintStream(out1);
        PrintStream err2 = new PrintStream(err1);
        props.put(ROOT_LOGGER, "unknown");
        try {
            Logger.testInitialize(props, out2, err2);
            throw new RuntimeException("failure");
        }
        catch (IllegalArgumentException pEx) {
            Assert.assertEquals(out1.toString(), "");
            Assert.assertEquals(err1.toString(), "");
            return;
        }
    }

    private static void testUserLoggerSet() {
        Properties props = new Properties();
        ByteArrayOutputStream out1 = new ByteArrayOutputStream();
        ByteArrayOutputStream err1 = new ByteArrayOutputStream();
        PrintStream out2 = new PrintStream(out1);
        PrintStream err2 = new PrintStream(err1);
        props.put("log4testng.logger.java.lang.String", "DEBUG");
        Logger.testInitialize(props, out2, err2);
        Logger strLogger = Logger.getLogger(String.class);
        strLogger.trace("trace should not appear");
        Assert.assertEquals(out1.toString(), "");
        Assert.assertEquals(err1.toString(), "");
        strLogger.debug("debug should appear");
        int outLength = out1.toString().length();
        Assert.assertTrue(out1.toString().startsWith("[java.lang.String] [DEBUG] debug should appear"));
        Assert.assertEquals(err1.toString(), "");
        Logger classLogger = Logger.getLogger(Class.class);
        classLogger.debug("debug should not appear");
        Assert.assertEquals(out1.toString().length(), outLength);
        Assert.assertEquals(err1.toString(), "");
        classLogger.warn("warn should appear");
        Assert.assertTrue(out1.toString().contains("[java.lang.Class] [WARN] warn should appear"));
        Assert.assertEquals(err1.toString(), "");
    }

    private static void testUserLoggerSetError() {
        Properties props = new Properties();
        ByteArrayOutputStream out1 = new ByteArrayOutputStream();
        ByteArrayOutputStream err1 = new ByteArrayOutputStream();
        PrintStream out2 = new PrintStream(out1);
        PrintStream err2 = new PrintStream(err1);
        props.put("log4testng.logger.java.lang.String", "unknown");
        try {
            Logger.testInitialize(props, out2, err2);
            throw new RuntimeException("failure");
        }
        catch (IllegalArgumentException pEx) {
            Assert.assertEquals(out1.toString(), "");
            Assert.assertEquals(err1.toString(), "");
            return;
        }
    }

    private static void testUserLoggerSetHierarchy() {
        Properties props = new Properties();
        ByteArrayOutputStream out1 = new ByteArrayOutputStream();
        ByteArrayOutputStream err1 = new ByteArrayOutputStream();
        PrintStream out2 = new PrintStream(out1);
        PrintStream err2 = new PrintStream(err1);
        props.put("log4testng.logger.java.lang", "DEBUG");
        Logger.testInitialize(props, out2, err2);
        Logger strLogger = Logger.getLogger(String.class);
        strLogger.trace("trace should not appear");
        Assert.assertEquals(out1.toString(), "");
        Assert.assertEquals(err1.toString(), "");
        strLogger.debug("debug should appear");
        Assert.assertTrue(out1.toString().startsWith("[java.lang.String] [DEBUG] debug should appear"));
        Assert.assertEquals(err1.toString(), "");
    }

    public static void main(String[] pArgs) {
        Logger.testDebugDefault();
        Logger.testDebugOn();
        Logger.testDebugOff();
        Logger.testDebugError();
        Logger.testRootLoggerDefault();
        Logger.testRootLoggerSet();
        Logger.testRootLoggerSetError();
        Logger.testUserLoggerSet();
        Logger.testUserLoggerSetError();
        Logger.testUserLoggerSetHierarchy();
    }

    static {
        Logger.levelNames[Logger.TRACE] = "TRACE";
        Logger.levelNames[Logger.DEBUG] = "DEBUG";
        Logger.levelNames[Logger.INFO] = "INFO";
        Logger.levelNames[Logger.WARN] = "WARN";
        Logger.levelNames[Logger.ERROR] = "ERROR";
        Logger.levelNames[Logger.FATAL] = "FATAL";
        levelMap = new HashMap<String, Integer>();
        for (i = 0; i < LEVEL_COUNT; ++i) {
            levelMap.put(levelNames[i], new Integer(i));
        }
        loggerLevels = new HashMap<String, Integer>();
        loggers = new HashMap<Class, Logger>();
        rootLoggerLevel = WARN;
        debug = false;
    }
}

