/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.internal.ProjectSegment;
import org.apache.maven.lifecycle.internal.TaskSegment;
import org.apache.maven.project.MavenProject;

public class ProjectBuildList
implements Iterable<ProjectSegment> {
    private final List<ProjectSegment> items;

    public ProjectBuildList(List<ProjectSegment> items) {
        this.items = Collections.unmodifiableList(items);
    }

    public ProjectBuildList getByTaskSegment(TaskSegment taskSegment) {
        return new ProjectBuildList(this.items.stream().filter(pb -> taskSegment == pb.getTaskSegment()).collect(Collectors.toList()));
    }

    public Map<MavenProject, ProjectSegment> selectSegment(TaskSegment taskSegment) {
        return this.items.stream().filter(pb -> taskSegment == pb.getTaskSegment()).collect(Collectors.toMap(ProjectSegment::getProject, Function.identity()));
    }

    public ProjectSegment findByMavenProject(MavenProject mavenProject) {
        return this.items.stream().filter(pb -> mavenProject.equals(pb.getProject())).findFirst().orElse(null);
    }

    @Override
    public Iterator<ProjectSegment> iterator() {
        return this.items.iterator();
    }

    public void closeAll() {
        for (ProjectSegment item : this.items) {
            MavenSession sessionForThisModule = item.getSession();
            sessionForThisModule.setCurrentProject(null);
        }
    }

    public int size() {
        return this.items.size();
    }

    public ProjectSegment get(int index) {
        return this.items.get(index);
    }

    public Set<String> getReactorProjectKeys() {
        HashSet<String> projectKeys = new HashSet<String>(this.items.size() * 2);
        for (ProjectSegment projectBuild : this.items) {
            MavenProject project = projectBuild.getProject();
            String key = ArtifactUtils.key((String)project.getGroupId(), (String)project.getArtifactId(), (String)project.getVersion());
            projectKeys.add(key);
        }
        return projectKeys;
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public Set<MavenProject> getProjects() {
        return this.items.stream().map(ProjectSegment::getProject).collect(Collectors.toSet());
    }
}

