/*
 * Decompiled with CFR 0.152.
 */
package org.jline.consoleui.prompt.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jline.consoleui.elements.Text;
import org.jline.consoleui.prompt.builder.PromptBuilder;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;

public class TextBuilder {
    private final PromptBuilder promptBuilder;
    private final List<AttributedString> lines = new ArrayList<AttributedString>();

    public TextBuilder(PromptBuilder promptBuilder) {
        this.promptBuilder = promptBuilder;
    }

    public TextBuilder addLine(AttributedString text) {
        this.lines.add(text);
        return this;
    }

    public TextBuilder addLine(String line) {
        this.lines.add(new AttributedString((CharSequence)line));
        return this;
    }

    public TextBuilder addLine(AttributedStyle style, String line) {
        AttributedStringBuilder asb = new AttributedStringBuilder();
        asb.append((CharSequence)line, style);
        this.lines.add(asb.toAttributedString());
        return this;
    }

    public TextBuilder addLines(AttributedString ... lines) {
        this.lines.addAll(Arrays.asList(lines));
        return this;
    }

    public TextBuilder addLines(String ... lines) {
        for (String s : lines) {
            this.lines.add(new AttributedString((CharSequence)s));
        }
        return this;
    }

    public TextBuilder addLines(AttributedStyle style, String ... lines) {
        for (String s : lines) {
            AttributedStringBuilder asb = new AttributedStringBuilder();
            asb.append((CharSequence)s, style);
            this.lines.add(asb.toAttributedString());
        }
        return this;
    }

    public PromptBuilder addPrompt() {
        Text text = new Text(this.lines);
        this.promptBuilder.addPrompt(text);
        return this.promptBuilder;
    }
}

