/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.event;

import jakarta.el.ValueExpression;
import jakarta.faces.component.StateHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIComponentBase;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.ActionEvent;
import java.lang.invoke.MethodHandles;
import org.apache.myfaces.tobago.event.AbstractResetInputActionListener;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueExpressionResetInputActionListener
extends AbstractResetInputActionListener
implements StateHolder {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private ValueExpression clientIdsExpression;

    public ValueExpressionResetInputActionListener() {
    }

    public ValueExpressionResetInputActionListener(ValueExpression clientIdsExpression) {
        this.clientIdsExpression = clientIdsExpression;
    }

    public void processAction(ActionEvent event) {
        String[] clientIds;
        Object obj = this.clientIdsExpression.getValue(FacesContext.getCurrentInstance().getELContext());
        if (obj instanceof String[]) {
            clientIds = (String[])obj;
        } else if (obj instanceof String) {
            clientIds = StringUtils.split((String)obj, ", ");
        } else {
            LOG.error("Ignore unknown value of " + String.valueOf(obj) + " for reset.");
            return;
        }
        for (String clientId : clientIds) {
            UIComponent component = ComponentUtils.findComponent(event.getComponent(), clientId);
            if (component == null) continue;
            this.resetChildren(component);
        }
    }

    public boolean isTransient() {
        return false;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.clientIdsExpression = (ValueExpression)UIComponentBase.restoreAttachedState((FacesContext)context, (Object)values[0]);
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{UIComponentBase.saveAttachedState((FacesContext)context, (Object)this.clientIdsExpression)};
        return values;
    }

    public void setTransient(boolean newTransientValue) {
    }
}

