/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.jackson;

import jakarta.servlet.http.Cookie;
import org.springframework.security.jackson.SecurityJacksonModule;
import org.springframework.security.web.authentication.WebAuthenticationDetails;
import org.springframework.security.web.authentication.switchuser.SwitchUserGrantedAuthority;
import org.springframework.security.web.jackson.CookieMixin;
import org.springframework.security.web.jackson.DefaultSavedRequestMixin;
import org.springframework.security.web.jackson.SavedCookieMixin;
import org.springframework.security.web.jackson.SwitchUserGrantedAuthorityMixIn;
import org.springframework.security.web.jackson.WebAuthenticationDetailsMixin;
import org.springframework.security.web.savedrequest.DefaultSavedRequest;
import org.springframework.security.web.savedrequest.SavedCookie;
import org.springframework.security.web.server.csrf.DefaultCsrfToken;
import tools.jackson.core.Version;
import tools.jackson.databind.JacksonModule;
import tools.jackson.databind.jsontype.BasicPolymorphicTypeValidator;

public class WebServletJacksonModule
extends SecurityJacksonModule {
    public WebServletJacksonModule() {
        super(WebServletJacksonModule.class.getName(), new Version(1, 0, 0, null, null, null));
    }

    public void configurePolymorphicTypeValidator(BasicPolymorphicTypeValidator.Builder builder) {
        builder.allowIfSubType(Cookie.class).allowIfSubType(DefaultCsrfToken.class);
    }

    public void setupModule(JacksonModule.SetupContext context) {
        context.setMixIn(Cookie.class, CookieMixin.class);
        context.setMixIn(SavedCookie.class, SavedCookieMixin.class);
        context.setMixIn(DefaultSavedRequest.class, DefaultSavedRequestMixin.class);
        context.setMixIn(WebAuthenticationDetails.class, WebAuthenticationDetailsMixin.class);
        context.setMixIn(SwitchUserGrantedAuthority.class, SwitchUserGrantedAuthorityMixIn.class);
    }
}

