/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.backup;

import jakarta.inject.Inject;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.text.WordUtils;
import org.apache.openmeetings.backup.BackupException;
import org.apache.openmeetings.backup.BackupVersion;
import org.apache.openmeetings.backup.FileTree;
import org.apache.openmeetings.backup.converter.WbConverter;
import org.apache.openmeetings.core.converter.DocumentConverter;
import org.apache.openmeetings.db.bind.adapter.AppointmentAdapter;
import org.apache.openmeetings.db.bind.adapter.FileAdapter;
import org.apache.openmeetings.db.bind.adapter.GroupAdapter;
import org.apache.openmeetings.db.bind.adapter.OmCalendarAdapter;
import org.apache.openmeetings.db.bind.adapter.RoomAdapter;
import org.apache.openmeetings.db.bind.adapter.UserAdapter;
import org.apache.openmeetings.db.dao.basic.ChatDao;
import org.apache.openmeetings.db.dao.basic.ConfigurationDao;
import org.apache.openmeetings.db.dao.calendar.AppointmentDao;
import org.apache.openmeetings.db.dao.calendar.MeetingMemberDao;
import org.apache.openmeetings.db.dao.calendar.OmCalendarDao;
import org.apache.openmeetings.db.dao.file.BaseFileItemDao;
import org.apache.openmeetings.db.dao.file.FileItemDao;
import org.apache.openmeetings.db.dao.record.RecordingDao;
import org.apache.openmeetings.db.dao.room.ExtraMenuDao;
import org.apache.openmeetings.db.dao.room.PollDao;
import org.apache.openmeetings.db.dao.room.RoomDao;
import org.apache.openmeetings.db.dao.server.LdapConfigDao;
import org.apache.openmeetings.db.dao.server.OAuth2Dao;
import org.apache.openmeetings.db.dao.user.GroupDao;
import org.apache.openmeetings.db.dao.user.PrivateMessageDao;
import org.apache.openmeetings.db.dao.user.PrivateMessageFolderDao;
import org.apache.openmeetings.db.dao.user.UserContactDao;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.dto.room.Whiteboard;
import org.apache.openmeetings.db.entity.basic.ChatMessage;
import org.apache.openmeetings.db.entity.basic.Configuration;
import org.apache.openmeetings.db.entity.calendar.Appointment;
import org.apache.openmeetings.db.entity.calendar.MeetingMember;
import org.apache.openmeetings.db.entity.calendar.OmCalendar;
import org.apache.openmeetings.db.entity.file.BaseFileItem;
import org.apache.openmeetings.db.entity.file.FileItem;
import org.apache.openmeetings.db.entity.record.Recording;
import org.apache.openmeetings.db.entity.record.RecordingChunk;
import org.apache.openmeetings.db.entity.room.ExtraMenu;
import org.apache.openmeetings.db.entity.room.Room;
import org.apache.openmeetings.db.entity.room.RoomFile;
import org.apache.openmeetings.db.entity.room.RoomGroup;
import org.apache.openmeetings.db.entity.room.RoomModerator;
import org.apache.openmeetings.db.entity.room.RoomPoll;
import org.apache.openmeetings.db.entity.room.RoomPollAnswer;
import org.apache.openmeetings.db.entity.server.LdapConfig;
import org.apache.openmeetings.db.entity.server.OAuthServer;
import org.apache.openmeetings.db.entity.user.Group;
import org.apache.openmeetings.db.entity.user.GroupUser;
import org.apache.openmeetings.db.entity.user.PrivateMessage;
import org.apache.openmeetings.db.entity.user.PrivateMessageFolder;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.db.entity.user.UserContact;
import org.apache.openmeetings.db.util.AuthLevelUtil;
import org.apache.openmeetings.db.util.XmlHelper;
import org.apache.openmeetings.util.OmFileHelper;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.openmeetings.util.StoredFile;
import org.apache.openmeetings.util.crypt.SCryptImplementation;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BackupImport {
    private static final Logger log = LoggerFactory.getLogger(BackupImport.class);
    private static final Map<String, String> outdatedConfigKeys = Map.ofEntries(Map.entry("crypt_ClassName", "crypt.class.name"), Map.entry("system_email_addr", "mail.smtp.system.email"), Map.entry("smtp_server", "mail.smtp.server"), Map.entry("smtp_port", "mail.smtp.port"), Map.entry("email_username", "mail.smtp.user"), Map.entry("email_userpass", "mail.smtp.pass"), Map.entry("default_lang_id", "default.lang.id"), Map.entry("allow_frontend_register", "allow.frontend.register"), Map.entry("max_upload_size", "max.upload.size"), Map.entry("rss_feed1", "dashboard.rss.feed1"), Map.entry("rss_feed2", "dashboard.rss.feed2"), Map.entry("oauth2.ignore_bad_ssl", "oauth2.ignore.bad.ssl"), Map.entry("default.quality.screensharing", "screensharing.default.quality"), Map.entry("default.fps.screensharing", "screensharing.default.fps"), Map.entry("ldap_default_id", "default.ldap.id"), Map.entry("default_group_id", "default.group.id"), Map.entry("imagemagick_path", "path.imagemagick"), Map.entry("sox_path", "path.sox"), Map.entry("ffmpeg_path", "path.ffmpeg"), Map.entry("office.path", "path.office"), Map.entry("red5sip.enable", "sip.enable"), Map.entry("red5sip.room_prefix", "sip.room.prefix"), Map.entry("red5sip.exten_context", "sip.exten.context"), Map.entry("sendEmailAtRegister", "send.email.at.register"), Map.entry("sendEmailWithVerficationCode", "send.email.with.verfication"), Map.entry("swftools_zoom", "document.dpi"), Map.entry("swftools_jpegquality", "document.quality"), Map.entry("sms.subject", "reminder.message"), Map.entry("exclusive.audio.keycode", "mute.others.keycode"), Map.entry("header.csp.frame.options", "header.csp.frame"));
    private static final Map<String, Configuration.Type> configTypes = Map.ofEntries(Map.entry("allow.frontend.register", Configuration.Type.BOOL), Map.entry("allow.soap.register", Configuration.Type.BOOL), Map.entry("allow.oauth.register", Configuration.Type.BOOL), Map.entry("mail.smtp.starttls.enable", Configuration.Type.BOOL), Map.entry("send.email.at.register", Configuration.Type.BOOL), Map.entry("send.email.with.verfication", Configuration.Type.BOOL), Map.entry("sip.enable", Configuration.Type.BOOL), Map.entry("screensharing.fps.show", Configuration.Type.BOOL), Map.entry("screensharing.allow.remote", Configuration.Type.BOOL), Map.entry("dashboard.show.myrooms", Configuration.Type.BOOL), Map.entry("dashboard.show.chat", Configuration.Type.BOOL), Map.entry("dashboard.show.rssfeed", Configuration.Type.BOOL), Map.entry("inviter.email.as.replyto", Configuration.Type.BOOL), Map.entry("oauth2.ignore.bad.ssl", Configuration.Type.BOOL), Map.entry("personal.rooms.enabled", Configuration.Type.BOOL), Map.entry("default.group.id", Configuration.Type.NUMBER), Map.entry("mail.smtp.port", Configuration.Type.NUMBER), Map.entry("mail.smtp.connection.timeout", Configuration.Type.NUMBER), Map.entry("mail.smtp.timeout", Configuration.Type.NUMBER), Map.entry("default.lang.id", Configuration.Type.NUMBER), Map.entry("document.dpi", Configuration.Type.NUMBER), Map.entry("document.quality", Configuration.Type.NUMBER), Map.entry("screensharing.default.quality", Configuration.Type.NUMBER), Map.entry("screensharing.default.fps", Configuration.Type.NUMBER), Map.entry("max.upload.size", Configuration.Type.NUMBER), Map.entry("number.minutes.reminder.send", Configuration.Type.NUMBER), Map.entry("user.login.minimum.length", Configuration.Type.NUMBER), Map.entry("user.pass.minimum.length", Configuration.Type.NUMBER), Map.entry("calendar.conference.rooms.default.size", Configuration.Type.NUMBER), Map.entry("video.arrange.keycode", Configuration.Type.HOTKEY), Map.entry("mute.others.keycode", Configuration.Type.HOTKEY), Map.entry("mute.keycode", Configuration.Type.HOTKEY), Map.entry("default.ldap.id", Configuration.Type.NUMBER), Map.entry("cam.fps", Configuration.Type.NUMBER), Map.entry("mic.rate", Configuration.Type.NUMBER), Map.entry("mic.echo.cancellation", Configuration.Type.BOOL), Map.entry("mic.noise.suppression", Configuration.Type.BOOL), Map.entry("external.process.ttl", Configuration.Type.NUMBER), Map.entry("recording.enabled", Configuration.Type.BOOL), Map.entry("path.ffmpeg", Configuration.Type.PATH), Map.entry("path.imagemagick", Configuration.Type.PATH), Map.entry("path.office", Configuration.Type.PATH), Map.entry("path.sox", Configuration.Type.PATH));
    private static final Pattern UUID_PATTERN = Pattern.compile("^[\\da-f]{8}(?:-[\\da-f]{4}){3}-[\\da-f]{12}$");
    @Inject
    private AppointmentDao appointmentDao;
    @Inject
    private OmCalendarDao calendarDao;
    @Inject
    private RoomDao roomDao;
    @Inject
    private UserDao userDao;
    @Inject
    private RecordingDao recordingDao;
    @Inject
    private PrivateMessageFolderDao privateMessageFolderDao;
    @Inject
    private PrivateMessageDao privateMessageDao;
    @Inject
    private MeetingMemberDao meetingMemberDao;
    @Inject
    private LdapConfigDao ldapConfigDao;
    @Inject
    private FileItemDao fileItemDao;
    @Inject
    private UserContactDao userContactDao;
    @Inject
    private PollDao pollDao;
    @Inject
    private ConfigurationDao cfgDao;
    @Inject
    private ChatDao chatDao;
    @Inject
    private OAuth2Dao auth2Dao;
    @Inject
    private GroupDao groupDao;
    @Inject
    private ExtraMenuDao menuDao;
    @Inject
    private DocumentConverter docConverter;
    private final Map<Long, Long> ldapMap = new HashMap<Long, Long>();
    private final Map<Long, Long> oauthMap = new HashMap<Long, Long>();
    private final Map<Long, Long> userMap = new HashMap<Long, Long>();
    private final Map<Long, Long> groupMap = new HashMap<Long, Long>();
    private final Map<Long, Long> calendarMap = new HashMap<Long, Long>();
    private final Map<Long, Long> appointmentMap = new HashMap<Long, Long>();
    private final Map<Long, Long> roomMap = new HashMap<Long, Long>();
    private final Map<Long, Long> fileItemMap = new HashMap<Long, Long>();
    private final Map<Long, Long> messageFolderMap = new HashMap<Long, Long>();
    private final Map<Long, Long> userContactMap = new HashMap<Long, Long>();
    private final Map<String, String> fileMap = new HashMap<String, String>();
    private final Map<String, String> hashMap = new HashMap<String, String>();

    private static File validate(String ename, File intended) throws IOException {
        String intendedPath = intended.getCanonicalPath();
        File fentry = new File(intended, ename);
        String canonicalPath = fentry.getCanonicalPath();
        if (canonicalPath.startsWith(intendedPath)) {
            return fentry;
        }
        throw new IllegalStateException("File is outside extraction target directory.");
    }

    private static File unzip(InputStream is) throws IOException {
        File f = OmFileHelper.getNewDir((File)OmFileHelper.getUploadImportDir(), (String)UUID.randomUUID().toString());
        log.debug("##### EXTRACTING BACKUP TO: {}", (Object)f);
        try (ZipInputStream zis = new ZipInputStream(is);){
            ZipEntry zipentry = null;
            while ((zipentry = zis.getNextEntry()) != null) {
                File dir;
                File fentry = BackupImport.validate(zipentry.getName(), f);
                File file = dir = zipentry.isDirectory() ? fentry : fentry.getParentFile();
                if (!dir.exists() && !dir.mkdirs()) {
                    log.warn("Failed to create folders: {}", (Object)dir);
                }
                if (fentry.isDirectory()) continue;
                try (FileOutputStream fos = FileUtils.openOutputStream((File)fentry);){
                    IOUtils.copy((InputStream)zis, (OutputStream)fos);
                }
                zis.closeEntry();
            }
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performImport(InputStream is, AtomicInteger progress) throws Exception {
        boolean success;
        block8: {
            File f = null;
            success = false;
            try {
                progress.set(0);
                this.cleanup();
                this.messageFolderMap.put(PrivateMessage.INBOX_FOLDER_ID, PrivateMessage.INBOX_FOLDER_ID);
                this.messageFolderMap.put(PrivateMessage.SENT_FOLDER_ID, PrivateMessage.SENT_FOLDER_ID);
                this.messageFolderMap.put(PrivateMessage.TRASH_FOLDER_ID, PrivateMessage.TRASH_FOLDER_ID);
                f = BackupImport.unzip(is);
                BackupVersion ver = BackupImport.getVersion(f);
                progress.set(2);
                this.importConfigs(f);
                progress.set(7);
                this.importGroups(f);
                progress.set(12);
                this.importLdap(f);
                progress.set(17);
                this.importOauth(f);
                progress.set(22);
                this.importUsers(f);
                progress.set(27);
                this.importRooms(f);
                progress.set(32);
                this.importRoomGroups(f);
                progress.set(37);
                this.importChat(f);
                progress.set(42);
                this.importCalendars(f);
                progress.set(47);
                this.importAppointments(f);
                progress.set(52);
                this.importMeetingMembers(f);
                progress.set(57);
                this.importRecordings(f);
                progress.set(62);
                this.importPrivateMsgFolders(f);
                progress.set(67);
                this.importContacts(f);
                progress.set(72);
                this.importPrivateMsgs(f);
                progress.set(77);
                List<FileItem> files = this.importFiles(f);
                progress.set(82);
                this.importPolls(f);
                progress.set(87);
                this.importRoomFiles(f);
                progress.set(92);
                this.importExtraMenus(f);
                progress.set(95);
                log.info("Extra menus import complete, starting copy of files and folders");
                this.importFolders(f);
                progress.set(97);
                if (ver.compareTo(BackupVersion.get("4.0.0")) < 0) {
                    for (FileItem bfi : files) {
                        if (bfi.isDeleted()) continue;
                        if (BaseFileItem.Type.PRESENTATION == bfi.getType()) {
                            this.convertOldPresentation(bfi);
                            this.fileItemDao.updateBase((BaseFileItem)bfi);
                        }
                        if (BaseFileItem.Type.WML_FILE != bfi.getType()) continue;
                        this.convertWb(bfi);
                    }
                }
                log.info("File explorer item import complete");
                success = true;
                if (f == null) break block8;
            }
            catch (Throwable throwable) {
                if (f != null) {
                    log.info("Clearing temp files ...");
                    FileUtils.deleteDirectory(f);
                }
                this.cleanup();
                if (success) {
                    progress.set(100);
                }
                throw throwable;
            }
            log.info("Clearing temp files ...");
            FileUtils.deleteDirectory((File)f);
        }
        this.cleanup();
        if (success) {
            progress.set(100);
        }
    }

    private void convertWb(FileItem bfi) {
        try {
            Whiteboard wb = WbConverter.convert(bfi);
            wb.save(bfi.getFile().toPath());
        }
        catch (Exception e) {
            log.error("Unexpected error while converting WB", (Throwable)e);
        }
    }

    public void cleanup() {
        this.ldapMap.clear();
        this.oauthMap.clear();
        this.userMap.clear();
        this.groupMap.clear();
        this.calendarMap.clear();
        this.appointmentMap.clear();
        this.roomMap.clear();
        this.messageFolderMap.clear();
        this.userContactMap.clear();
        this.fileMap.clear();
        this.hashMap.clear();
        this.messageFolderMap.put(PrivateMessage.INBOX_FOLDER_ID, PrivateMessage.INBOX_FOLDER_ID);
        this.messageFolderMap.put(PrivateMessage.SENT_FOLDER_ID, PrivateMessage.SENT_FOLDER_ID);
        this.messageFolderMap.put(PrivateMessage.TRASH_FOLDER_ID, PrivateMessage.TRASH_FOLDER_ID);
    }

    public static BackupVersion getVersion(File base) {
        ArrayList list = new ArrayList(1);
        BackupImport.readList(base, "version.xml", "version", "version", BackupVersion.class, list::add, true);
        return list.isEmpty() ? new BackupVersion() : (BackupVersion)list.get(0);
    }

    public void importConfigs(File base) throws Exception {
        HashMap keyMap = new HashMap();
        Arrays.stream(KeyEvent.class.getDeclaredFields()).filter(fld -> fld.getName().startsWith("VK_")).forEach(fld -> {
            try {
                keyMap.put(fld.getInt(null), "Shift+" + WordUtils.capitalizeFully((String)fld.getName().substring(3)));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                log.error("Unexpected exception while building KEY map {}", fld);
            }
        });
        Class<Configuration> eClazz = Configuration.class;
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{eClazz});
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        unmarshaller.setAdapter((XmlAdapter)new UserAdapter(this.userDao, this.userMap));
        BackupImport.readList(unmarshaller, base, "configs.xml", "configs", "config", eClazz, c -> {
            Configuration cfg;
            Configuration.Type type;
            if (c.getKey() == null || c.isDeleted()) {
                return;
            }
            String newKey = outdatedConfigKeys.get(c.getKey());
            if (newKey != null) {
                c.setKey(newKey);
            }
            if ((type = configTypes.get(c.getKey())) != null) {
                c.setType(type);
                if (Configuration.Type.BOOL == type) {
                    c.setValue(String.valueOf("1".equals(c.getValue()) || "yes".equals(c.getValue()) || "true".equals(c.getValue())));
                } else if (Configuration.Type.HOTKEY == type) {
                    try {
                        int val = c.getValueN().intValue();
                        c.setValue((String)keyMap.get(val));
                    }
                    catch (Exception val) {
                        // empty catch block
                    }
                }
            }
            if ((cfg = this.cfgDao.forceGet(c.getKey())) != null && !cfg.isDeleted()) {
                log.warn("Non deleted configuration with same key is found! old value: {}, new value: {}", (Object)cfg.getValue(), (Object)c.getValue());
            }
            c.setId(cfg == null ? null : cfg.getId());
            if (c.getUser() != null && c.getUser().getId() == null) {
                c.setUser(null);
            }
            if ("crypt.class.name".equals(c.getKey())) {
                try {
                    Class<?> clazz = Class.forName(c.getValue());
                    clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    log.warn("Not existing Crypt class found {}, replacing with SCryptImplementation", (Object)c.getValue());
                    c.setValue(SCryptImplementation.class.getCanonicalName());
                }
            }
            this.cfgDao.update(c, null);
        });
    }

    public void importGroups(File base) {
        log.info("Configs import complete, starting group import");
        BackupImport.readList(base, "organizations.xml", "organisations", "organisation", Group.class, g -> {
            Long oldId = g.getId();
            g.setId(null);
            g = this.groupDao.update(g, null);
            this.groupMap.put(oldId, g.getId());
        });
    }

    public Long importLdap(File base) {
        log.info("Groups import complete, starting LDAP config import");
        Long[] defaultLdapId = new Long[]{this.cfgDao.getLong("default.ldap.id", null)};
        BackupImport.readList(base, "ldapconfigs.xml", "ldapconfigs", "ldapconfig", LdapConfig.class, c -> {
            if (Strings.isEmpty((String)c.getName()) || "local DB [internal]".equals(c.getName())) {
                return;
            }
            Long oldId = c.getId();
            c.setId(null);
            c = this.ldapConfigDao.update(c, null);
            if (defaultLdapId[0] == null) {
                defaultLdapId[0] = c.getId();
            }
            if (oldId != null) {
                this.ldapMap.put(oldId, c.getId());
            }
        });
        return defaultLdapId[0];
    }

    public void importOauth(File base) {
        log.info("Ldap config import complete, starting OAuth2 server import");
        BackupImport.readList(base, "oauth2servers.xml", "oauth2servers", "OAuthServer", OAuthServer.class, (T s) -> {
            Long oldId = s.getId();
            s.setId(null);
            s = this.auth2Dao.update(s, null);
            if (oldId != null) {
                this.oauthMap.put(oldId, s.getId());
            }
        }, false);
    }

    private void checkByType(User u) {
        if (u.getType() == User.Type.LDAP) {
            if (u.getDomainId() != null && this.ldapMap.containsKey(u.getDomainId())) {
                u.setDomainId(this.ldapMap.get(u.getDomainId()));
            } else {
                log.error("Unable to find Domain for ID: {}", (Object)u.getDomainId());
            }
        }
        if (u.getType() == User.Type.OAUTH) {
            if (u.getDomainId() != null && this.oauthMap.containsKey(u.getDomainId())) {
                u.setDomainId(this.oauthMap.get(u.getDomainId()));
            } else {
                log.error("Unable to find Domain for ID: {}", (Object)u.getDomainId());
            }
        }
    }

    private void checkLogin(User u, Set<UserKey> userLogins) {
        if (u.getType() == User.Type.CONTACT && u.getLogin().length() < OpenmeetingsVariables.getMinLoginLength()) {
            u.setLogin(UUID.randomUUID().toString());
        }
        if (userLogins.contains(new UserKey(u))) {
            log.warn("LOGIN is duplicated for USER {}", (Object)u);
            String updateLogin = String.format("modified_by_import_<%s>%s", UUID.randomUUID(), u.getLogin());
            u.setLogin(updateLogin);
        }
        userLogins.add(new UserKey(u));
    }

    public void importUsers(File base) throws Exception {
        log.info("OAuth2 servers import complete, starting user import");
        String jNameTimeZone = OpenmeetingsVariables.getDefaultTimezone();
        HashSet userEmails = new HashSet();
        HashSet userLogins = new HashSet();
        this.userDao.getAllUsers().stream().forEach(u -> {
            if (u.getAddress() != null && !Strings.isEmpty((String)u.getAddress().getEmail())) {
                userEmails.add(u.getAddress().getEmail());
            }
            userLogins.add(new UserKey((User)u));
        });
        Class<User> eClazz = User.class;
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{eClazz});
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        unmarshaller.setAdapter((XmlAdapter)new GroupAdapter(this.groupDao, this.groupMap));
        BackupImport.readList(unmarshaller, base, "users.xml", "users", "user", eClazz, u -> {
            String tz;
            if (u.getLogin() == null || u.isDeleted()) {
                return;
            }
            if (u.getAddress() != null && u.getAddress().getEmail() != null && User.Type.USER == u.getType()) {
                if (userEmails.contains(u.getAddress().getEmail())) {
                    log.warn("Email is duplicated for user {}", u);
                    String updateEmail = String.format("modified_by_import_<%s>%s", UUID.randomUUID(), u.getAddress().getEmail());
                    u.getAddress().setEmail(updateEmail);
                }
                userEmails.add(u.getAddress().getEmail());
            }
            this.checkByType((User)u);
            this.checkLogin((User)u, userLogins);
            if (u.getGroupUsers() != null) {
                Iterator iter = u.getGroupUsers().iterator();
                while (iter.hasNext()) {
                    GroupUser gu = (GroupUser)iter.next();
                    if (gu.getGroup().getId() == null) {
                        iter.remove();
                        continue;
                    }
                    gu.setUser(u);
                }
            }
            if ((tz = u.getTimeZoneId()) == null) {
                u.setTimeZoneId(jNameTimeZone);
            }
            Long userId = u.getId();
            u.setId(null);
            if (u.getSipUser() != null && u.getSipUser().getId() != 0L) {
                u.getSipUser().setId(0L);
            }
            if (AuthLevelUtil.hasLoginLevel((Set)u.getRights()) && !Strings.isEmpty((String)u.getActivatehash())) {
                u.setActivatehash(null);
            }
            this.userDao.update(u, Long.valueOf(-1L));
            this.userMap.put(userId, u.getId());
        });
    }

    public void importRooms(File base) throws Exception {
        log.info("Users import complete, starting room import");
        Class<Room> eClazz = Room.class;
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{eClazz});
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        unmarshaller.setAdapter((XmlAdapter)new UserAdapter(this.userDao, this.userMap));
        BackupImport.readList(unmarshaller, base, "rooms.xml", "rooms", "room", eClazz, r -> {
            Long roomId = r.getId();
            if (r.getOwnerId() != null) {
                Long newOwnerId = this.userMap.get(r.getOwnerId());
                if (newOwnerId == null) {
                    return;
                }
                r.setOwnerId(newOwnerId);
            }
            r.setId(null);
            if (r.getModerators() != null) {
                Iterator i = r.getModerators().iterator();
                while (i.hasNext()) {
                    RoomModerator rm = (RoomModerator)i.next();
                    if (rm.getUser().getId() != null) continue;
                    i.remove();
                }
            }
            r = this.roomDao.update(r, null);
            this.roomMap.put(roomId, r.getId());
        });
    }

    public void importRoomGroups(File base) throws Exception {
        log.info("Room import complete, starting room groups import");
        Class<RoomGroup> eClazz = RoomGroup.class;
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{eClazz});
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        unmarshaller.setAdapter((XmlAdapter)new RoomAdapter(this.roomDao, this.roomMap));
        unmarshaller.setAdapter((XmlAdapter)new GroupAdapter(this.groupDao, this.groupMap));
        BackupImport.readList(unmarshaller, base, "rooms_organisation.xml", "room_organisations", "room_organisation", eClazz, rg -> {
            if (rg.getRoom() == null || rg.getGroup() == null) {
                return;
            }
            Room r = this.roomDao.get(rg.getRoom().getId());
            if (r == null || rg.getGroup().getId() == null) {
                return;
            }
            if (r.getGroups() == null) {
                r.setGroups(new ArrayList());
            }
            rg.setId(null);
            rg.setRoom(r);
            r.getGroups().add(rg);
            this.roomDao.update(r, null);
        });
    }

    public void importChat(File base) throws Exception {
        log.info("Room groups import complete, starting chat messages import");
        Class<ChatMessage> eClazz = ChatMessage.class;
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{eClazz});
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        unmarshaller.setAdapter((XmlAdapter)new UserAdapter(this.userDao, this.userMap));
        unmarshaller.setAdapter((XmlAdapter)new RoomAdapter(this.roomDao, this.roomMap));
        BackupImport.readList(unmarshaller, base, "chat_messages.xml", "chat_messages", "ChatMessage", eClazz, m -> {
            m.setId(null);
            if (m.getFromUser() == null || m.getFromUser().getId() == null || m.getToRoom() != null && m.getToRoom().getId() == null || m.getToUser() != null && m.getToUser().getId() == null) {
                return;
            }
            this.chatDao.update(m, m.getSent());
        });
    }

    public void importCalendars(File base) throws Exception {
        log.info("Chat messages import complete, starting calendar import");
        Class<OmCalendar> eClazz = OmCalendar.class;
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{eClazz});
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        unmarshaller.setAdapter((XmlAdapter)new UserAdapter(this.userDao, this.userMap));
        BackupImport.readList(unmarshaller, base, "calendars.xml", "calendars", "calendar", eClazz, c -> {
            Long id = c.getId();
            c.setId(null);
            c = this.calendarDao.update(c);
            this.calendarMap.put(id, c.getId());
        }, true);
    }

    public void importAppointments(File base) throws Exception {
        log.info("Calendar import complete, starting appointement import");
        Class<Appointment> eClazz = Appointment.class;
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{eClazz});
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        unmarshaller.setAdapter((XmlAdapter)new UserAdapter(this.userDao, this.userMap));
        unmarshaller.setAdapter((XmlAdapter)new RoomAdapter(this.roomDao, this.roomMap));
        unmarshaller.setAdapter((XmlAdapter)new OmCalendarAdapter(this.calendarDao, this.calendarMap));
        BackupImport.readList(unmarshaller, base, "appointements.xml", "appointments", "appointment", eClazz, a -> {
            Long appId = a.getId();
            a.setId(null);
            if (a.getOwner() != null && a.getOwner().getId() == null) {
                a.setOwner(null);
            }
            if (a.getRoom() == null || a.getRoom().getId() == null) {
                log.warn("Appointment without room was found, skipping: {}", a);
                return;
            }
            if (a.getStart() == null || a.getEnd() == null) {
                log.warn("Appointment without start/end time was found, skipping: {}", a);
                return;
            }
            a = this.appointmentDao.update(a, null, false);
            this.appointmentMap.put(appId, a.getId());
        });
    }

    public void importMeetingMembers(File base) throws Exception {
        log.info("Appointement import complete, starting meeting members import");
        Class<MeetingMember> eClazz = MeetingMember.class;
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{eClazz});
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        unmarshaller.setAdapter((XmlAdapter)new UserAdapter(this.userDao, this.userMap));
        unmarshaller.setAdapter((XmlAdapter)new AppointmentAdapter(this.appointmentDao, this.appointmentMap));
        BackupImport.readList(unmarshaller, base, "meetingmembers.xml", "meetingmembers", "meetingmember", eClazz, ma -> {
            ma.setId(null);
            this.meetingMemberDao.update(ma);
        });
    }

    private boolean isInvalidFile(BaseFileItem file, Map<Long, Long> folders) {
        if (file.isDeleted()) {
            return true;
        }
        if (file.getParentId() != null && file.getParentId() > 0L) {
            Long newFolder = folders.get(file.getParentId());
            if (newFolder == null) {
                return true;
            }
            file.setParentId(newFolder);
        } else {
            file.setParentId(null);
        }
        if (file.getRoomId() != null) {
            Long newRoomId = this.roomMap.get(file.getRoomId());
            if (newRoomId == null) {
                return true;
            }
            file.setRoomId(newRoomId);
        }
        if (file.getOwnerId() != null) {
            Long newOwnerId = this.userMap.get(file.getOwnerId());
            if (newOwnerId == null) {
                return true;
            }
            file.setOwnerId(newOwnerId);
        }
        if (file.getInsertedBy() != null) {
            Long newInsertedBy = this.userMap.get(file.getInsertedBy());
            file.setInsertedBy(newInsertedBy);
        }
        if (file.getGroupId() != null) {
            Long newGroupId = this.groupMap.get(file.getGroupId());
            if (newGroupId == null) {
                return true;
            }
            file.setGroupId(newGroupId);
        }
        return false;
    }

    private <T extends BaseFileItem> void saveTree(File baseDir, String fileName, String listNodeName, String nodeName, Class<T> clazz, Map<Long, Long> folders, Consumer<T> save) {
        Map.Entry e2;
        TreeMap items = new TreeMap();
        BackupImport.readList(baseDir, fileName, listNodeName, nodeName, clazz, (T f) -> items.put(f.getId(), f), false);
        FileTree<BaseFileItem> tree = new FileTree<BaseFileItem>();
        TreeMap<Long, BaseFileItem> remain = new TreeMap<Long, BaseFileItem>();
        int counter = items.size();
        while (counter > 0 && !items.isEmpty() && (e2 = items.pollFirstEntry()) != null) {
            if (!tree.add((BaseFileItem)e2.getValue())) {
                remain.put((Long)e2.getKey(), (BaseFileItem)e2.getValue());
            }
            if (!items.isEmpty()) continue;
            counter = Math.min(counter - 1, remain.size());
            items.putAll(remain);
            remain.clear();
        }
        remain.entrySet().forEach(e -> log.warn("Doungling file/recording: {}", e.getValue()));
        tree.process(f -> this.isInvalidFile((BaseFileItem)f, folders), save);
    }

    public void importRecordings(File base) {
        log.info("Meeting members import complete, starting recordings server import");
        HashMap<Long, Long> folders = new HashMap<Long, Long>();
        this.saveTree(base, "flvRecordings.xml", "flvrecordings", "flvrecording", Recording.class, folders, r -> {
            Long recId = r.getId();
            r.setId(null);
            if (r.getChunks() != null) {
                for (RecordingChunk chunk : r.getChunks()) {
                    chunk.setId(null);
                    chunk.setRecording(r);
                }
            }
            this.checkHash((BaseFileItem)r, (BaseFileItemDao)this.recordingDao, (oldHash, newHash) -> {
                if (!Strings.isEmpty((String)oldHash) && oldHash.startsWith("flvRecording_")) {
                    String name = OmFileHelper.getFileName((String)oldHash);
                    this.fileMap.put(String.format("%s.%s", name, "jpg"), String.format("%s.%s", newHash, "png"));
                    this.fileMap.put(String.format("%s.%s.%s", name, "flv", "mp4"), String.format("%s.%s", newHash, "mp4"));
                }
            });
            r = this.recordingDao.update(r);
            if (BaseFileItem.Type.FOLDER == r.getType()) {
                folders.put(recId, r.getId());
            }
            this.fileItemMap.put(recId, r.getId());
        });
    }

    private void checkHash(BaseFileItem file, BaseFileItemDao dao, BiConsumer<String, String> consumer) {
        String oldHash = file.getHash();
        if (Strings.isEmpty((String)oldHash) || !UUID_PATTERN.matcher(oldHash).matches() || dao.get(oldHash, BaseFileItem.class) != null) {
            file.setHash(UUID.randomUUID().toString());
            this.hashMap.put(oldHash, file.getHash());
            if (consumer != null) {
                consumer.accept(oldHash, file.getHash());
            }
        } else {
            this.hashMap.put(file.getHash(), file.getHash());
        }
    }

    public void importPrivateMsgFolders(File base) {
        log.info("Recording import complete, starting private message folder import");
        BackupImport.readList(base, "privateMessageFolder.xml", "privatemessagefolders", "privatemessagefolder", PrivateMessageFolder.class, p -> {
            Long folderId = p.getId();
            PrivateMessageFolder storedFolder = this.privateMessageFolderDao.get(folderId);
            if (storedFolder == null) {
                p.setId(null);
                Long newFolderId = this.privateMessageFolderDao.addPrivateMessageFolderObj(p);
                this.messageFolderMap.put(folderId, newFolderId);
            }
        });
    }

    private void importContacts(File base) throws Exception {
        log.info("Private message folder import complete, starting user contacts import");
        Class<UserContact> eClazz = UserContact.class;
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{eClazz});
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        unmarshaller.setAdapter((XmlAdapter)new UserAdapter(this.userDao, this.userMap));
        BackupImport.readList(unmarshaller, base, "userContacts.xml", "usercontacts", "usercontact", eClazz, uc -> {
            Long ucId = uc.getId();
            UserContact storedUC = this.userContactDao.get(ucId);
            if (storedUC == null && uc.getContact() != null && uc.getContact().getId() != null) {
                uc.setId(null);
                if (uc.getOwner() != null && uc.getOwner().getId() == null) {
                    uc.setOwner(null);
                }
                uc = this.userContactDao.update(uc);
                this.userContactMap.put(ucId, uc.getId());
            }
        });
    }

    private void importPrivateMsgs(File base) throws Exception {
        log.info("Usercontact import complete, starting private messages item import");
        Class<PrivateMessage> eClazz = PrivateMessage.class;
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{eClazz});
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        unmarshaller.setAdapter((XmlAdapter)new UserAdapter(this.userDao, this.userMap));
        unmarshaller.setAdapter((XmlAdapter)new RoomAdapter(this.roomDao, this.roomMap));
        BackupImport.readList(unmarshaller, base, "privateMessages.xml", "privatemessages", "privatemessage", eClazz, p -> {
            p.setId(null);
            p.setFolderId(this.messageFolderMap.get(p.getFolderId()));
            p.setUserContactId(this.userContactMap.get(p.getUserContactId()));
            if (p.getRoom() != null && p.getRoom().getId() == null) {
                p.setRoom(null);
            }
            if (p.getTo() != null && p.getTo().getId() == null) {
                p.setTo(null);
            }
            if (p.getFrom() != null && p.getFrom().getId() == null) {
                p.setFrom(null);
            }
            if (p.getOwner() != null && p.getOwner().getId() == null) {
                p.setOwner(null);
            }
            this.privateMessageDao.update(p, null);
        });
    }

    private List<FileItem> importFiles(File base) {
        log.info("Private message import complete, starting file explorer item import");
        ArrayList<FileItem> result = new ArrayList<FileItem>();
        HashMap<Long, Long> folders = new HashMap<Long, Long>();
        this.saveTree(base, "fileExplorerItems.xml", "fileExplorerItems", "fileItem", FileItem.class, folders, file -> {
            Long fId = file.getId();
            file.setId(null);
            this.checkHash((BaseFileItem)file, (BaseFileItemDao)this.fileItemDao, null);
            file = this.fileItemDao.update(file);
            if (BaseFileItem.Type.FOLDER == file.getType()) {
                folders.put(fId, file.getId());
            }
            result.add((FileItem)file);
            this.fileItemMap.put(fId, file.getId());
        });
        return result;
    }

    private void importPolls(File base) throws Exception {
        log.info("File explorer item import complete, starting room poll import");
        Class<RoomPoll> eClazz = RoomPoll.class;
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{eClazz});
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        unmarshaller.setAdapter((XmlAdapter)new UserAdapter(this.userDao, this.userMap));
        unmarshaller.setAdapter((XmlAdapter)new RoomAdapter(this.roomDao, this.roomMap));
        BackupImport.readList(unmarshaller, base, "roompolls.xml", "roompolls", "roompoll", eClazz, rp -> {
            rp.setId(null);
            if (rp.getRoom() == null || rp.getRoom().getId() == null) {
                return;
            }
            if (rp.getCreator() == null || rp.getCreator().getId() == null) {
                rp.setCreator(null);
            }
            for (RoomPollAnswer rpa : rp.getAnswers()) {
                if (rpa.getVotedUser() != null && rpa.getVotedUser().getId() != null) continue;
                rpa.setVotedUser(null);
            }
            this.pollDao.update(rp);
        });
    }

    private void importRoomFiles(File base) throws Exception {
        log.info("Poll import complete, starting room files import");
        Class<RoomFile> eClazz = RoomFile.class;
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{eClazz});
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        unmarshaller.setAdapter((XmlAdapter)new FileAdapter((BaseFileItemDao)this.fileItemDao, this.fileItemMap));
        BackupImport.readList(unmarshaller, base, "roomFiles.xml", "RoomFiles", "RoomFile", eClazz, rf -> {
            Room r = this.roomDao.get(this.roomMap.get(rf.getRoomId()));
            if (r == null || rf.getFile() == null || rf.getFile().getId() == null) {
                return;
            }
            if (r.getFiles() == null) {
                r.setFiles(new ArrayList());
            }
            rf.setId(null);
            rf.setRoomId(r.getId());
            r.getFiles().add(rf);
            this.roomDao.update(r, null);
        }, true);
    }

    public void importExtraMenus(File base) throws Exception {
        log.info("Room files complete, starting extra menus import");
        Class<ExtraMenu> eClazz = ExtraMenu.class;
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{eClazz});
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        unmarshaller.setAdapter((XmlAdapter)new GroupAdapter(this.groupDao, this.groupMap));
        BackupImport.readList(unmarshaller, base, "extraMenus.xml", "ExtraMenus", "ExtraMenu", eClazz, m -> {
            if (Strings.isEmpty((String)m.getName()) || Strings.isEmpty((String)m.getLink())) {
                return;
            }
            m.setId(null);
            this.menuDao.update(m, null);
        }, true);
    }

    private static <T> void readList(File baseDir, String fileName, String listNodeName, String nodeName, Class<T> clazz, Consumer<T> consumer) {
        BackupImport.readList(baseDir, fileName, listNodeName, nodeName, clazz, consumer, false);
    }

    private static <T> void readList(Unmarshaller unmarshaller, File baseDir, String fileName, String listNodeName, String nodeName, Class<T> clazz, Consumer<T> consumer) {
        BackupImport.readList(unmarshaller, baseDir, fileName, listNodeName, nodeName, clazz, consumer, false);
    }

    private static <T> void readList(File baseDir, String fileName, String listNodeName, String nodeName, Class<T> clazz, Consumer<T> consumer, boolean notThow) {
        BackupImport.readList(null, baseDir, fileName, listNodeName, nodeName, clazz, consumer, notThow);
    }

    private static <T> void readList(Unmarshaller inUnmarshaller, File baseDir, String fileName, String listNodeName, String nodeName, Class<T> clazz, Consumer<T> consumer, boolean notThow) {
        File xml = new File(baseDir, fileName);
        if (!xml.exists()) {
            String msg = fileName + " missing";
            if (notThow) {
                log.debug(msg);
                return;
            }
            throw new BackupException(msg);
        }
        try {
            Unmarshaller unmarshaller = inUnmarshaller;
            if (inUnmarshaller == null) {
                JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{clazz});
                unmarshaller = jc.createUnmarshaller();
            }
            XMLInputFactory xif = XmlHelper.createInputFactory();
            StreamSource xmlSource = new StreamSource(xml);
            XMLStreamReader xsr = xif.createXMLStreamReader(xmlSource);
            boolean listNodeFound = false;
            while (xsr.getEventType() != 8) {
                if (xsr.isStartElement()) {
                    if (!listNodeFound && listNodeName.equals(xsr.getLocalName())) {
                        listNodeFound = true;
                    } else if (nodeName.equals(xsr.getLocalName())) {
                        Object o = unmarshaller.unmarshal(xsr, clazz).getValue();
                        consumer.accept(o);
                    }
                }
                xsr.next();
            }
        }
        catch (Exception e) {
            throw new BackupException(e);
        }
    }

    private static Long getPrefixedId(String prefix, File f, Map<Long, Long> map) {
        String n = OmFileHelper.getFileName((String)f.getName());
        Long id = null;
        if (n.indexOf(prefix) > -1) {
            id = BackupImport.importLongType(n.substring(prefix.length(), n.length()));
        }
        return id == null ? null : map.get(id);
    }

    private void processGroupFiles(File baseDir) throws IOException {
        log.debug("Entered group logo folder");
        for (File f : baseDir.listFiles()) {
            Long id;
            String ext = OmFileHelper.getFileExt((String)f.getName());
            if ("png".equals(ext)) {
                id = BackupImport.getPrefixedId("logo", f, this.groupMap);
                if (id == null) continue;
                FileUtils.copyFile((File)f, (File)OmFileHelper.getGroupLogo((Long)id, (boolean)false));
                continue;
            }
            if (!"css".equals(ext) || (id = BackupImport.getPrefixedId("customcss", f, this.groupMap)) == null) continue;
            FileUtils.copyFile((File)f, (File)OmFileHelper.getGroupCss((Long)id, (boolean)false));
        }
    }

    private static void changeHash(File f, File dir, String hash, String inExt) throws IOException {
        String ext = inExt == null ? OmFileHelper.getFileExt((String)f.getName()) : inExt;
        FileUtils.copyFile((File)f, (File)new File(dir, OmFileHelper.getName((String)hash, (String)ext)));
    }

    private void processFiles(File baseDir) throws IOException {
        log.debug("Entered FILES folder");
        for (File rf : baseDir.listFiles()) {
            String oldHash = OmFileHelper.getFileName((String)rf.getName());
            String hash = this.hashMap.get(oldHash);
            if (hash == null) continue;
            File dir = new File(OmFileHelper.getUploadFilesDir(), hash);
            if (rf.isFile() && rf.getName().endsWith("jpg")) {
                BackupImport.changeHash(rf, dir, hash, "jpg");
                continue;
            }
            for (File f : rf.listFiles()) {
                FileUtils.copyFile((File)f, (File)new File(dir, f.getName().startsWith(oldHash) ? OmFileHelper.getName((String)hash, (String)OmFileHelper.getFileExt((String)f.getName())) : f.getName()));
            }
        }
    }

    private void processProfiles(File baseDir) throws IOException {
        log.debug("Entered profiles folder");
        for (File profile : baseDir.listFiles()) {
            Long id = BackupImport.getPrefixedId("profile_", profile, this.userMap);
            if (id == null) continue;
            FileUtils.copyDirectory((File)profile, (File)OmFileHelper.getUploadProfilesUserDir((Long)id));
        }
    }

    private void processWmls(File baseDir) throws IOException {
        log.debug("Entered WML folder");
        File dir = OmFileHelper.getUploadWmlDir();
        for (File wml : baseDir.listFiles()) {
            String oldHash = OmFileHelper.getFileName((String)wml.getName());
            String hash = this.hashMap.get(oldHash);
            if (hash == null) continue;
            BackupImport.changeHash(wml, dir, hash, null);
        }
    }

    private void processFilesRoot(File baseDir) throws IOException {
        File roomFilesFolder = new File(baseDir, "roomFiles");
        log.debug("roomFilesFolder PATH {} ", (Object)roomFilesFolder.getCanonicalPath());
        if (!roomFilesFolder.exists()) {
            return;
        }
        for (File file : roomFilesFolder.listFiles()) {
            if (!file.isDirectory()) continue;
            String fName = file.getName();
            if ("profiles".equals(fName)) {
                this.processProfiles(file);
                continue;
            }
            if ("files".equals(fName)) {
                this.processFiles(file);
                continue;
            }
            if ("grouplogo".equals(fName)) {
                this.processGroupFiles(file);
                continue;
            }
            if (!"stored".equals(fName)) continue;
            this.processWmls(file);
        }
    }

    private void importFolders(File baseDir) throws IOException {
        File cssDir;
        this.processFilesRoot(baseDir);
        File recDir = new File(baseDir, "recordingFiles");
        log.debug("sourceDirRec PATH {}", (Object)recDir.getCanonicalPath());
        if (recDir.exists()) {
            File hiberDir = OmFileHelper.getStreamsHibernateDir();
            for (File r : recDir.listFiles()) {
                String n = this.fileMap.get(r.getName());
                if (n != null) {
                    FileUtils.copyFile((File)r, (File)new File(hiberDir, n));
                    continue;
                }
                String oldHash = OmFileHelper.getFileName((String)r.getName());
                String hash = this.hashMap.get(oldHash);
                if (hash == null) {
                    FileUtils.copyFileToDirectory((File)r, (File)hiberDir);
                    continue;
                }
                BackupImport.changeHash(r, hiberDir, hash, null);
            }
        }
        if ((cssDir = new File(baseDir, "css")).exists()) {
            File wCssDir = OmFileHelper.getCssDir();
            for (File css : cssDir.listFiles()) {
                FileUtils.copyFileToDirectory((File)css, (File)wCssDir);
            }
        }
    }

    private static Long importLongType(String value) {
        Long val = null;
        try {
            val = Long.valueOf(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return val;
    }

    private void convertOldPresentation(FileItem fi) {
        File f = fi.getOriginal();
        if (f != null && f.exists()) {
            try {
                StoredFile sf = new StoredFile(fi.getHash(), OmFileHelper.getFileExt((String)f.getName()), f);
                this.docConverter.convertPDF(fi, sf);
            }
            catch (Exception e) {
                log.error("Unexpected exception while converting OLD format presentations", (Throwable)e);
            }
        }
    }

    private static class UserKey {
        private final String login;
        private final User.Type type;
        private final Long domainId;

        UserKey(User u) {
            this.login = u.getLogin();
            this.type = u.getType();
            this.domainId = u.getDomainId();
        }

        public int hashCode() {
            return Objects.hash(this.domainId, this.login, this.type);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UserKey other = (UserKey)obj;
            return Objects.equals(this.domainId, other.domainId) && Objects.equals(this.login, other.login) && this.type == other.type;
        }
    }
}

