/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.fastagi.command;

import java.io.Serializable;
import org.asteriskjava.AsteriskVersion;
import org.asteriskjava.fastagi.command.AgiCommand;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public abstract class AbstractAgiCommand
implements Serializable,
AgiCommand {
    private static final long serialVersionUID = 3257849874518456633L;
    private static final Log logger = LogFactory.getLog(AbstractAgiCommand.class);
    private AsteriskVersion asteriskVersion;

    AsteriskVersion getAsteriskVersion() {
        if (this.asteriskVersion == null) {
            logger.warn("Asterisk Version isn't known, returning 1.4");
            return AsteriskVersion.ASTERISK_1_4;
        }
        return this.asteriskVersion;
    }

    @Override
    public void setAsteriskVersion(AsteriskVersion asteriskVersion) {
        this.asteriskVersion = asteriskVersion;
    }

    @Override
    public abstract String buildCommand();

    public String toString() {
        return String.format("%s[command='%s', systemHashcode=%d]", this.getClass().getName(), this.buildCommand(), System.identityHashCode(this));
    }

    protected String escapeAndQuote(String string) {
        if (string == null) {
            return "\"\"";
        }
        string = string.replaceAll("\\\\", "\\\\\\\\");
        string = string.replaceAll("\\\"", "\\\\\"");
        string = string.replaceAll("\\\n", "");
        return String.format("\"%s\"", string);
    }

    protected String escapeAndQuote(String[] strings) {
        if (strings == null) {
            return this.escapeAndQuote((String)null);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < strings.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(strings[i]);
        }
        return this.escapeAndQuote(sb.toString());
    }
}

