/*
 * Decompiled with CFR 0.152.
 */
package com.github.caldav4j.util;

import java.io.StringWriter;
import java.io.Writer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.XmlSerializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class XMLUtils {
    private static final Logger log = LoggerFactory.getLogger(XMLUtils.class);

    public static Document createNewDocument() throws ParserConfigurationException {
        return DomUtil.createDocument();
    }

    public static String toXML(Document document) {
        StringWriter writer = new StringWriter();
        try {
            DomUtil.transformDocument((Document)document, (Writer)writer);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return writer.toString();
    }

    public static String toPrettyXML(Document doc) {
        DOMSource domSource = new DOMSource(doc);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("encoding", "utf-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(domSource, result);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return writer.toString();
    }

    public static String prettyPrint(XmlSerializable xml) {
        try {
            Document doc = DomUtil.createDocument();
            doc.appendChild(xml.toXml(doc));
            return XMLUtils.toPrettyXML(doc);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }
}

