/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.client.impl.spi.ClientProxyFactory;
import com.hazelcast.internal.util.Preconditions;
import java.util.Objects;
import javax.annotation.Nonnull;

public class ProxyFactoryConfig {
    private String service;
    private String className;
    private ClientProxyFactory factoryImpl;

    public ProxyFactoryConfig() {
    }

    public ProxyFactoryConfig(String className, String service) {
        this.className = className;
        this.service = service;
    }

    public ProxyFactoryConfig(String service, ClientProxyFactory factoryImpl) {
        this.service = service;
        this.factoryImpl = factoryImpl;
    }

    public ProxyFactoryConfig(ProxyFactoryConfig factoryConfig) {
        this.service = factoryConfig.service;
        this.className = factoryConfig.className;
        this.factoryImpl = factoryConfig.factoryImpl;
    }

    public String getClassName() {
        return this.className;
    }

    public ProxyFactoryConfig setClassName(@Nonnull String className) {
        this.className = Preconditions.checkHasText(className, "Client proxy factory class name must contain text");
        this.factoryImpl = null;
        return this;
    }

    public String getService() {
        return this.service;
    }

    public ProxyFactoryConfig setService(String service) {
        this.service = service;
        return this;
    }

    public ClientProxyFactory getFactoryImpl() {
        return this.factoryImpl;
    }

    public ProxyFactoryConfig setFactoryImpl(@Nonnull ClientProxyFactory factoryImpl) {
        this.factoryImpl = Preconditions.checkNotNull(factoryImpl, "Client proxy factory cannot be null!");
        this.className = null;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProxyFactoryConfig that = (ProxyFactoryConfig)o;
        return Objects.equals(this.service, that.service) && Objects.equals(this.factoryImpl, that.factoryImpl) && Objects.equals(this.className, that.className);
    }

    public int hashCode() {
        return Objects.hash(this.service, this.factoryImpl, this.className);
    }

    public String toString() {
        return "ProxyFactoryConfig{service='" + this.service + "', className='" + this.className + "', factoryImpl=" + this.factoryImpl + "}";
    }
}

