/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.internal.config.ConfigDataSerializerHook;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.query.Predicate;
import java.io.IOException;
import java.util.Objects;

public class PredicateConfig
implements IdentifiedDataSerializable {
    protected String className;
    protected String sql;
    protected Predicate implementation;

    public PredicateConfig() {
    }

    public PredicateConfig(String className) {
        this.setClassName(className);
    }

    public PredicateConfig(PredicateConfig config) {
        this.implementation = config.getImplementation();
        this.className = config.getClassName();
        this.sql = config.getSql();
    }

    public PredicateConfig(Predicate implementation) {
        this.implementation = Preconditions.isNotNull(implementation, "implementation");
    }

    public String getClassName() {
        return this.className;
    }

    public PredicateConfig setClassName(String className) {
        this.className = Preconditions.checkHasText(className, "className must contain text");
        this.implementation = null;
        this.sql = null;
        return this;
    }

    public Predicate getImplementation() {
        return this.implementation;
    }

    public PredicateConfig setImplementation(Predicate implementation) {
        this.implementation = Preconditions.isNotNull(implementation, "implementation");
        this.className = null;
        this.sql = null;
        return this;
    }

    public String getSql() {
        return this.sql;
    }

    public PredicateConfig setSql(String sql) {
        this.sql = sql;
        this.className = null;
        this.implementation = null;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PredicateConfig)) {
            return false;
        }
        PredicateConfig that = (PredicateConfig)o;
        if (!Objects.equals(this.className, that.className)) {
            return false;
        }
        if (!Objects.equals(this.sql, that.sql)) {
            return false;
        }
        return Objects.equals(this.implementation, that.implementation);
    }

    public int hashCode() {
        int result = this.className != null ? this.className.hashCode() : 0;
        result = 31 * result + (this.sql != null ? this.sql.hashCode() : 0);
        result = 31 * result + (this.implementation != null ? this.implementation.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "PredicateConfig{className='" + this.className + "', sql='" + this.sql + "', implementation=" + this.implementation + "}";
    }

    @Override
    public int getFactoryId() {
        return ConfigDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 20;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.className);
        out.writeString(this.sql);
        out.writeObject(this.implementation);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.className = in.readString();
        this.sql = in.readString();
        this.implementation = (Predicate)in.readObject();
    }
}

