/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.model;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.zip.GZIPOutputStream;
import opennlp.tools.ml.AlgorithmType;
import opennlp.tools.ml.model.AbstractModel;
import opennlp.tools.ml.model.AbstractModelWriter;

public class GenericModelWriter
extends AbstractModelWriter {
    private AbstractModelWriter delegateWriter;

    public GenericModelWriter(AbstractModel model, File file) throws IOException {
        OutputStream os;
        String filename = file.getName();
        if (filename.endsWith(".gz")) {
            os = new GZIPOutputStream(new FileOutputStream(file));
            filename = filename.substring(0, filename.length() - 3);
        } else {
            os = new FileOutputStream(file);
        }
        this.init(model, new DataOutputStream(os));
    }

    public GenericModelWriter(AbstractModel model, DataOutputStream dos) {
        this.init(model, dos);
    }

    private void init(AbstractModel model, DataOutputStream dos) {
        this.delegateWriter = this.fromType(model.getModelType(), model, dos);
    }

    private AbstractModelWriter fromType(AlgorithmType type, AbstractModel model, DataOutputStream dos) {
        try {
            Class<?> readerClass = Class.forName(type.getWriterClazz());
            return (AbstractModelWriter)readerClass.getDeclaredConstructor(AbstractModel.class, DataOutputStream.class).newInstance(model, dos);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Given writer is not available in the classpath!", e);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Problem instantiating chosen writer class: " + type.getWriterClazz(), e);
        }
    }

    @Override
    public void close() throws IOException {
        this.delegateWriter.close();
    }

    @Override
    public void persist() throws IOException {
        this.delegateWriter.persist();
    }

    @Override
    public void writeDouble(double d) throws IOException {
        this.delegateWriter.writeDouble(d);
    }

    @Override
    public void writeInt(int i) throws IOException {
        this.delegateWriter.writeInt(i);
    }

    @Override
    public void writeUTF(String s) throws IOException {
        this.delegateWriter.writeUTF(s);
    }
}

