/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.core.util;

import java.io.Serializable;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.PrettyPrinter;
import tools.jackson.core.util.Separators;

public class MinimalPrettyPrinter
implements PrettyPrinter,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String _rootValueSeparator;
    protected Separators _separators;

    public MinimalPrettyPrinter() {
        this(DEFAULT_ROOT_VALUE_SEPARATOR.toString());
    }

    public MinimalPrettyPrinter(String rootValueSeparator) {
        this._rootValueSeparator = rootValueSeparator;
        this._separators = DEFAULT_SEPARATORS.withObjectNameValueSpacing(Separators.Spacing.NONE);
    }

    public void setRootValueSeparator(String sep) {
        this._rootValueSeparator = sep;
    }

    public MinimalPrettyPrinter setSeparators(Separators separators) {
        this._separators = separators;
        return this;
    }

    @Override
    public void writeRootValueSeparator(JsonGenerator g) throws JacksonException {
        if (this._rootValueSeparator != null) {
            g.writeRaw(this._rootValueSeparator);
        }
    }

    @Override
    public void writeStartObject(JsonGenerator g) throws JacksonException {
        g.writeRaw('{');
    }

    @Override
    public void beforeObjectEntries(JsonGenerator g) throws JacksonException {
    }

    @Override
    public void writeObjectNameValueSeparator(JsonGenerator g) throws JacksonException {
        g.writeRaw(this._separators.getObjectNameValueSeparator());
    }

    @Override
    public void writeObjectEntrySeparator(JsonGenerator g) throws JacksonException {
        g.writeRaw(this._separators.getObjectEntrySeparator());
    }

    @Override
    public void writeEndObject(JsonGenerator g, int nrOfEntries) throws JacksonException {
        g.writeRaw('}');
    }

    @Override
    public void writeStartArray(JsonGenerator g) throws JacksonException {
        g.writeRaw('[');
    }

    @Override
    public void beforeArrayValues(JsonGenerator g) throws JacksonException {
    }

    @Override
    public void writeArrayValueSeparator(JsonGenerator g) throws JacksonException {
        g.writeRaw(this._separators.getArrayElementSeparator());
    }

    @Override
    public void writeEndArray(JsonGenerator g, int nrOfValues) throws JacksonException {
        g.writeRaw(']');
    }
}

