/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.parsing.factory;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.qpid.server.query.engine.exception.QueryParsingException;
import org.apache.qpid.server.query.engine.parsing.expression.ExpressionNode;
import org.apache.qpid.server.query.engine.parsing.expression.function.aggregation.AvgExpression;
import org.apache.qpid.server.query.engine.parsing.expression.function.aggregation.CountExpression;
import org.apache.qpid.server.query.engine.parsing.expression.function.aggregation.MaxExpression;
import org.apache.qpid.server.query.engine.parsing.expression.function.aggregation.MinExpression;
import org.apache.qpid.server.query.engine.parsing.expression.function.aggregation.SumExpression;
import org.apache.qpid.server.query.engine.parsing.expression.function.datetime.CurrentTimestampExpression;
import org.apache.qpid.server.query.engine.parsing.expression.function.datetime.DateAddExpression;
import org.apache.qpid.server.query.engine.parsing.expression.function.datetime.DateDiffExpression;
import org.apache.qpid.server.query.engine.parsing.expression.function.datetime.DateExpression;
import org.apache.qpid.server.query.engine.parsing.expression.function.datetime.ExtractExpression;
import org.apache.qpid.server.query.engine.parsing.expression.function.nulls.CoalesceExpression;
import org.apache.qpid.server.query.engine.parsing.expression.function.numeric.AbsExpression;
import org.apache.qpid.server.query.engine.parsing.expression.function.numeric.RoundExpression;
import org.apache.qpid.server.query.engine.parsing.expression.function.numeric.TruncExpression;
import org.apache.qpid.server.query.engine.parsing.expression.function.string.ConcatExpression;
import org.apache.qpid.server.query.engine.parsing.expression.function.string.LeftTrimExpression;
import org.apache.qpid.server.query.engine.parsing.expression.function.string.LengthExpression;
import org.apache.qpid.server.query.engine.parsing.expression.function.string.LowerExpression;
import org.apache.qpid.server.query.engine.parsing.expression.function.string.PositionExpression;
import org.apache.qpid.server.query.engine.parsing.expression.function.string.ReplaceExpression;
import org.apache.qpid.server.query.engine.parsing.expression.function.string.RightTrimExpression;
import org.apache.qpid.server.query.engine.parsing.expression.function.string.SubstringExpression;
import org.apache.qpid.server.query.engine.parsing.expression.function.string.TrimExpression;
import org.apache.qpid.server.query.engine.parsing.expression.function.string.UpperExpression;

public final class FunctionExpressionFactory {
    private static final List<String> FUNCTION_NAMES = Arrays.stream(Functions.values()).map(Enum::name).collect(Collectors.toList());
    private static final Map<Functions, BiFunction<?, ?, ?>> FUNCTIONS;

    private FunctionExpressionFactory() {
    }

    private static <T> BiFunction<String, List<ExpressionNode<T, ?>>, AbsExpression<T>> absExpression() {
        return AbsExpression::new;
    }

    private static <T> BiFunction<String, List<ExpressionNode<T, ?>>, AvgExpression<T>> avgExpression() {
        return AvgExpression::new;
    }

    private static <T, R> BiFunction<String, List<ExpressionNode<T, ?>>, CoalesceExpression<T, R>> coalesceExpression() {
        return CoalesceExpression::new;
    }

    private static <T, R> BiFunction<String, List<ExpressionNode<T, ?>>, ConcatExpression<T, R>> concatExpression() {
        return ConcatExpression::new;
    }

    private static <T> BiFunction<String, List<ExpressionNode<T, ?>>, CountExpression<T>> countExpression() {
        return CountExpression::new;
    }

    private static <T> BiFunction<String, List<ExpressionNode<T, ?>>, CurrentTimestampExpression<T>> currentTimestampExpression() {
        return CurrentTimestampExpression::new;
    }

    private static <T, R> BiFunction<String, List<ExpressionNode<T, ?>>, DateExpression<T, R>> dateExpression() {
        return DateExpression::new;
    }

    private static <T, R> BiFunction<String, List<ExpressionNode<T, ?>>, DateAddExpression<T, R>> dateAddExpression() {
        return DateAddExpression::new;
    }

    private static <T, R> BiFunction<String, List<ExpressionNode<T, ?>>, DateDiffExpression<T, R>> dateDiffExpression() {
        return DateDiffExpression::new;
    }

    private static <T, R> BiFunction<String, List<ExpressionNode<T, ?>>, ExtractExpression<T, R>> extractExpression() {
        return ExtractExpression::new;
    }

    private static <T, R> BiFunction<String, List<ExpressionNode<T, ?>>, LengthExpression<T, R>> lenExpression() {
        return LengthExpression::new;
    }

    private static <T, R> BiFunction<String, List<ExpressionNode<T, ?>>, LowerExpression<T, R>> lowerExpression() {
        return LowerExpression::new;
    }

    private static <T, R> BiFunction<String, List<ExpressionNode<T, ?>>, LeftTrimExpression<T, R>> ltrim() {
        return LeftTrimExpression::new;
    }

    private static <T, R extends Comparable<R>> BiFunction<String, List<ExpressionNode<T, ?>>, MaxExpression<T, R>> maxExpression() {
        return MaxExpression::new;
    }

    private static <T, R> BiFunction<String, List<ExpressionNode<T, ?>>, MinExpression<T, R>> minExpression() {
        return MinExpression::new;
    }

    private static <T, R> BiFunction<String, List<ExpressionNode<T, ?>>, PositionExpression<T, R>> positionExpression() {
        return PositionExpression::new;
    }

    private static <T, R> BiFunction<String, List<ExpressionNode<T, ?>>, ReplaceExpression<T, R>> replaceExpression() {
        return ReplaceExpression::new;
    }

    private static <T> BiFunction<String, List<ExpressionNode<T, ?>>, RoundExpression<T>> roundExpression() {
        return RoundExpression::new;
    }

    private static <T, R> BiFunction<String, List<ExpressionNode<T, ?>>, RightTrimExpression<T, R>> rtrimExpression() {
        return RightTrimExpression::new;
    }

    private static <T, R> BiFunction<String, List<ExpressionNode<T, ?>>, SubstringExpression<T, R>> substringExpression() {
        return SubstringExpression::new;
    }

    private static <T> BiFunction<String, List<ExpressionNode<T, ?>>, SumExpression<T>> sumExpression() {
        return SumExpression::new;
    }

    private static <T, R> BiFunction<String, List<ExpressionNode<T, ?>>, TrimExpression<T, R>> trimExpression() {
        return TrimExpression::new;
    }

    private static <T> BiFunction<String, List<ExpressionNode<T, ?>>, TruncExpression<T>> truncExpression() {
        return TruncExpression::new;
    }

    private static <T, R> BiFunction<String, List<ExpressionNode<T, ?>>, UpperExpression<T, R>> upperExpression() {
        return UpperExpression::new;
    }

    private static <T, R> BiFunction<String, List<ExpressionNode<T, ?>>, ExpressionNode<T, R>> getFunction(Functions key) {
        return FUNCTIONS.get((Object)key);
    }

    public static <T, R> ExpressionNode<T, R> createFunction(String alias, String name, List<ExpressionNode<T, ?>> args) {
        Objects.requireNonNull(name, "Function name should be not null");
        Objects.requireNonNull(args, "Function argument list should be not null");
        String normalizedName = name.toUpperCase(Locale.US);
        if (!FUNCTION_NAMES.contains(normalizedName)) {
            throw QueryParsingException.of("Function '%s' not found", name);
        }
        Functions function = Functions.valueOf(normalizedName);
        return FunctionExpressionFactory.getFunction(function).apply(alias, args);
    }

    static {
        LinkedHashMap map = new LinkedHashMap();
        map.put(Functions.ABS, FunctionExpressionFactory.absExpression());
        map.put(Functions.AVG, FunctionExpressionFactory.avgExpression());
        map.put(Functions.COALESCE, FunctionExpressionFactory.coalesceExpression());
        map.put(Functions.CONCAT, FunctionExpressionFactory.concatExpression());
        map.put(Functions.COUNT, FunctionExpressionFactory.countExpression());
        map.put(Functions.CURRENT_TIMESTAMP, FunctionExpressionFactory.currentTimestampExpression());
        map.put(Functions.DATE, FunctionExpressionFactory.dateExpression());
        map.put(Functions.DATEADD, FunctionExpressionFactory.dateAddExpression());
        map.put(Functions.DATEDIFF, FunctionExpressionFactory.dateDiffExpression());
        map.put(Functions.EXTRACT, FunctionExpressionFactory.extractExpression());
        map.put(Functions.LEN, FunctionExpressionFactory.lenExpression());
        map.put(Functions.LENGTH, FunctionExpressionFactory.lenExpression());
        map.put(Functions.LOWER, FunctionExpressionFactory.lowerExpression());
        map.put(Functions.LTRIM, FunctionExpressionFactory.ltrim());
        map.put(Functions.MAX, FunctionExpressionFactory.maxExpression());
        map.put(Functions.MIN, FunctionExpressionFactory.minExpression());
        map.put(Functions.POSITION, FunctionExpressionFactory.positionExpression());
        map.put(Functions.REPLACE, FunctionExpressionFactory.replaceExpression());
        map.put(Functions.ROUND, FunctionExpressionFactory.roundExpression());
        map.put(Functions.RTRIM, FunctionExpressionFactory.rtrimExpression());
        map.put(Functions.SUBSTR, FunctionExpressionFactory.substringExpression());
        map.put(Functions.SUBSTRING, FunctionExpressionFactory.substringExpression());
        map.put(Functions.SUM, FunctionExpressionFactory.sumExpression());
        map.put(Functions.TRIM, FunctionExpressionFactory.trimExpression());
        map.put(Functions.TRUNC, FunctionExpressionFactory.truncExpression());
        map.put(Functions.UPPER, FunctionExpressionFactory.upperExpression());
        FUNCTIONS = Collections.unmodifiableMap(map);
    }

    private static enum Functions {
        ABS,
        AVG,
        COALESCE,
        CONCAT,
        COUNT,
        CURRENT_TIMESTAMP,
        DATE,
        DATEADD,
        DATEDIFF,
        EXTRACT,
        LEN,
        LENGTH,
        LOWER,
        LTRIM,
        MAX,
        MIN,
        POSITION,
        REPLACE,
        ROUND,
        RTRIM,
        SUBSTR,
        SUBSTRING,
        SUM,
        TRIM,
        TRUNC,
        UPPER;

    }
}

