/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model.port;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSessionContext;
import javax.security.auth.Subject;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.logging.messages.BrokerMessages;
import org.apache.qpid.server.logging.messages.PortMessages;
import org.apache.qpid.server.logging.subjects.PortLogSubject;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Connection;
import org.apache.qpid.server.model.Container;
import org.apache.qpid.server.model.KeyStore;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.Protocol;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.SystemConfig;
import org.apache.qpid.server.model.Transport;
import org.apache.qpid.server.model.TrustStore;
import org.apache.qpid.server.model.VirtualHostAlias;
import org.apache.qpid.server.model.port.AbstractPort;
import org.apache.qpid.server.model.port.AmqpPort;
import org.apache.qpid.server.plugin.ConnectionPropertyEnricher;
import org.apache.qpid.server.plugin.ProtocolEngineCreator;
import org.apache.qpid.server.plugin.QpidServiceLoader;
import org.apache.qpid.server.plugin.TransportProviderFactory;
import org.apache.qpid.server.transport.AcceptingTransport;
import org.apache.qpid.server.transport.PortBindFailureException;
import org.apache.qpid.server.transport.TransportProvider;
import org.apache.qpid.server.transport.network.security.ssl.SSLUtil;
import org.apache.qpid.server.util.ServerScopedRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tools.jackson.databind.json.JsonMapper;

public class AmqpPortImpl
extends AbstractPort<AmqpPortImpl>
implements AmqpPort<AmqpPortImpl> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AmqpPortImpl.class);
    @ManagedAttributeField
    private boolean _tcpNoDelay;
    @ManagedAttributeField
    private int _maxOpenConnections;
    @ManagedAttributeField
    private int _threadPoolSize;
    @ManagedAttributeField
    private int _numberOfSelectors;
    private final AtomicLong _connectionCount = new AtomicLong();
    private final AtomicBoolean _connectionCountWarningGiven = new AtomicBoolean();
    private final AtomicLong _totalConnectionCount = new AtomicLong();
    private final Container<?> _container;
    private final AtomicBoolean _closingOrDeleting = new AtomicBoolean();
    private volatile AcceptingTransport _transport;
    private volatile SSLContext _sslContext;
    private volatile int _connectionWarnCount;
    private volatile long _protocolHandshakeTimeout;
    private volatile int _boundPort = -1;
    private volatile boolean _closeWhenNoRoute;
    private volatile int _sessionCountLimit;
    private volatile int _heartBeatDelay;
    private volatile int _tlsSessionTimeout;
    private volatile int _tlsSessionCacheSize;
    private volatile List<ConnectionPropertyEnricher> _connectionPropertyEnrichers;

    @ManagedObjectFactoryConstructor
    public AmqpPortImpl(Map<String, Object> attributes, Container<?> container) {
        super(attributes, container);
        this._container = container;
    }

    @Override
    public int getThreadPoolSize() {
        return this._threadPoolSize;
    }

    @Override
    public int getNumberOfSelectors() {
        return this._numberOfSelectors;
    }

    @Override
    public SSLContext getSSLContext() {
        return this._sslContext;
    }

    @Override
    public boolean isTcpNoDelay() {
        return this._tcpNoDelay;
    }

    @Override
    public int getMaxOpenConnections() {
        return this._maxOpenConnections;
    }

    @Override
    protected void onCreate() {
        super.onCreate();
        HashMap<String, Object> nameAliasAttributes = new HashMap<String, Object>();
        nameAliasAttributes.put("name", "nameAlias");
        nameAliasAttributes.put("type", "nameAlias");
        nameAliasAttributes.put("durable", true);
        HashMap<String, Object> defaultAliasAttributes = new HashMap<String, Object>();
        defaultAliasAttributes.put("name", "defaultAlias");
        defaultAliasAttributes.put("type", "defaultAlias");
        defaultAliasAttributes.put("durable", true);
        HashMap<String, Object> hostnameAliasAttributes = new HashMap<String, Object>();
        hostnameAliasAttributes.put("name", "hostnameAlias");
        hostnameAliasAttributes.put("type", "hostnameAlias");
        hostnameAliasAttributes.put("durable", true);
        Subject.doAs(this.getSubjectWithAddedSystemRights(), () -> {
            this.createChild(VirtualHostAlias.class, nameAliasAttributes);
            this.createChild(VirtualHostAlias.class, defaultAliasAttributes);
            this.createChild(VirtualHostAlias.class, hostnameAliasAttributes);
            return null;
        });
    }

    @Override
    protected void onOpen() {
        super.onOpen();
        this._protocolHandshakeTimeout = this.getContextValue(Long.class, "qpid.port.protocol_handshake_timeout");
        this._connectionWarnCount = this.getContextValue(Integer.class, "qpid.port.open_connections_warn_percent");
        this._closeWhenNoRoute = this.getContextValue(Boolean.class, "qpid.port.closeWhenNoRoute");
        this._sessionCountLimit = this.getContextValue(Integer.class, "qpid.port.sessionCountLimit");
        this._heartBeatDelay = this.getContextValue(Integer.class, "qpid.port.heartbeatDelay");
        this._tlsSessionTimeout = this.getContextValue(Integer.class, "qpid.port.amqp.tlsSessionTimeout");
        this._tlsSessionCacheSize = this.getContextValue(Integer.class, "qpid.port.amqp.tlsSessionCacheSize");
        List configurationPropertyEnrichers = this.getContextValue(List.class, "qpid.port.connection_property_enrichers");
        ArrayList<ConnectionPropertyEnricher> enrichers = new ArrayList<ConnectionPropertyEnricher>(configurationPropertyEnrichers.size());
        Map<String, ConnectionPropertyEnricher> enrichersByType = new QpidServiceLoader().getInstancesByType(ConnectionPropertyEnricher.class);
        for (String enricherName : configurationPropertyEnrichers) {
            ConnectionPropertyEnricher enricher = enrichersByType.get(enricherName);
            if (enricher != null) {
                enrichers.add(enricher);
                continue;
            }
            LOGGER.warn("Ignoring unknown Connection Property Enricher type: '" + enricherName + "' on port " + this.getName());
        }
        this._connectionPropertyEnrichers = Collections.unmodifiableList(enrichers);
    }

    @Override
    protected State onActivate() {
        if (this.getAncestor(SystemConfig.class).isManagementMode()) {
            return State.QUIESCED;
        }
        Set<Transport> transports = this.getTransports();
        TransportProvider transportProvider = null;
        HashSet<Transport> transportSet = new HashSet<Transport>(transports);
        for (TransportProviderFactory transportProviderFactory : new QpidServiceLoader().instancesOf(TransportProviderFactory.class)) {
            if (!transportProviderFactory.getSupportedTransports().contains(transports)) continue;
            transportProvider = transportProviderFactory.getTransportProvider(transportSet);
        }
        if (transportProvider == null) {
            throw new IllegalConfigurationException("No transport providers found which can satisfy the requirement to support the transports: " + String.valueOf(transports));
        }
        if (transports.contains((Object)Transport.SSL) || transports.contains((Object)Transport.WSS)) {
            this._sslContext = this.createSslContext();
        }
        Protocol defaultSupportedProtocolReply = this.getDefaultAmqpSupportedReply();
        try {
            this._transport = transportProvider.createTransport(transportSet, this._sslContext, this, this.getProtocols(), defaultSupportedProtocolReply);
            this._transport.start();
            this._boundPort = this._transport.getAcceptingPort();
            for (Transport transport : this.getTransports()) {
                this._container.getEventLogger().message(BrokerMessages.LISTENING(String.valueOf((Object)transport), this._transport.getAcceptingPort()));
            }
            return State.ACTIVE;
        }
        catch (PortBindFailureException portBindFailureException) {
            this._container.getEventLogger().message(PortMessages.BIND_FAILED(this.getType().toUpperCase(), this.getPort()));
            throw portBindFailureException;
        }
    }

    @Override
    protected boolean updateSSLContext() {
        Set<Transport> transports = this.getTransports();
        if (transports.contains((Object)Transport.SSL) || transports.contains((Object)Transport.WSS)) {
            this._sslContext = this.createSslContext();
            return this._transport.updatesSSLContext();
        }
        return false;
    }

    @Override
    protected CompletableFuture<Void> beforeClose() {
        this._closingOrDeleting.set(true);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    protected CompletableFuture<Void> onClose() {
        this.closeTransport();
        return CompletableFuture.completedFuture(null);
    }

    @Override
    protected CompletableFuture<Void> beforeDelete() {
        this._closingOrDeleting.set(true);
        return super.beforeDelete();
    }

    @Override
    protected CompletableFuture<Void> onDelete() {
        this.closeTransport();
        return super.onDelete();
    }

    private void closeTransport() {
        if (this._transport != null) {
            for (Transport transport : this.getTransports()) {
                this._container.getEventLogger().message(BrokerMessages.SHUTTING_DOWN(String.valueOf((Object)transport), this._transport.getAcceptingPort()));
            }
            this._transport.close();
        }
    }

    @Override
    public int getNetworkBufferSize() {
        return this._container.getNetworkBufferSize();
    }

    @Override
    public List<ConnectionPropertyEnricher> getConnectionPropertyEnrichers() {
        return this._connectionPropertyEnrichers;
    }

    @Override
    public int getBoundPort() {
        return this._boundPort;
    }

    @Override
    public void onValidate() {
        super.onValidate();
        Collection<VirtualHostAlias> aliases = this.getChildren(VirtualHostAlias.class);
        if (aliases.size() == 0) {
            LOGGER.warn("{} has no virtualhost aliases defined.  No AMQP connections will be possible through this port until at least one alias is added.", (Object)this);
        }
        this.validateThreadPoolSettings(this);
    }

    @Override
    protected void validateChange(ConfiguredObject<?> proxyForValidation, Set<String> changedAttributes) {
        super.validateChange(proxyForValidation, changedAttributes);
        AmqpPort changed = (AmqpPort)proxyForValidation;
        if (changedAttributes.contains("threadPoolSize") || changedAttributes.contains("numberOfSelectors")) {
            this.validateThreadPoolSettings(changed);
        }
    }

    private void validateThreadPoolSettings(AmqpPort changed) {
        if (changed.getThreadPoolSize() < 1) {
            throw new IllegalConfigurationException(String.format("Thread pool size %d on Port %s must be greater than zero.", changed.getThreadPoolSize(), this.getName()));
        }
        if (changed.getNumberOfSelectors() < 1) {
            throw new IllegalConfigurationException(String.format("Number of Selectors %d on Port %s must be greater than zero.", changed.getNumberOfSelectors(), this.getName()));
        }
        if (changed.getThreadPoolSize() <= changed.getNumberOfSelectors()) {
            throw new IllegalConfigurationException(String.format("Number of Selectors %d on Port %s must be greater than the thread pool size %d.", changed.getNumberOfSelectors(), this.getName(), changed.getThreadPoolSize()));
        }
    }

    private SSLContext createSslContext() {
        boolean needClientCert;
        KeyStore keyStore = this.getKeyStore();
        Collection<TrustStore> trustStores = this.getTrustStores();
        boolean bl = needClientCert = (Boolean)this.getAttribute("needClientAuth") != false || (Boolean)this.getAttribute("wantClientAuth") != false;
        if (needClientCert && trustStores.isEmpty()) {
            throw new IllegalConfigurationException("Client certificate authentication is enabled on AMQP port '" + this.getName() + "' but no trust store defined");
        }
        SSLContext sslContext = SSLUtil.createSslContext(keyStore, trustStores, this.getName());
        SSLSessionContext serverSessionContext = sslContext.getServerSessionContext();
        if (this.getTLSSessionCacheSize() > 0) {
            serverSessionContext.setSessionCacheSize(this.getTLSSessionCacheSize());
        }
        if (this.getTLSSessionTimeout() > 0) {
            serverSessionContext.setSessionTimeout(this.getTLSSessionTimeout());
        }
        return sslContext;
    }

    private Protocol getDefaultAmqpSupportedReply() {
        String defaultAmqpSupportedReply = this.getContextKeys(false).contains("qpid.broker_default_supported_protocol_version_reply") ? this.getContextValue(String.class, "qpid.broker_default_supported_protocol_version_reply") : null;
        Protocol protocol = null;
        if (defaultAmqpSupportedReply != null && defaultAmqpSupportedReply.length() != 0) {
            try {
                protocol = Protocol.valueOf("AMQP_" + defaultAmqpSupportedReply.substring(1));
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn("The configured default reply ({}) is not a valid value for a protocol.  This value will be ignored", (Object)defaultAmqpSupportedReply);
            }
        }
        Set<Protocol> protocolSet = this.getProtocols();
        if (protocol != null && !protocolSet.contains((Object)protocol)) {
            LOGGER.warn("The configured default reply ({}) to an unsupported protocol version initiation is not supported on this port.  Only the following versions are supported: {}", (Object)defaultAmqpSupportedReply, protocolSet);
            protocol = null;
        }
        return protocol;
    }

    public static Set<Protocol> getInstalledProtocols() {
        HashSet<Protocol> protocols = new HashSet<Protocol>();
        for (ProtocolEngineCreator installedEngine : new QpidServiceLoader().instancesOf(ProtocolEngineCreator.class)) {
            protocols.add(installedEngine.getVersion());
        }
        return protocols;
    }

    public static Collection<String> getAllAvailableProtocolCombinations() {
        Set<Protocol> protocols = AmqpPortImpl.getInstalledProtocols();
        HashSet<Set<String>> last = new HashSet<Set<String>>();
        for (Protocol protocol : protocols) {
            last.add(Collections.singleton(protocol.name()));
        }
        HashSet protocolCombinations = new HashSet(last);
        for (int i = 1; i < protocols.size(); ++i) {
            HashSet current = new HashSet();
            for (Set set : last) {
                for (Protocol p : protocols) {
                    if (set.contains(p.name())) continue;
                    HashSet<String> potential = new HashSet<String>(set);
                    potential.add(p.name());
                    current.add(potential);
                }
            }
            protocolCombinations.addAll(current);
            last = current;
        }
        HashSet<String> combinationsAsString = new HashSet<String>(protocolCombinations.size());
        JsonMapper mapper = JsonMapper.builder().build();
        for (Set set : protocolCombinations) {
            try (StringWriter writer = new StringWriter();){
                mapper.writeValue((Writer)writer, (Object)set);
                combinationsAsString.add(writer.toString());
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unexpected IO Exception generating JSON string", e);
            }
        }
        return Collections.unmodifiableSet(combinationsAsString);
    }

    public static Collection<String> getAllAvailableTransportCombinations() {
        HashSet<Set<Transport>> combinations = new HashSet<Set<Transport>>();
        for (TransportProviderFactory providerFactory : new QpidServiceLoader().instancesOf(TransportProviderFactory.class)) {
            combinations.addAll(providerFactory.getSupportedTransports());
        }
        HashSet<String> combinationsAsString = new HashSet<String>(combinations.size());
        JsonMapper mapper = JsonMapper.builder().build();
        for (Set set : combinations) {
            try (StringWriter writer = new StringWriter();){
                mapper.writeValue((Writer)writer, (Object)set);
                combinationsAsString.add(writer.toString());
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unexpected IO Exception generating JSON string", e);
            }
        }
        return Collections.unmodifiableSet(combinationsAsString);
    }

    public static String getInstalledProtocolsAsString() {
        String string;
        Set<Protocol> installedProtocols = AmqpPortImpl.getInstalledProtocols();
        JsonMapper mapper = JsonMapper.builder().build();
        StringWriter output = new StringWriter();
        try {
            mapper.writeValue((Writer)output, installedProtocols);
            string = output.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    output.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ServerScopedRuntimeException(e);
            }
        }
        output.close();
        return string;
    }

    @Override
    public long decrementConnectionCount() {
        long maxOpenConnections = this.getMaxOpenConnections();
        long openConnections = this._connectionCount.decrementAndGet();
        if (maxOpenConnections > 0L && openConnections < maxOpenConnections * AmqpPortImpl.square(this._connectionWarnCount) / 10000L) {
            this._connectionCountWarningGiven.compareAndSet(true, false);
        }
        return openConnections;
    }

    private static long square(long val) {
        return val * val;
    }

    @Override
    public boolean acceptNewConnectionAndIncrementCount(SocketAddress remoteSocketAddress) {
        String addressString = remoteSocketAddress.toString();
        if (this._closingOrDeleting.get()) {
            this._container.getEventLogger().message(new PortLogSubject(this), PortMessages.CONNECTION_REJECTED_CLOSED(addressString));
            return false;
        }
        long maxOpenConnections = this.getMaxOpenConnections();
        if (maxOpenConnections > 0L) {
            long openConnections = this._connectionCount.getAndUpdate(count -> count < maxOpenConnections ? count + 1L : count);
            if (openConnections >= maxOpenConnections) {
                this._container.getEventLogger().message(new PortLogSubject(this), PortMessages.CONNECTION_REJECTED_TOO_MANY(addressString, this._maxOpenConnections));
                return false;
            }
            if (++openConnections > maxOpenConnections * (long)this._connectionWarnCount / 100L && this._connectionCountWarningGiven.compareAndSet(false, true)) {
                this._container.getEventLogger().message(new PortLogSubject(this), PortMessages.CONNECTION_COUNT_WARN(openConnections, this._connectionWarnCount, maxOpenConnections));
            }
        } else {
            this._connectionCount.incrementAndGet();
        }
        this._totalConnectionCount.incrementAndGet();
        return true;
    }

    @Override
    public long getConnectionCount() {
        return this._connectionCount.get();
    }

    @Override
    public long getTotalConnectionCount() {
        return this._totalConnectionCount.get();
    }

    @Override
    public long getProtocolHandshakeTimeout() {
        return this._protocolHandshakeTimeout;
    }

    @Override
    public void resetStatistics() {
        this._totalConnectionCount.set(0L);
        this.getChildren(Connection.class).forEach(Connection::resetStatistics);
    }

    @Override
    public boolean getCloseWhenNoRoute() {
        return this._closeWhenNoRoute;
    }

    @Override
    public int getSessionCountLimit() {
        return this._sessionCountLimit;
    }

    @Override
    public int getHeartbeatDelay() {
        return this._heartBeatDelay;
    }

    @Override
    public int getTLSSessionTimeout() {
        return this._tlsSessionTimeout;
    }

    @Override
    public int getTLSSessionCacheSize() {
        return this._tlsSessionCacheSize;
    }
}

