/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.util;

import java.util.concurrent.ThreadFactory;

public final class DaemonThreadFactory
implements ThreadFactory {
    private final String _threadName;
    private final Thread.UncaughtExceptionHandler _uncaughtExceptionHandler;
    private final ThreadGroup _threadGroup;

    public DaemonThreadFactory(String threadName) {
        this._threadName = threadName;
        this._uncaughtExceptionHandler = null;
        this._threadGroup = null;
    }

    public DaemonThreadFactory(String threadName, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this._threadName = threadName;
        this._uncaughtExceptionHandler = uncaughtExceptionHandler;
        this._threadGroup = null;
    }

    public DaemonThreadFactory(String threadName, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, ThreadGroup threadGroup) {
        this._threadName = threadName;
        this._uncaughtExceptionHandler = uncaughtExceptionHandler;
        this._threadGroup = threadGroup;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = this._threadGroup == null ? new Thread(runnable, this._threadName) : new Thread(this._threadGroup, runnable, this._threadName);
        thread.setDaemon(true);
        if (this._uncaughtExceptionHandler != null) {
            thread.setUncaughtExceptionHandler(this._uncaughtExceptionHandler);
        }
        return thread;
    }
}

