/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.entity;

import com.alipay.sofa.jraft.entity.Checksum;
import com.alipay.sofa.jraft.util.Bits;
import com.alipay.sofa.jraft.util.Copiable;
import com.alipay.sofa.jraft.util.CrcUtil;
import java.io.Serializable;

public class LogId
implements Comparable<LogId>,
Copiable<LogId>,
Serializable,
Checksum {
    private static final long serialVersionUID = -6680425579347357313L;
    private long index;
    private long term;

    @Override
    public LogId copy() {
        return new LogId(this.index, this.term);
    }

    @Override
    public long checksum() {
        byte[] bs = new byte[16];
        Bits.putLong(bs, 0, this.index);
        Bits.putLong(bs, 8, this.term);
        return CrcUtil.crc64(bs);
    }

    public LogId() {
        this(0L, 0L);
    }

    public LogId(long index, long term) {
        this.setIndex(index);
        this.setTerm(term);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.index ^ this.index >>> 32);
        result = 31 * result + (int)(this.term ^ this.term >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LogId other = (LogId)obj;
        if (this.index != other.index) {
            return false;
        }
        return this.term == other.term;
    }

    @Override
    public int compareTo(LogId o) {
        int c = Long.compare(this.getTerm(), o.getTerm());
        if (c == 0) {
            return Long.compare(this.getIndex(), o.getIndex());
        }
        return c;
    }

    public long getTerm() {
        return this.term;
    }

    public void setTerm(long term) {
        this.term = term;
    }

    public long getIndex() {
        return this.index;
    }

    public void setIndex(long index) {
        this.index = index;
    }

    public String toString() {
        return "LogId [index=" + this.index + ", term=" + this.term + "]";
    }
}

