/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.remoting;

import com.alipay.remoting.AbstractLifeCycle;
import com.alipay.remoting.BoltClient;
import com.alipay.remoting.config.BoltClientOption;
import com.alipay.remoting.config.BoltOption;
import com.alipay.remoting.config.BoltOptions;
import com.alipay.remoting.config.ConfigManager;
import com.alipay.remoting.config.ConfigurableInstance;
import com.alipay.remoting.config.Configuration;
import com.alipay.remoting.config.configs.ConfigContainer;
import com.alipay.remoting.config.configs.DefaultConfigContainer;
import com.alipay.remoting.config.switches.GlobalSwitch;

public abstract class AbstractBoltClient
extends AbstractLifeCycle
implements BoltClient,
ConfigurableInstance {
    private final BoltOptions options = new BoltOptions();
    private final GlobalSwitch globalSwitch = new GlobalSwitch();
    private final ConfigContainer configContainer;

    public AbstractBoltClient() {
        if (ConfigManager.conn_reconnect_switch()) {
            this.option(BoltClientOption.CONN_RECONNECT_SWITCH, true);
        } else {
            this.option(BoltClientOption.CONN_RECONNECT_SWITCH, false);
        }
        if (ConfigManager.conn_monitor_switch()) {
            this.option(BoltClientOption.CONN_MONITOR_SWITCH, true);
        } else {
            this.option(BoltClientOption.CONN_MONITOR_SWITCH, false);
        }
        this.configContainer = new DefaultConfigContainer();
    }

    @Override
    public <T> T option(BoltOption<T> option) {
        return this.options.option(option);
    }

    @Override
    public <T> Configuration option(BoltOption<T> option, T value) {
        this.options.option(option, value);
        return this;
    }

    @Override
    @Deprecated
    public ConfigContainer conf() {
        return this.configContainer;
    }

    @Override
    @Deprecated
    public GlobalSwitch switches() {
        return this.globalSwitch;
    }

    @Override
    public void initWriteBufferWaterMark(int low, int high) {
        this.option(BoltClientOption.NETTY_BUFFER_LOW_WATER_MARK, low);
        this.option(BoltClientOption.NETTY_BUFFER_HIGH_WATER_MARK, high);
    }

    @Override
    public int netty_buffer_low_watermark() {
        return (Integer)this.option(BoltClientOption.NETTY_BUFFER_LOW_WATER_MARK);
    }

    @Override
    public int netty_buffer_high_watermark() {
        return (Integer)this.option(BoltClientOption.NETTY_BUFFER_HIGH_WATER_MARK);
    }
}

