/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.governance.handler;

import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadConfig;
import io.github.resilience4j.bulkhead.BulkheadRegistry;
import io.github.resilience4j.micrometer.tagged.BulkheadMetricNames;
import io.github.resilience4j.micrometer.tagged.TaggedBulkheadMetrics;
import java.time.Duration;
import org.apache.servicecomb.governance.handler.AbstractGovernanceHandler;
import org.apache.servicecomb.governance.handler.Disposable;
import org.apache.servicecomb.governance.handler.DisposableBulkhead;
import org.apache.servicecomb.governance.marker.GovernanceRequestExtractor;
import org.apache.servicecomb.governance.policy.BulkheadPolicy;
import org.apache.servicecomb.governance.properties.BulkheadProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkheadHandler
extends AbstractGovernanceHandler<Bulkhead, BulkheadPolicy> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BulkheadHandler.class);
    private final BulkheadProperties bulkheadProperties;

    public BulkheadHandler(BulkheadProperties bulkheadProperties) {
        this.bulkheadProperties = bulkheadProperties;
    }

    @Override
    protected String createKey(GovernanceRequestExtractor requestExtractor, BulkheadPolicy policy) {
        return this.bulkheadProperties.getConfigKey() + "." + policy.getName();
    }

    @Override
    public BulkheadPolicy matchPolicy(GovernanceRequestExtractor requestExtractor) {
        return (BulkheadPolicy)this.matchersManager.match(requestExtractor, this.bulkheadProperties.getParsedEntity());
    }

    @Override
    public Disposable<Bulkhead> createProcessor(String key, GovernanceRequestExtractor requestExtractor, BulkheadPolicy policy) {
        return this.getBulkhead(key, policy);
    }

    private Disposable<Bulkhead> getBulkhead(String key, BulkheadPolicy policy) {
        LOGGER.info("applying new policy {} for {}", (Object)key, (Object)policy.toString());
        BulkheadConfig config = BulkheadConfig.custom().maxConcurrentCalls(policy.getMaxConcurrentCalls()).maxWaitDuration(Duration.parse(policy.getMaxWaitDuration())).build();
        BulkheadRegistry registry = BulkheadRegistry.of((BulkheadConfig)config);
        if (this.meterRegistry != null) {
            TaggedBulkheadMetrics.ofBulkheadRegistry((BulkheadMetricNames)BulkheadMetricNames.custom().availableConcurrentCallsMetricName(this.bulkheadProperties.getConfigKey() + ".available.concurrent.calls").maxAllowedConcurrentCallsMetricName(this.bulkheadProperties.getConfigKey() + ".max.allowed.concurrent.calls").build(), (BulkheadRegistry)registry).bindTo(this.meterRegistry);
        }
        return new DisposableBulkhead(key, registry, registry.bulkhead(key));
    }
}

