/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.registry.lightweight;

import com.google.common.eventbus.EventBus;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.servicecomb.registry.api.Registration;
import org.apache.servicecomb.registry.api.event.MicroserviceInstanceRegisteredEvent;
import org.apache.servicecomb.registry.api.registry.BasePath;
import org.apache.servicecomb.registry.api.registry.Microservice;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstanceStatus;
import org.apache.servicecomb.registry.lightweight.Self;
import org.apache.servicecomb.registry.lightweight.StoreService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractLightweightRegistration
implements Registration {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractLightweightRegistration.class);
    protected EventBus eventBus;
    protected StoreService storeService;
    protected Self self;

    @Autowired
    public AbstractLightweightRegistration setEventBus(EventBus eventBus) {
        this.eventBus = eventBus;
        return this;
    }

    @Autowired
    public AbstractLightweightRegistration setStoreService(StoreService storeService) {
        this.storeService = storeService;
        return this;
    }

    @Autowired
    public AbstractLightweightRegistration setSelf(Self self) {
        this.self = self;
        return this;
    }

    public void init() {
    }

    protected void startRegister(Duration interval) {
        Executors.newSingleThreadScheduledExecutor(runnable -> new Thread(runnable, this.name())).scheduleAtFixedRate(this::sendRegister, 0L, interval.getSeconds(), TimeUnit.SECONDS);
    }

    protected void postRegisteredEvent() {
        this.eventBus.post((Object)new MicroserviceInstanceRegisteredEvent(this.name(), this.self.getInstance().getInstanceId(), false));
    }

    protected void sendRegister() {
        try {
            this.doSendRegister();
        }
        catch (Exception e) {
            LOGGER.error("register failed.", (Throwable)e);
        }
    }

    protected abstract void doSendRegister() throws IOException;

    public MicroserviceInstance getMicroserviceInstance() {
        return this.self.getInstance();
    }

    public Microservice getMicroservice() {
        return this.self.getMicroservice();
    }

    public String getAppId() {
        return this.self.getMicroservice().getAppId();
    }

    public boolean updateMicroserviceInstanceStatus(MicroserviceInstanceStatus status) {
        this.self.getInstance().setStatus(status);
        return true;
    }

    public void addSchema(String schemaId, String content) {
        this.self.addSchema(schemaId, content);
    }

    public void addEndpoint(String endpoint) {
        this.self.getInstance().getEndpoints().add(endpoint);
    }

    public void addBasePath(Collection<BasePath> basePaths) {
        this.self.getMicroservice().getPaths().addAll(basePaths);
    }

    public void run() {
        this.storeService.registerSelf(this.self);
    }

    public void destroy() {
        try {
            this.doSendUnregister();
        }
        catch (Exception e) {
            LOGGER.error("unregister failed.", (Throwable)e);
        }
    }

    protected abstract void doSendUnregister() throws IOException;
}

