/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config.kie.client.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.servicecomb.config.kie.client.model.ConfigurationsRequest;
import org.apache.servicecomb.config.kie.client.model.KieConfiguration;
import org.apache.servicecomb.http.client.common.HttpUtils;

public class ConfigurationsRequestFactory {
    private static final String KEY_APP = "app";
    private static final String KEY_ENVIRONMENT = "environment";
    private static final String KEY_SERVICE = "service";
    private static final String KEY_VERSION = "version";
    private static final int CUSTOM_ORDER = 100;
    private static final int VERSION_ORDER = 200;
    private static final int SERVICE_ORDER = 300;
    private static final int APP_ORDER = 400;

    public static List<ConfigurationsRequest> buildConfigurationRequests(KieConfiguration configuration) {
        ArrayList<ConfigurationsRequest> result = new ArrayList<ConfigurationsRequest>();
        if (configuration.isEnableAppConfig()) {
            result.add(ConfigurationsRequestFactory.createAppConfigurationsRequest(configuration));
        }
        if (configuration.isEnableServiceConfig()) {
            result.add(ConfigurationsRequestFactory.createServiceConfigurationsRequest(configuration));
        }
        if (configuration.isEnableVersionConfig()) {
            result.add(ConfigurationsRequestFactory.createVersionConfigurationsRequest(configuration));
        }
        if (configuration.isEnableCustomConfig()) {
            result.add(ConfigurationsRequestFactory.createCustomConfigurationsRequest(configuration));
        }
        return result;
    }

    private static ConfigurationsRequest createAppConfigurationsRequest(KieConfiguration configuration) {
        return new ConfigurationsRequest().setOrder(400).setWithExact(true).setLabelsQuery(ConfigurationsRequestFactory.buildLabelQuery(ConfigurationsRequestFactory.buildLabelQueryItem(KEY_APP, configuration.getAppName()), ConfigurationsRequestFactory.buildLabelQueryItem(KEY_ENVIRONMENT, configuration.getEnvironment())));
    }

    private static ConfigurationsRequest createServiceConfigurationsRequest(KieConfiguration configuration) {
        return new ConfigurationsRequest().setOrder(300).setWithExact(true).setLabelsQuery(ConfigurationsRequestFactory.buildLabelQuery(ConfigurationsRequestFactory.buildLabelQueryItem(KEY_APP, configuration.getAppName()), ConfigurationsRequestFactory.buildLabelQueryItem(KEY_SERVICE, configuration.getServiceName()), ConfigurationsRequestFactory.buildLabelQueryItem(KEY_ENVIRONMENT, configuration.getEnvironment())));
    }

    private static ConfigurationsRequest createVersionConfigurationsRequest(KieConfiguration configuration) {
        return new ConfigurationsRequest().setOrder(200).setWithExact(true).setLabelsQuery(ConfigurationsRequestFactory.buildLabelQuery(ConfigurationsRequestFactory.buildLabelQueryItem(KEY_APP, configuration.getAppName()), ConfigurationsRequestFactory.buildLabelQueryItem(KEY_SERVICE, configuration.getServiceName()), ConfigurationsRequestFactory.buildLabelQueryItem(KEY_ENVIRONMENT, configuration.getEnvironment()), ConfigurationsRequestFactory.buildLabelQueryItem(KEY_VERSION, configuration.getVersion())));
    }

    private static ConfigurationsRequest createCustomConfigurationsRequest(KieConfiguration configuration) {
        return new ConfigurationsRequest().setOrder(100).setWithExact(false).setLabelsQuery(ConfigurationsRequestFactory.buildLabelQuery(ConfigurationsRequestFactory.buildLabelQueryItem(configuration.getCustomLabel(), configuration.getCustomLabelValue())));
    }

    private static String buildLabelQuery(String ... labels) {
        StringBuilder result = new StringBuilder();
        for (String label : labels) {
            result.append(label);
            result.append("&");
        }
        return result.toString();
    }

    private static String buildLabelQueryItem(String key, String value) {
        try {
            return "label=" + HttpUtils.encodeURLParam((String)(key + ":" + value));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("unexpected param", e);
        }
    }
}

