/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.impl.io;

import java.io.IOException;
import java.io.InputStream;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.vault.fs.api.AccessType;
import org.apache.jackrabbit.vault.fs.api.Artifact;
import org.apache.jackrabbit.vault.fs.api.ArtifactType;
import org.apache.jackrabbit.vault.fs.api.ImportArtifact;
import org.apache.jackrabbit.vault.fs.api.SerializationType;
import org.apache.jackrabbit.vault.fs.api.VaultInputSource;
import org.apache.jackrabbit.vault.fs.impl.AbstractArtifact;

public class InputSourceArtifact
extends AbstractArtifact
implements ImportArtifact {
    private final VaultInputSource source;
    private final SerializationType serType;

    public InputSourceArtifact(Artifact base, VaultInputSource source) {
        super(base, base.getType());
        this.source = source;
        this.serType = base.getSerializationType();
        this.setContentType(base.getContentType());
    }

    public InputSourceArtifact(Artifact parent, String repoName, String extension, ArtifactType type, VaultInputSource source, SerializationType serType) {
        super(parent, repoName, extension, type);
        this.source = source;
        this.serType = serType;
    }

    public InputSourceArtifact(InputSourceArtifact isa, ArtifactType type) {
        super(isa, type);
        this.source = isa.source;
        this.serType = isa.serType;
    }

    @Override
    public SerializationType getSerializationType() {
        return this.serType;
    }

    @Override
    public AccessType getPreferredAccess() {
        return AccessType.STREAM;
    }

    @Override
    public InputStream getInputStream() throws IOException, RepositoryException {
        return this.source.getByteStream();
    }

    @Override
    public VaultInputSource getInputSource() throws IOException, RepositoryException {
        return this.source;
    }

    @Override
    public long getLastModified() {
        return this.source.getLastModified();
    }

    @Override
    public long getContentLength() {
        return this.source.getContentLength();
    }
}

