/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.statement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import liquibase.repackaged.net.sf.jsqlparser.statement.Statement;
import liquibase.repackaged.net.sf.jsqlparser.statement.StatementVisitor;

public abstract class CreateFunctionalStatement
implements Statement {
    private String kind;
    private boolean orReplace = false;
    private List<String> functionDeclarationParts;

    protected CreateFunctionalStatement(String string) {
        this.kind = string;
    }

    protected CreateFunctionalStatement(String string, List<String> list) {
        this(false, string, list);
    }

    protected CreateFunctionalStatement(boolean bl2, String string, List<String> list) {
        this.orReplace = bl2;
        this.kind = string;
        this.functionDeclarationParts = list;
    }

    public void setFunctionDeclarationParts(List<String> list) {
        this.functionDeclarationParts = list;
    }

    public List<String> getFunctionDeclarationParts() {
        return this.functionDeclarationParts;
    }

    public String getKind() {
        return this.kind;
    }

    public void setOrReplace(boolean bl2) {
        this.orReplace = bl2;
    }

    public String formatDeclaration() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < this.functionDeclarationParts.size(); ++i2) {
            String string = this.functionDeclarationParts.get(i2);
            stringBuilder.append(string);
            if (i2 + 1 >= this.functionDeclarationParts.size() || this.functionDeclarationParts.get(i2 + 1).equals(";")) continue;
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public String toString() {
        return "CREATE " + (this.orReplace ? "OR REPLACE " : "") + this.kind + " " + this.formatDeclaration();
    }

    public CreateFunctionalStatement withFunctionDeclarationParts(List<String> list) {
        this.setFunctionDeclarationParts(list);
        return this;
    }

    public CreateFunctionalStatement addFunctionDeclarationParts(String ... stringArray) {
        List list = Optional.ofNullable(this.getFunctionDeclarationParts()).orElseGet(ArrayList::new);
        Collections.addAll(list, stringArray);
        return this.withFunctionDeclarationParts(list);
    }

    public CreateFunctionalStatement addFunctionDeclarationParts(Collection<String> collection) {
        List list = Optional.ofNullable(this.getFunctionDeclarationParts()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withFunctionDeclarationParts(list);
    }
}

