/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.form.datepicker;

import com.googlecode.wicket.jquery.core.JQueryEvent;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.ajax.IJQueryAjaxAware;
import com.googlecode.wicket.jquery.core.ajax.JQueryAjaxBehavior;
import com.googlecode.wicket.jquery.core.ajax.JQueryAjaxPostBehavior;
import com.googlecode.wicket.jquery.core.utils.JQueryUtils;
import com.googlecode.wicket.jquery.core.utils.RequestCycleUtils;
import com.googlecode.wicket.jquery.ui.JQueryUIBehavior;
import com.googlecode.wicket.jquery.ui.form.datepicker.IDatePickerListener;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.util.lang.Args;

public abstract class DatePickerBehavior
extends JQueryUIBehavior
implements IJQueryAjaxAware {
    private static final long serialVersionUID = 1L;
    public static final String METHOD = "datepicker";
    private JQueryAjaxBehavior onSelectAjaxBehavior = null;
    private final IDatePickerListener listener;

    public DatePickerBehavior(String selector, IDatePickerListener listener) {
        this(selector, new Options(), listener);
    }

    public DatePickerBehavior(String selector, Options options, IDatePickerListener listener) {
        super(selector, METHOD, options);
        this.listener = (IDatePickerListener)Args.notNull((Object)listener, (String)"listener");
    }

    public void bind(Component component) {
        super.bind(component);
        if (this.listener.isOnSelectEventEnabled()) {
            this.onSelectAjaxBehavior = this.newOnSelectAjaxBehavior(this);
            component.add(new Behavior[]{this.onSelectAjaxBehavior});
        }
    }

    @Override
    public void destroy(IPartialPageRequestHandler handler) {
        String statement = this.$(Options.asString((String)"destroy"));
        handler.prependJavaScript((CharSequence)JQueryUtils.trycatch((String)statement));
        this.onDestroy(handler);
    }

    @Override
    public void onConfigure(Component component) {
        if (this.onSelectAjaxBehavior != null) {
            this.setOption("onSelect", this.onSelectAjaxBehavior.getCallbackFunction());
        }
        super.onConfigure(component);
    }

    public void onAjax(AjaxRequestTarget target, JQueryEvent event) {
        if (event instanceof SelectEvent) {
            this.listener.onSelect(target, ((SelectEvent)event).getDateText());
        }
    }

    protected abstract JQueryAjaxPostBehavior newOnSelectAjaxBehavior(IJQueryAjaxAware var1);

    protected static class SelectEvent
    extends JQueryEvent {
        private final String date = RequestCycleUtils.getPostParameterValue((String)"dateText").toString();

        public String getDateText() {
            return this.date;
        }
    }

    protected static class OnSelectAjaxBehavior
    extends JQueryAjaxPostBehavior {
        private static final long serialVersionUID = 1L;

        public OnSelectAjaxBehavior(IJQueryAjaxAware source) {
            super(source, new FormComponent[0]);
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.explicit((String)"dateText"), CallbackParameter.context((String)"inst")};
        }

        protected JQueryEvent newEvent() {
            return new SelectEvent();
        }
    }
}

