/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java;

import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.syncope.common.lib.audit.AuditEntry;
import org.apache.syncope.common.lib.request.UserCR;
import org.apache.syncope.common.lib.request.UserUR;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AuditElements;
import org.apache.syncope.common.lib.types.AuditLoggerName;
import org.apache.syncope.core.persistence.api.dao.AuditConfDAO;
import org.apache.syncope.core.persistence.api.entity.AuditConf;
import org.apache.syncope.core.provisioning.api.AuditManager;
import org.apache.syncope.core.provisioning.api.event.AfterHandlingEvent;
import org.apache.syncope.core.provisioning.api.serialization.POJOHelper;
import org.apache.syncope.core.provisioning.api.utils.ExceptionUtils2;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class DefaultAuditManager
implements AuditManager {
    protected static final String MASKED_VALUE = "<MASKED>";
    protected final AuditConfDAO auditConfDAO;

    protected static Object maskSensitive(Object object) {
        Object masked;
        if (object instanceof UserTO) {
            masked = SerializationUtils.clone((Serializable)((UserTO)object));
            if (((UserTO)masked).getPassword() != null) {
                ((UserTO)masked).setPassword(MASKED_VALUE);
            }
            if (((UserTO)masked).getSecurityAnswer() != null) {
                ((UserTO)masked).setSecurityAnswer(MASKED_VALUE);
            }
        } else if (object instanceof UserCR) {
            masked = SerializationUtils.clone((Serializable)((UserCR)object));
            if (((UserCR)masked).getPassword() != null) {
                ((UserCR)masked).setPassword(MASKED_VALUE);
            }
            if (((UserCR)masked).getSecurityAnswer() != null) {
                ((UserCR)masked).setSecurityAnswer(MASKED_VALUE);
            }
        } else if (object instanceof UserUR && ((UserUR)object).getPassword() != null) {
            masked = SerializationUtils.clone((Serializable)((UserUR)object));
            ((UserUR)masked).getPassword().setValue((Object)MASKED_VALUE);
        } else {
            masked = object;
        }
        return masked;
    }

    public DefaultAuditManager(AuditConfDAO auditConfDAO) {
        this.auditConfDAO = auditConfDAO;
    }

    public boolean auditRequested(String who, AuditElements.EventCategoryType type, String category, String subcategory, String event) {
        AuditEntry auditEntry = new AuditEntry();
        auditEntry.setWho(who);
        auditEntry.setLogger(new AuditLoggerName(type, category, subcategory, event, AuditElements.Result.SUCCESS));
        auditEntry.setDate(OffsetDateTime.now());
        AuditConf auditConf = this.auditConfDAO.find(auditEntry.getLogger().toAuditKey());
        if (auditConf != null && auditConf.isActive()) {
            return true;
        }
        auditEntry.setLogger(new AuditLoggerName(type, category, subcategory, event, AuditElements.Result.FAILURE));
        auditConf = this.auditConfDAO.find(auditEntry.getLogger().toAuditKey());
        return auditConf != null && auditConf.isActive();
    }

    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public void audit(AfterHandlingEvent event) {
        this.audit(event.getWho(), event.getType(), event.getCategory(), event.getSubcategory(), event.getEvent(), event.getCondition(), event.getBefore(), event.getOutput(), event.getInput());
    }

    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public void audit(String who, AuditElements.EventCategoryType type, String category, String subcategory, String event, AuditElements.Result condition, Object before, Object output, Object ... input) {
        AuditLoggerName auditLoggerName = new AuditLoggerName(type, category, subcategory, event, condition);
        Optional.ofNullable(this.auditConfDAO.find(auditLoggerName.toAuditKey())).filter(AuditConf::isActive).ifPresent(audit -> {
            Throwable throwable = output instanceof Throwable ? (Throwable)output : null;
            AuditEntry auditEntry = new AuditEntry();
            auditEntry.setWho(who);
            auditEntry.setLogger(auditLoggerName);
            auditEntry.setDate(OffsetDateTime.now());
            auditEntry.setBefore(before instanceof String ? (String)before : POJOHelper.serialize((Object)DefaultAuditManager.maskSensitive(before)));
            if (throwable == null) {
                auditEntry.setOutput(output instanceof String ? (String)output : POJOHelper.serialize((Object)DefaultAuditManager.maskSensitive(output)));
            } else {
                auditEntry.setOutput(throwable.getMessage());
                auditEntry.setThrowable(ExceptionUtils2.getFullStackTrace((Throwable)throwable));
            }
            if (input != null) {
                auditEntry.getInputs().addAll(Arrays.stream(input).map(item -> item instanceof String ? (String)item : POJOHelper.serialize((Object)DefaultAuditManager.maskSensitive(item))).collect(Collectors.toList()));
            }
            Logger logger = LoggerFactory.getLogger((String)AuditLoggerName.getAuditLoggerName((String)AuthContextUtils.getDomain()));
            Logger eventLogger = LoggerFactory.getLogger((String)AuditLoggerName.getAuditEventLoggerName((String)AuthContextUtils.getDomain(), (String)audit.getKey()));
            String serializedAuditEntry = POJOHelper.serialize((Object)auditEntry);
            if (throwable == null) {
                logger.debug(serializedAuditEntry);
                eventLogger.debug(serializedAuditEntry);
            } else {
                logger.debug(serializedAuditEntry, throwable);
                eventLogger.debug(serializedAuditEntry, throwable);
            }
        });
    }
}

