/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.SurrogateAuthenticationPrincipalBuilder;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.resolvers.PersonDirectoryPrincipalResolver;
import org.apereo.cas.authentication.principal.resolvers.PrincipalResolutionContext;
import org.apereo.cas.authentication.surrogate.SurrogateCredentialTrait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SurrogatePrincipalResolver
extends PersonDirectoryPrincipalResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SurrogatePrincipalResolver.class);
    private SurrogateAuthenticationPrincipalBuilder surrogatePrincipalBuilder;

    public SurrogatePrincipalResolver(PrincipalResolutionContext context) {
        super(context);
    }

    public boolean supports(Credential credential) {
        return super.supports(credential) && credential.getCredentialMetadata().getTrait(SurrogateCredentialTrait.class).stream().anyMatch(trait -> StringUtils.isNotBlank((CharSequence)trait.getSurrogateUsername()));
    }

    protected Principal buildResolvedPrincipal(String id, Map<String, List<Object>> attributes, Credential credential, Optional<Principal> currentPrincipal, Optional<AuthenticationHandler> handler) throws Throwable {
        if (!this.supports(credential)) {
            return super.buildResolvedPrincipal(id, attributes, credential, currentPrincipal, handler);
        }
        Principal principal = currentPrincipal.orElseThrow(() -> new IllegalArgumentException("Current principal resolved cannot be empty"));
        return this.surrogatePrincipalBuilder.buildSurrogatePrincipal(id, principal);
    }

    protected String extractPrincipalId(Credential credential, Optional<Principal> currentPrincipal) {
        LOGGER.debug("Attempting to extract principal id for principal [{}]", currentPrincipal);
        if (!this.supports(credential)) {
            LOGGER.trace("Provided credential [{}] is not supported for surrogate authentication", (Object)credential);
            return super.extractPrincipalId(credential, currentPrincipal);
        }
        if (currentPrincipal.isEmpty()) {
            throw new IllegalArgumentException("Current principal resolved cannot be null");
        }
        String id = credential.getCredentialMetadata().getTrait(SurrogateCredentialTrait.class).map(SurrogateCredentialTrait::getSurrogateUsername).orElseThrow();
        LOGGER.debug("Resolving principal id for surrogate authentication as [{}]", (Object)id);
        return id;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    @Generated
    public SurrogatePrincipalResolver setSurrogatePrincipalBuilder(SurrogateAuthenticationPrincipalBuilder surrogatePrincipalBuilder) {
        this.surrogatePrincipalBuilder = surrogatePrincipalBuilder;
        return this;
    }
}

