/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.net.InetAddress;
import kafka.server.BaseClientQuotaManagerTest;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManagerTest$UserClient$;
import kafka.server.QuotaType;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.Sanitizer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.network.Session;
import org.apache.kafka.server.config.ClientQuotaManagerConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t-d\u0001B\u001c9\u0001uBQA\u0011\u0001\u0005\u0002\rCq!\u0012\u0001C\u0002\u0013%a\t\u0003\u0004S\u0001\u0001\u0006Ia\u0012\u0005\u0006'\u0002!I\u0001\u0016\u0005\b\u0003o\u0003A\u0011AA]\u0011\u001d\t\t\u000e\u0001C\u0001\u0003sCq!!6\u0001\t\u0003\tI\fC\u0004\u0002Z\u0002!\t!!/\t\u000f\u0005u\u0007\u0001\"\u0001\u0002:\"9\u0011\u0011\u001d\u0001\u0005\n\u0005\r\bb\u0002B\u0003\u0001\u0011\u0005\u0011\u0011\u0018\u0005\b\u0005\u0013\u0001A\u0011AA]\u0011\u001d\u0011i\u0001\u0001C\u0001\u0003sCqA!\u0005\u0001\t\u0003\tI\fC\u0004\u0003\u0016\u0001!\t!!/\t\u000f\te\u0001\u0001\"\u0001\u0002:\"9!Q\u0004\u0001\u0005\u0002\u0005e\u0006b\u0002B\u0011\u0001\u0011\u0005\u0011\u0011\u0018\u0005\b\u0005K\u0001A\u0011AA]\r\u0011\u0001\u0007\u0001R1\t\u0011Q$\"Q3A\u0005\u0002UD\u0001B \u000b\u0003\u0012\u0003\u0006IA\u001e\u0005\t\u007fR\u0011)\u001a!C\u0001k\"I\u0011\u0011\u0001\u000b\u0003\u0012\u0003\u0006IA\u001e\u0005\u000b\u0003\u0007!\"Q3A\u0005\u0002\u0005\u0015\u0001BCA\u0007)\tE\t\u0015!\u0003\u0002\b!Q\u0011q\u0002\u000b\u0003\u0016\u0004%\t!!\u0002\t\u0015\u0005EAC!E!\u0002\u0013\t9\u0001\u0003\u0004C)\u0011\u0005\u00111\u0003\u0005\b\u0003;!B\u0011AA\u0010\u0011%\t\t\u0004FA\u0001\n\u0003\t\u0019\u0004C\u0005\u0002>Q\t\n\u0011\"\u0001\u0002@!I\u0011Q\u000b\u000b\u0012\u0002\u0013\u0005\u0011q\b\u0005\n\u0003/\"\u0012\u0013!C\u0001\u00033B\u0011\"!\u0018\u0015#\u0003%\t!!\u0017\t\u0013\u0005}C#!A\u0005B\u0005\u0005\u0004\"CA2)\u0005\u0005I\u0011AA3\u0011%\ti\u0007FA\u0001\n\u0003\ty\u0007C\u0005\u0002|Q\t\t\u0011\"\u0011\u0002~!I\u00111\u0012\u000b\u0002\u0002\u0013\u0005\u0011Q\u0012\u0005\n\u0003/#\u0012\u0011!C!\u00033C\u0011\"!(\u0015\u0003\u0003%\t%a(\t\u0013\u0005\u0005F#!A\u0005B\u0005\r\u0006\"CAS)\u0005\u0005I\u0011IAT\u000f%\u0011I\u0003AA\u0001\u0012\u0013\u0011YC\u0002\u0005a\u0001\u0005\u0005\t\u0012\u0002B\u0017\u0011\u0019\u0011e\u0006\"\u0001\u0003F!I\u0011\u0011\u0015\u0018\u0002\u0002\u0013\u0015\u00131\u0015\u0005\n\u0005\u000fr\u0013\u0011!CA\u0005\u0013B\u0011Ba\u0015/#\u0003%\t!!\u0017\t\u0013\tUc&%A\u0005\u0002\u0005e\u0003\"\u0003B,]\u0005\u0005I\u0011\u0011B-\u0011%\u00119GLI\u0001\n\u0003\tI\u0006C\u0005\u0003j9\n\n\u0011\"\u0001\u0002Z\t12\t\\5f]R\fVo\u001c;b\u001b\u0006t\u0017mZ3s)\u0016\u001cHO\u0003\u0002:u\u000511/\u001a:wKJT\u0011aO\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001a\b\u0005\u0002@\u00016\t\u0001(\u0003\u0002Bq\tQ\")Y:f\u00072LWM\u001c;Rk>$\u0018-T1oC\u001e,'\u000fV3ti\u00061A(\u001b8jiz\"\u0012\u0001\u0012\t\u0003\u007f\u0001\taaY8oM&<W#A$\u0011\u0005!\u0003V\"A%\u000b\u0005\u0015S%BA\u001dL\u0015\tYDJ\u0003\u0002N\u001d\u00061\u0011\r]1dQ\u0016T\u0011aT\u0001\u0004_J<\u0017BA)J\u0005a\u0019E.[3oiF+x\u000e^1NC:\fw-\u001a:D_:4\u0017nZ\u0001\bG>tg-[4!\u0003A!Xm\u001d;Rk>$\u0018\rU1sg&tw\rF\u0005V7r\u000bY+a,\u00024B\u0011a+W\u0007\u0002/*\t\u0001,A\u0003tG\u0006d\u0017-\u0003\u0002[/\n!QK\\5u\u0011\u0015)E\u00011\u0001H\u0011\u0015iF\u00011\u0001_\u0003\u001d\u0019G.[3oiF\u0002\"a\u0018\u000b\u000e\u0003\u0001\u0011!\"V:fe\u000ec\u0017.\u001a8u'\u0011!\"-\u001a5\u0011\u0005Y\u001b\u0017B\u00013X\u0005\u0019\te.\u001f*fMB\u0011aKZ\u0005\u0003O^\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002jc:\u0011!n\u001c\b\u0003W:l\u0011\u0001\u001c\u0006\u0003[r\na\u0001\u0010:p_Rt\u0014\"\u0001-\n\u0005A<\u0016a\u00029bG.\fw-Z\u0005\u0003eN\u0014AbU3sS\u0006d\u0017N_1cY\u0016T!\u0001],\u0002\tU\u001cXM]\u000b\u0002mB\u0011qo\u001f\b\u0003qf\u0004\"a[,\n\u0005i<\u0016A\u0002)sK\u0012,g-\u0003\u0002}{\n11\u000b\u001e:j]\u001eT!A_,\u0002\u000bU\u001cXM\u001d\u0011\u0002\u0011\rd\u0017.\u001a8u\u0013\u0012\f\u0011b\u00197jK:$\u0018\n\u001a\u0011\u0002\u0015\r|gNZ5h+N,'/\u0006\u0002\u0002\bA!a+!\u0003w\u0013\r\tYa\u0016\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u0017\r|gNZ5h+N,'\u000fI\u0001\u000fG>tg-[4DY&,g\u000e^%e\u0003=\u0019wN\u001c4jO\u000ec\u0017.\u001a8u\u0013\u0012\u0004C#\u00030\u0002\u0016\u0005]\u0011\u0011DA\u000e\u0011\u0015!X\u00041\u0001w\u0011\u0015yX\u00041\u0001w\u0011%\t\u0019!\bI\u0001\u0002\u0004\t9\u0001C\u0005\u0002\u0010u\u0001\n\u00111\u0001\u0002\b\u000592/\u00198ji&TX\rZ\"p]\u001aLwm\u00117jK:$\u0018\nZ\u000b\u0003\u0003C\u0001RAVA\u0005\u0003G\u0001B!!\n\u000205\u0011\u0011q\u0005\u0006\u0005\u0003S\tY#\u0001\u0003mC:<'BAA\u0017\u0003\u0011Q\u0017M^1\n\u0007q\f9#\u0001\u0003d_BLH#\u00030\u00026\u0005]\u0012\u0011HA\u001e\u0011\u001d!x\u0004%AA\u0002YDqa`\u0010\u0011\u0002\u0003\u0007a\u000fC\u0005\u0002\u0004}\u0001\n\u00111\u0001\u0002\b!I\u0011qB\u0010\u0011\u0002\u0003\u0007\u0011qA\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t\tEK\u0002w\u0003\u0007Z#!!\u0012\u0011\t\u0005\u001d\u0013\u0011K\u0007\u0003\u0003\u0013RA!a\u0013\u0002N\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u001f:\u0016AC1o]>$\u0018\r^5p]&!\u00111KA%\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"!a\u0017+\t\u0005\u001d\u00111I\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111E\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003O\u00022AVA5\u0013\r\tYg\u0016\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003c\n9\bE\u0002W\u0003gJ1!!\u001eX\u0005\r\te.\u001f\u0005\n\u0003s2\u0013\u0011!a\u0001\u0003O\n1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA@!\u0019\t\t)a\"\u0002r5\u0011\u00111\u0011\u0006\u0004\u0003\u000b;\u0016AC2pY2,7\r^5p]&!\u0011\u0011RAB\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005=\u0015Q\u0013\t\u0004-\u0006E\u0015bAAJ/\n9!i\\8mK\u0006t\u0007\"CA=Q\u0005\u0005\t\u0019AA9\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005\r\u00121\u0014\u0005\n\u0003sJ\u0013\u0011!a\u0001\u0003O\n\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003O\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003G\ta!Z9vC2\u001cH\u0003BAH\u0003SC\u0011\"!\u001f-\u0003\u0003\u0005\r!!\u001d\t\r\u00055F\u00011\u0001_\u0003\u001d\u0019G.[3oiJBa!!-\u0005\u0001\u0004q\u0016\u0001\u0004:b]\u0012|Wn\u00117jK:$\bBBA[\t\u0001\u0007a,A\neK\u001a\fW\u000f\u001c;D_:4\u0017nZ\"mS\u0016tG/\u0001\ruKN$8\t\\5f]RLE-U;pi\u0006\u0004\u0016M]:j]\u001e$\u0012!\u0016\u0015\u0004\u000b\u0005u\u0006\u0003BA`\u0003\u001bl!!!1\u000b\t\u0005\r\u0017QY\u0001\u0004CBL'\u0002BAd\u0003\u0013\fqA[;qSR,'OC\u0002\u0002L:\u000bQA[;oSRLA!a4\u0002B\n!A+Z:u\u0003Q!Xm\u001d;Vg\u0016\u0014\u0018+^8uCB\u000b'o]5oO\"\u001aa!!0\u00029Q,7\u000f^+tKJ\u001cE.[3oi&#\u0017+^8uCB\u000b'o]5oO\"\u001aq!!0\u0002YQ,7\u000f^+tKJ\fVo\u001c;b!\u0006\u00148/\u001b8h/&$\b\u000eR3gCVdGo\u00117jK:$\u0018\nZ)v_R\f\u0007f\u0001\u0005\u0002>\u0006!D/Z:u+N,'o\u00117jK:$\u0018+^8uCB\u000b'o]5oO&#w+\u001b;i\t\u00164\u0017-\u001e7u\u00072LWM\u001c;JIF+x\u000e^1)\u0007%\ti,\u0001\u0006dQ\u0016\u001c7.U;pi\u0006$R\"VAs\u0003_\f\t0a=\u0002~\n\u0005\u0001bBAt\u0015\u0001\u0007\u0011\u0011^\u0001\rcV|G/Y'b]\u0006<WM\u001d\t\u0004\u007f\u0005-\u0018bAAwq\t\u00112\t\\5f]R\fVo\u001c;b\u001b\u0006t\u0017mZ3s\u0011\u0015!(\u00021\u0001w\u0011\u0015y(\u00021\u0001w\u0011\u001d\t)P\u0003a\u0001\u0003o\fQ\"\u001a=qK\u000e$X\r\u001a\"pk:$\u0007c\u0001,\u0002z&\u0019\u00111`,\u0003\t1{gn\u001a\u0005\b\u0003\u007fT\u0001\u0019AA4\u0003\u00151\u0018\r\\;f\u0011\u001d\u0011\u0019A\u0003a\u0001\u0003\u001f\u000ba\"\u001a=qK\u000e$H\u000b\u001b:piRdW-A\u001buKN$x)\u001a;NCb4\u0016\r\\;f\u0013:\fVo\u001c;b/&tGm\\<XSRDgj\u001c8EK\u001a\fW\u000f\u001c;Rk>$\u0018mV5oI><\bfA\u0006\u0002>\u0006\u0001C/Z:u'\u0016$\u0018I\u001c3SK6|g/\u001a#fM\u0006,H\u000e^+tKJ\fVo\u001c;bQ\ra\u0011QX\u0001\u001ai\u0016\u001cHoU3u\u0003:$'+Z7pm\u0016,6/\u001a:Rk>$\u0018\rK\u0002\u000e\u0003{\u000bq\u0004^3tiN+G/\u00118e%\u0016lwN^3Vg\u0016\u00148\t\\5f]R\fVo\u001c;bQ\rq\u0011QX\u0001\u001ai\u0016\u001cH/U;pi\u0006\u001cuN\u001c4jOB\u0013XmY3eK:\u001cW\rK\u0002\u0010\u0003{\u000b!\u0003^3tiF+x\u000e^1WS>d\u0017\r^5p]\"\u001a\u0001#!0\u00029Q,7\u000f^#ya&\u0014X\r\u00165s_R$H.\u001a+j[\u0016\u001cVM\\:pe\"\u001a\u0011#!0\u0002-Q,7\u000f^#ya&\u0014X-U;pi\u0006\u001cVM\\:peND3AEA_\u0003a!Xm\u001d;DY&,g\u000e^%e\u001d>$8+\u00198ji&TX\r\u001a\u0015\u0004'\u0005u\u0016AC+tKJ\u001cE.[3oiB\u0011qLL\n\u0006]\t=\"1\b\t\f\u0005c\u00119D\u001e<\u0002\b\u0005\u001da,\u0004\u0002\u00034)\u0019!QG,\u0002\u000fI,h\u000e^5nK&!!\u0011\bB\u001a\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g\u000e\u000e\t\u0005\u0005{\u0011\u0019%\u0004\u0002\u0003@)!!\u0011IA\u0016\u0003\tIw.C\u0002s\u0005\u007f!\"Aa\u000b\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0013y\u0013YE!\u0014\u0003P\tE\u0003\"\u0002;2\u0001\u00041\b\"B@2\u0001\u00041\b\"CA\u0002cA\u0005\t\u0019AA\u0004\u0011%\ty!\rI\u0001\u0002\u0004\t9!A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00134\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\"\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u00057\u0012\u0019\u0007E\u0003W\u0003\u0013\u0011i\u0006E\u0005W\u0005?2h/a\u0002\u0002\b%\u0019!\u0011M,\u0003\rQ+\b\u000f\\35\u0011!\u0011)\u0007NA\u0001\u0002\u0004q\u0016a\u0001=%a\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"\u0004")
public class ClientQuotaManagerTest
extends BaseClientQuotaManagerTest {
    private volatile ClientQuotaManagerTest$UserClient$ UserClient$module;
    private final ClientQuotaManagerConfig config = new ClientQuotaManagerConfig();

    private ClientQuotaManagerTest$UserClient$ UserClient() {
        if (this.UserClient$module == null) {
            this.UserClient$lzycompute$1();
        }
        return this.UserClient$module;
    }

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    private void testQuotaParsing(ClientQuotaManagerConfig config, UserClient client1, UserClient client2, UserClient randomClient, UserClient defaultConfigClient) {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(config, this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$);
        try {
            clientQuotaManager.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(2000.0, true)));
            clientQuotaManager.updateQuota(client2.configUser(), client2.configClientId(), client2.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(4000.0, true)));
            Assertions.assertEquals((double)9.223372036854776E18, (double)clientQuotaManager.quota(randomClient.user(), randomClient.clientId()).bound(), (double)0.0, (String)new StringBuilder(63).append("Default producer quota should be ").append(9.223372036854776E18).toString());
            Assertions.assertEquals((double)2000.0, (double)clientQuotaManager.quota(client1.user(), client1.clientId()).bound(), (double)0.0, (String)"Should return the overridden value (2000)");
            Assertions.assertEquals((double)4000.0, (double)clientQuotaManager.quota(client2.user(), client2.clientId()).bound(), (double)0.0, (String)"Should return the overridden value (4000)");
            int throttleTimeMs = this.maybeRecord(clientQuotaManager, client1.user(), client1.clientId(), 2500 * config.numQuotaSamples);
            Assertions.assertTrue((throttleTimeMs > 0 ? 1 : 0) != 0, (String)new StringBuilder(34).append("throttleTimeMs should be > 0. was ").append(throttleTimeMs).toString());
            clientQuotaManager.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(3000.0, true)));
            Assertions.assertEquals((double)3000.0, (double)clientQuotaManager.quota(client1.user(), client1.clientId()).bound(), (double)0.0, (String)"Should return the newly overridden value (3000)");
            throttleTimeMs = this.maybeRecord(clientQuotaManager, client1.user(), client1.clientId(), 0.0);
            Assertions.assertEquals((int)0, (int)throttleTimeMs, (String)new StringBuilder(32).append("throttleTimeMs should be 0. was ").append(throttleTimeMs).toString());
            clientQuotaManager.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((double)500.0, (double)clientQuotaManager.quota(client1.user(), client1.clientId()).bound(), (double)0.0, (String)"Should return the default value (500)");
            throttleTimeMs = this.maybeRecord(clientQuotaManager, client1.user(), client1.clientId(), 0.0);
            Assertions.assertTrue((throttleTimeMs > 0 ? 1 : 0) != 0, (String)new StringBuilder(34).append("throttleTimeMs should be > 0. was ").append(throttleTimeMs).toString());
            clientQuotaManager.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)None$.MODULE$);
            clientQuotaManager.updateQuota(defaultConfigClient.configUser(), defaultConfigClient.configClientId(), defaultConfigClient.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(4000.0, true)));
            Assertions.assertEquals((double)4000.0, (double)clientQuotaManager.quota(client1.user(), client1.clientId()).bound(), (double)0.0, (String)"Should return the newly overridden value (4000)");
            throttleTimeMs = this.maybeRecord(clientQuotaManager, client1.user(), client1.clientId(), 1000 * config.numQuotaSamples);
            Assertions.assertEquals((int)0, (int)throttleTimeMs, (String)new StringBuilder(32).append("throttleTimeMs should be 0. was ").append(throttleTimeMs).toString());
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testClientIdQuotaParsing() {
        UserClient client1 = new UserClient(this, "ANONYMOUS", "p1", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "ANONYMOUS", "p2", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "ANONYMOUS", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)"<default>"));
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserQuotaParsing() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)None$.MODULE$);
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)None$.MODULE$);
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)"<default>"), (Option<String>)None$.MODULE$);
        ClientQuotaManagerConfig config = new ClientQuotaManagerConfig();
        this.testQuotaParsing(config, client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserClientIdQuotaParsing() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)"<default>"), (Option<String>)new Some((Object)"<default>"));
        ClientQuotaManagerConfig config = new ClientQuotaManagerConfig();
        this.testQuotaParsing(config, client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserQuotaParsingWithDefaultClientIdQuota() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)None$.MODULE$);
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)None$.MODULE$);
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)"<default>"), (Option<String>)None$.MODULE$);
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserClientQuotaParsingIdWithDefaultClientIdQuota() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)"<default>"), (Option<String>)new Some((Object)"<default>"));
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    private void checkQuota(ClientQuotaManager quotaManager, String user, String clientId, long expectedBound, int value, boolean expectThrottle) {
        Assertions.assertEquals((double)expectedBound, (double)quotaManager.quota(user, clientId).bound(), (double)0.0);
        Session session = new Session(new KafkaPrincipal("User", user), InetAddress.getLocalHost());
        Assertions.assertEquals((double)(expectedBound < Long.MAX_VALUE ? (double)(this.config().quotaWindowSizeSeconds * (this.config().numQuotaSamples - 1)) * (double)expectedBound : Double.MAX_VALUE), (double)quotaManager.getMaxValueInQuotaWindow(session, clientId), (double)0.01);
        int throttleTimeMs = this.maybeRecord(quotaManager, user, clientId, value * this.config().numQuotaSamples);
        if (expectThrottle) {
            Assertions.assertTrue((throttleTimeMs > 0 ? 1 : 0) != 0, (String)new StringBuilder(34).append("throttleTimeMs should be > 0. was ").append(throttleTimeMs).toString());
            return;
        }
        Assertions.assertEquals((int)0, (int)throttleTimeMs, (String)new StringBuilder(32).append("throttleTimeMs should be 0. was ").append(throttleTimeMs).toString());
    }

    @Test
    public void testGetMaxValueInQuotaWindowWithNonDefaultQuotaWindow() {
        int numFullQuotaWindows = 3;
        ClientQuotaManagerConfig nonDefaultConfig = new ClientQuotaManagerConfig(numFullQuotaWindows + 1);
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(nonDefaultConfig, this.metrics(), (QuotaType)QuotaType.Fetch$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$);
        Session userSession = new Session(new KafkaPrincipal("User", "userA"), InetAddress.getLocalHost());
        try {
            Assertions.assertEquals((double)Double.MAX_VALUE, (double)clientQuotaManager.getMaxValueInQuotaWindow(userSession, "client1"), (double)0.01);
            clientQuotaManager.updateQuota((Option)new Some((Object)"<default>"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10.0, true)));
            Assertions.assertEquals((double)(10 * numFullQuotaWindows), (double)clientQuotaManager.getMaxValueInQuotaWindow(userSession, "client1"), (double)0.01);
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testSetAndRemoveDefaultUserQuota() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$);
        try {
            this.checkQuota(clientQuotaManager, "userA", "client1", Long.MAX_VALUE, 1000, false);
            clientQuotaManager.updateQuota((Option)new Some((Object)"<default>"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client1", 10L, 1000, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)"<default>"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userA", "client1", Long.MAX_VALUE, 1000, false);
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testSetAndRemoveUserQuota() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$);
        try {
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client1", 10L, 1000, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userA", "client1", Long.MAX_VALUE, 1000, false);
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testSetAndRemoveUserClientQuota() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$);
        try {
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(10.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client1", 10L, 1000, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userA", "client1", Long.MAX_VALUE, 1000, false);
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testQuotaConfigPrecedence() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$);
        try {
            clientQuotaManager.updateQuota((Option)new Some((Object)"<default>"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(1000.0, true)));
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"<default>"), (Option)new Some((Object)"<default>"), (Option)new Some((Object)new Quota(2000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"<default>"), (Option)new Some((Object)"<default>"), (Option)new Some((Object)"<default>"), (Option)new Some((Object)new Quota(3000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(4000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(5000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(6000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(7000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)new Some((Object)"<default>"), (Option)new Some((Object)"<default>"), (Option)new Some((Object)new Quota(8000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userC"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10000.0, true)));
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(9000.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client1", 5000L, 4500, false);
            this.checkQuota(clientQuotaManager, "userA", "client2", 4000L, 4500, true);
            this.checkQuota(clientQuotaManager, "userA", "client3", 4000L, 0, true);
            this.checkQuota(clientQuotaManager, "userA", "client1", 5000L, 0, false);
            this.checkQuota(clientQuotaManager, "userB", "client1", 7000L, 8000, true);
            this.checkQuota(clientQuotaManager, "userB", "client2", 8000L, 7000, false);
            this.checkQuota(clientQuotaManager, "userB", "client3", 8000L, 7000, false);
            this.checkQuota(clientQuotaManager, "userD", "client1", 3000L, 3500, true);
            this.checkQuota(clientQuotaManager, "userD", "client2", 3000L, 2500, false);
            this.checkQuota(clientQuotaManager, "userE", "client1", 3000L, 2500, false);
            clientQuotaManager.updateQuota((Option)new Some((Object)"<default>"), (Option)new Some((Object)"<default>"), (Option)new Some((Object)"<default>"), (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userD", "client1", 1000L, 0, false);
            this.checkQuota(clientQuotaManager, "userE", "client4", 1000L, 1500, true);
            this.checkQuota(clientQuotaManager, "userF", "client4", 1000L, 800, false);
            this.checkQuota(clientQuotaManager, "userF", "client5", 1000L, 800, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)"<default>"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userF", "client4", 2000L, 0, false);
            this.checkQuota(clientQuotaManager, "userF", "client5", 2000L, 0, false);
            this.checkQuota(clientQuotaManager, "userF", "client5", 2000L, 2500, true);
            this.checkQuota(clientQuotaManager, "userG", "client5", 2000L, 0, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(8000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(10000.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client2", 8000L, 0, false);
            this.checkQuota(clientQuotaManager, "userA", "client2", 8000L, 4500, true);
            this.checkQuota(clientQuotaManager, "userA", "client1", 10000L, 0, false);
            this.checkQuota(clientQuotaManager, "userA", "client1", 10000L, 6000, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userA", "client6", 8000L, 0, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client6"), (Option)new Some((Object)"client6"), (Option)new Some((Object)new Quota(11000.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client6", 11000L, 8500, false);
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"<default>"), (Option)new Some((Object)"<default>"), (Option)new Some((Object)new Quota(12000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client6"), (Option)new Some((Object)"client6"), (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userA", "client6", 12000L, 4000, true);
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testQuotaViolation() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$);
        KafkaMetric queueSizeMetric = (KafkaMetric)this.metrics().metrics().get(this.metrics().metricName("queue-size", "Produce", ""));
        try {
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"<default>"), (Option)new Some((Object)"<default>"), (Option)new Some((Object)new Quota(500.0, true)));
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> {
                Assertions.assertEquals((int)0, (int)this.maybeRecord(clientQuotaManager, "ANONYMOUS", "unknown", 400.0));
                this.time().sleep(1000L);
            });
            Assertions.assertEquals((int)0, (int)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            this.time().sleep(500L);
            int throttleTime = this.maybeRecord(clientQuotaManager, "ANONYMOUS", "unknown", 2300.0);
            Assertions.assertEquals((int)2100, (int)throttleTime, (String)"Should be throttled");
            this.throttle(clientQuotaManager, "ANONYMOUS", "unknown", throttleTime, this.callback());
            Assertions.assertEquals((int)1, (int)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            clientQuotaManager.throttledChannelReaper().doWork();
            Assertions.assertEquals((int)0, (int)this.numCallbacks());
            this.time().sleep((long)throttleTime);
            clientQuotaManager.throttledChannelReaper().doWork();
            Assertions.assertEquals((int)0, (int)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            Assertions.assertEquals((int)1, (int)this.numCallbacks());
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> {
                this.maybeRecord(clientQuotaManager, "ANONYMOUS", "unknown", 400.0);
                this.time().sleep(1000L);
            });
            Assertions.assertEquals((int)0, (int)this.maybeRecord(clientQuotaManager, "ANONYMOUS", "unknown", 0.0), (String)"Should be unthrottled since bursty sample has rolled over");
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testExpireThrottleTimeSensor() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$);
        try {
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"<default>"), (Option)new Some((Object)"<default>"), (Option)new Some((Object)new Quota(500.0, true)));
            this.maybeRecord(clientQuotaManager, "ANONYMOUS", "client1", 100.0);
            this.metrics().removeSensor("ProduceThrottleTime-:client1");
            Assertions.assertTrue((this.maybeRecord(clientQuotaManager, "ANONYMOUS", "client1", 10000.0) > 0 ? 1 : 0) != 0, (String)"Should be throttled");
            Sensor throttleTimeSensor = this.metrics().getSensor("ProduceThrottleTime-:client1");
            Assertions.assertNotNull((Object)throttleTimeSensor, (String)"Throttle time sensor should exist");
            Assertions.assertNotNull((Object)throttleTimeSensor, (String)"Throttle time sensor should exist");
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testExpireQuotaSensors() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$);
        try {
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"<default>"), (Option)new Some((Object)"<default>"), (Option)new Some((Object)new Quota(500.0, true)));
            this.maybeRecord(clientQuotaManager, "ANONYMOUS", "client1", 100.0);
            this.metrics().removeSensor("ProduceThrottleTime-:client1");
            this.metrics().removeSensor("Produce-ANONYMOUS:client1");
            Assertions.assertTrue((this.maybeRecord(clientQuotaManager, "ANONYMOUS", "client1", 10000.0) > 0 ? 1 : 0) != 0, (String)"Should be throttled");
            Assertions.assertNotNull((Object)this.metrics().getSensor("ProduceThrottleTime-:client1"), (String)"Throttle time sensor should exist");
            Assertions.assertNotNull((Object)this.metrics().getSensor("Produce-:client1"), (String)"Byte rate sensor should exist");
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testClientIdNotSanitized() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$);
        String clientId = "client@#$%";
        try {
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"<default>"), (Option)new Some((Object)"<default>"), (Option)new Some((Object)new Quota(500.0, true)));
            this.maybeRecord(clientQuotaManager, "ANONYMOUS", clientId, 100.0);
            Assertions.assertNotNull((Object)this.metrics().getSensor(new StringBuilder(21).append("ProduceThrottleTime-:").append(clientId).toString()), (String)"Throttle time sensor should exist");
            Assertions.assertNotNull((Object)this.metrics().getSensor(new StringBuilder(9).append("Produce-:").append(clientId).toString()), (String)"Byte rate sensor should exist");
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    private final void UserClient$lzycompute$1() {
        synchronized (this) {
            if (this.UserClient$module == null) {
                this.UserClient$module = new ClientQuotaManagerTest$UserClient$(this);
            }
            return;
        }
    }

    private class UserClient
    implements Product,
    Serializable {
        private final String user;
        private final String clientId;
        private final Option<String> configUser;
        private final Option<String> configClientId;
        public final /* synthetic */ ClientQuotaManagerTest $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String user() {
            return this.user;
        }

        public String clientId() {
            return this.clientId;
        }

        public Option<String> configUser() {
            return this.configUser;
        }

        public Option<String> configClientId() {
            return this.configClientId;
        }

        public Option<String> sanitizedConfigClientId() {
            return this.configClientId().map((Function1 & Serializable)x -> {
                String string = x;
                String string2 = "<default>";
                if (string != null && string.equals(string2)) {
                    return "<default>";
                }
                return Sanitizer.sanitize((String)x);
            });
        }

        public UserClient copy(String user, String clientId, Option<String> configUser, Option<String> configClientId) {
            return new UserClient(this.kafka$server$ClientQuotaManagerTest$UserClient$$$outer(), user, clientId, configUser, configClientId);
        }

        public String copy$default$1() {
            return this.user();
        }

        public String copy$default$2() {
            return this.clientId();
        }

        public Option<String> copy$default$3() {
            return this.configUser();
        }

        public Option<String> copy$default$4() {
            return this.configClientId();
        }

        public String productPrefix() {
            return "UserClient";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.user();
                }
                case 1: {
                    return this.clientId();
                }
                case 2: {
                    return this.configUser();
                }
                case 3: {
                    return this.configClientId();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof UserClient;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "user";
                }
                case 1: {
                    return "clientId";
                }
                case 2: {
                    return "configUser";
                }
                case 3: {
                    return "configClientId";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof UserClient && ((UserClient)x$1).kafka$server$ClientQuotaManagerTest$UserClient$$$outer() == this.kafka$server$ClientQuotaManagerTest$UserClient$$$outer())) break block3;
                    UserClient userClient = (UserClient)x$1;
                    String string = this.user();
                    String string2 = userClient.user();
                    if (string != null ? !string.equals(string2) : string2 != null) break block3;
                    String string3 = this.clientId();
                    String string4 = userClient.clientId();
                    if (string3 != null ? !string3.equals(string4) : string4 != null) break block3;
                    Option<String> option = this.configUser();
                    Option<String> option2 = userClient.configUser();
                    if (option != null ? !option.equals(option2) : option2 != null) break block3;
                    Option<String> option3 = this.configClientId();
                    Option<String> option4 = userClient.configClientId();
                    if ((option3 != null ? !option3.equals(option4) : option4 != null) || !userClient.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ ClientQuotaManagerTest kafka$server$ClientQuotaManagerTest$UserClient$$$outer() {
            return this.$outer;
        }

        public UserClient(ClientQuotaManagerTest $outer, String user, String clientId, Option<String> configUser, Option<String> configClientId) {
            this.user = user;
            this.clientId = clientId;
            this.configUser = configUser;
            this.configClientId = configClientId;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

