/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.events;

import java.io.Serializable;
import java.lang.runtime.SwitchBootstraps;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.syncope.client.console.events.EventCategory;
import org.apache.syncope.client.console.events.EventSelectionPanel;
import org.apache.syncope.client.console.events.SelectedEventsPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.common.lib.types.OpEvent;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;

public abstract class EventCategoryPanel
extends Panel {
    private static final long serialVersionUID = 6429053774964787734L;
    private final List<EventCategory> eventCategories;
    private final EventCategory eventCategory = new EventCategory();
    private final WebMarkupContainer categoryContainer;
    private final WebMarkupContainer eventsContainer;
    private final SelectedEventsPanel selectedEventsPanel;
    private final AjaxDropDownChoicePanel<OpEvent.CategoryType> type;
    private final AjaxDropDownChoicePanel<String> category;
    private final AjaxDropDownChoicePanel<String> subcategory;
    private final AjaxTextFieldPanel custom;
    private final ActionsPanel<EventCategory> actionsPanel;
    private final IModel<List<String>> model;

    protected static List<String> filter(List<EventCategory> categories, OpEvent.CategoryType type) {
        return categories.stream().filter(c -> type == c.getType() && StringUtils.isNotEmpty((CharSequence)c.getCategory())).map(EventCategory::getCategory).distinct().sorted().collect(Collectors.toList());
    }

    protected static List<String> filter(List<EventCategory> categories, OpEvent.CategoryType type, String category) {
        return categories.stream().filter(c -> type == c.getType() && Strings.CS.equals(category, c.getCategory())).map(EventCategory::getSubcategory).distinct().sorted().collect(Collectors.toList());
    }

    public EventCategoryPanel(String id, List<EventCategory> eventCategories, IModel<List<String>> model) {
        super(id);
        this.model = model;
        this.selectedEventsPanel = new SelectedEventsPanel("selectedEventsPanel", model);
        this.add(new Component[]{this.selectedEventsPanel});
        this.eventCategories = eventCategories;
        this.categoryContainer = new WebMarkupContainer("categoryContainer");
        this.categoryContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.categoryContainer});
        this.eventsContainer = new WebMarkupContainer("eventsContainer");
        this.eventsContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.eventsContainer});
        this.authorizeList();
        this.authorizeChanges();
        this.type = new AjaxDropDownChoicePanel("type", "type", (IModel)new PropertyModel((Object)this.eventCategory, "type"), false);
        this.type.setChoices(eventCategories.stream().map(EventCategory::getType).distinct().sorted(Comparator.comparing(Enum::name)).collect(Collectors.toList()));
        this.type.setChoiceRenderer((IChoiceRenderer)new IChoiceRenderer<OpEvent.CategoryType>(){
            private static final long serialVersionUID = 2317134950949778735L;

            public String getDisplayValue(OpEvent.CategoryType eventCategoryType) {
                return eventCategoryType.name();
            }

            public String getIdValue(OpEvent.CategoryType eventCategoryType, int i) {
                return eventCategoryType.name();
            }

            public OpEvent.CategoryType getObject(String id, IModel<? extends List<? extends OpEvent.CategoryType>> choices) {
                return ((List)choices.getObject()).stream().filter(object -> object.name().equals(id)).findAny().orElse(null);
            }
        });
        this.categoryContainer.add(new Component[]{this.type});
        this.type.getField().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                EventCategoryPanel.this.send((IEventSink)EventCategoryPanel.this, Broadcast.EXACT, new ChangeCategoryEvent(target, (Panel)EventCategoryPanel.this.type));
            }
        }});
        this.category = new AjaxDropDownChoicePanel("category", "category", (IModel)new PropertyModel((Object)this.eventCategory, "category"), false);
        this.category.setChoices(EventCategoryPanel.filter(eventCategories, (OpEvent.CategoryType)this.type.getModelObject()));
        this.categoryContainer.add(new Component[]{this.category});
        this.category.getField().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){
            private static final long serialVersionUID = -1107858522700306811L;

            protected void onUpdate(AjaxRequestTarget target) {
                EventCategoryPanel.this.send((IEventSink)EventCategoryPanel.this, Broadcast.EXACT, new ChangeCategoryEvent(target, (Panel)EventCategoryPanel.this.category));
            }
        }});
        this.subcategory = new AjaxDropDownChoicePanel("subcategory", "subcategory", (IModel)new PropertyModel((Object)this.eventCategory, "subcategory"), false);
        this.subcategory.setChoices(EventCategoryPanel.filter(eventCategories, (OpEvent.CategoryType)this.type.getModelObject(), (String)((Object)this.category.getModelObject())));
        this.categoryContainer.add(new Component[]{this.subcategory});
        this.subcategory.getField().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){
            private static final long serialVersionUID = -1107858522700306812L;

            protected void onUpdate(AjaxRequestTarget target) {
                EventCategoryPanel.this.send((IEventSink)EventCategoryPanel.this, Broadcast.EXACT, new ChangeCategoryEvent(target, (Panel)EventCategoryPanel.this.subcategory));
            }
        }});
        this.categoryContainer.add(new Component[]{new Label("customLabel", (IModel)new ResourceModel("custom", "custom")).setVisible(false)});
        this.custom = new AjaxTextFieldPanel("custom", "custom", (IModel)new Model(null));
        this.custom.setVisible(false);
        this.custom.setEnabled(false);
        this.categoryContainer.add(new Component[]{this.custom.hideLabel()});
        this.actionsPanel = new ActionsPanel("customActions", null);
        this.actionsPanel.add(new ActionLink<EventCategory>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, EventCategory ignore) {
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)((Object)EventCategoryPanel.this.custom.getModelObject())))) {
                    OpEvent opEvent = OpEvent.fromString((String)((String)((Object)EventCategoryPanel.this.custom.getModelObject())));
                    EventCategoryPanel.this.custom.setModelObject((Serializable)((Object)""));
                    EventCategoryPanel.this.send((IEventSink)EventCategoryPanel.this.getPage(), Broadcast.BREADTH, new SelectedEventsPanel.EventSelectionChanged(target, Set.of(opEvent), Set.of()));
                    target.add(new Component[]{EventCategoryPanel.this.categoryContainer});
                }
            }
        }, ActionLink.ActionType.CREATE, "").hideLabel();
        this.actionsPanel.add(new ActionLink<EventCategory>(){
            private static final long serialVersionUID = -3722207913631435521L;

            @Override
            public void onClick(AjaxRequestTarget target, EventCategory ignore) {
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)((Object)EventCategoryPanel.this.custom.getModelObject())))) {
                    OpEvent opEvent = OpEvent.fromString((String)((String)((Object)EventCategoryPanel.this.custom.getModelObject())));
                    EventCategoryPanel.this.custom.setModelObject((Serializable)((Object)""));
                    EventCategoryPanel.this.send((IEventSink)EventCategoryPanel.this.getPage(), Broadcast.BREADTH, new SelectedEventsPanel.EventSelectionChanged(target, Set.of(), Set.of(opEvent)));
                    target.add(new Component[]{EventCategoryPanel.this.categoryContainer});
                }
            }
        }, ActionLink.ActionType.DELETE, "", true).hideLabel();
        this.categoryContainer.add(new Component[]{this.actionsPanel});
        this.actionsPanel.setVisible(false);
        this.actionsPanel.setEnabled(false);
        this.actionsPanel.setMarkupId("inline-actions");
        this.eventsContainer.add(new Component[]{new EventSelectionPanel("eventsPanel", this.eventCategory, model){
            private static final long serialVersionUID = 3513194801190026082L;

            @Override
            protected void onEventAction(IEvent<?> event) {
                EventCategoryPanel.this.onEventAction(event);
            }
        }});
    }

    public void onEvent(IEvent<?> event) {
        Object object = event.getPayload();
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ChangeCategoryEvent.class, SelectedEventsPanel.InspectSelectedEvent.class}, (Object)object2, n)) {
            case 0: {
                ChangeCategoryEvent changeCategoryEvent = (ChangeCategoryEvent)object2;
                this.eventCategory.getOps().clear();
                switch (changeCategoryEvent.getChangedPanel().getId()) {
                    case "type": {
                        this.eventCategory.setType((OpEvent.CategoryType)this.type.getModelObject());
                        this.eventCategory.setCategory(null);
                        this.eventCategory.setSubcategory(null);
                        if (this.type.getModelObject() == OpEvent.CategoryType.CUSTOM || this.type.getModelObject() == OpEvent.CategoryType.WA) {
                            this.category.setChoices(List.of());
                            this.subcategory.setChoices(List.of());
                            this.category.setEnabled(false);
                            this.subcategory.setEnabled(false);
                            this.custom.setVisible(true);
                            this.custom.setEnabled(true);
                            this.actionsPanel.setVisible(true);
                            this.actionsPanel.setEnabled(true);
                        } else {
                            this.category.setChoices(EventCategoryPanel.filter(this.eventCategories, (OpEvent.CategoryType)this.type.getModelObject()));
                            this.subcategory.setChoices(List.of());
                            this.category.setEnabled(true);
                            this.subcategory.setEnabled(true);
                            this.custom.setVisible(false);
                            this.custom.setEnabled(false);
                            this.actionsPanel.setVisible(false);
                            this.actionsPanel.setEnabled(false);
                        }
                        changeCategoryEvent.getTarget().add(new Component[]{this.categoryContainer});
                        break;
                    }
                    case "category": {
                        this.subcategory.setChoices(EventCategoryPanel.filter(this.eventCategories, (OpEvent.CategoryType)this.type.getModelObject(), (String)((Object)this.category.getModelObject())));
                        this.eventCategory.setCategory((String)((Object)this.category.getModelObject()));
                        this.eventCategory.setSubcategory(null);
                        changeCategoryEvent.getTarget().add(new Component[]{this.categoryContainer});
                        break;
                    }
                    default: {
                        this.eventCategory.setSubcategory((String)((Object)this.subcategory.getModelObject()));
                    }
                }
                this.updateEventsContainer(changeCategoryEvent.getTarget());
                break;
            }
            case 1: {
                SelectedEventsPanel.InspectSelectedEvent inspectSelectedEvent = (SelectedEventsPanel.InspectSelectedEvent)object2;
                this.eventCategory.getOps().clear();
                OpEvent opEvent = OpEvent.fromString((String)inspectSelectedEvent.getEvent());
                this.eventCategory.setType(opEvent.getType());
                this.category.setChoices(EventCategoryPanel.filter(this.eventCategories, (OpEvent.CategoryType)this.type.getModelObject()));
                this.eventCategory.setCategory(opEvent.getCategory());
                this.subcategory.setChoices(EventCategoryPanel.filter(this.eventCategories, (OpEvent.CategoryType)this.type.getModelObject(), (String)((Object)this.category.getModelObject())));
                this.eventCategory.setSubcategory(opEvent.getSubcategory());
                if (opEvent.getType() == OpEvent.CategoryType.CUSTOM || opEvent.getType() == OpEvent.CategoryType.WA) {
                    this.custom.setModelObject((Serializable)((Object)OpEvent.toString((OpEvent.CategoryType)opEvent.getType(), (String)opEvent.getCategory(), (String)opEvent.getSubcategory(), (String)opEvent.getOp(), (OpEvent.Outcome)opEvent.getOutcome())));
                    this.category.setEnabled(false);
                    this.subcategory.setEnabled(false);
                    this.custom.setVisible(true);
                    this.custom.setEnabled(true);
                    this.actionsPanel.setVisible(true);
                    this.actionsPanel.setEnabled(true);
                } else {
                    this.category.setEnabled(true);
                    this.subcategory.setEnabled(true);
                    this.custom.setVisible(false);
                    this.custom.setEnabled(false);
                    this.actionsPanel.setVisible(false);
                    this.actionsPanel.setEnabled(false);
                }
                inspectSelectedEvent.getTarget().add(new Component[]{this.categoryContainer});
                this.updateEventsContainer(inspectSelectedEvent.getTarget());
                break;
            }
        }
    }

    protected void onEventAction(IEvent<?> event) {
    }

    protected abstract List<String> getListAuthRoles();

    protected void authorizeList() {
        this.getListAuthRoles().forEach(r -> MetaDataRoleAuthorizationStrategy.authorize((Component)this.selectedEventsPanel, (Action)RENDER, (String)r));
    }

    protected abstract List<String> getChangeAuthRoles();

    protected void authorizeChanges() {
        this.getChangeAuthRoles().forEach(r -> {
            MetaDataRoleAuthorizationStrategy.authorize((Component)this.categoryContainer, (Action)RENDER, (String)r);
            MetaDataRoleAuthorizationStrategy.authorize((Component)this.eventsContainer, (Action)RENDER, (String)r);
        });
    }

    protected void updateEventsContainer(AjaxRequestTarget target) {
        Iterator<EventCategory> itor = this.eventCategories.iterator();
        while (itor.hasNext() && this.eventCategory.getOps().isEmpty()) {
            EventCategory ec = itor.next();
            if (ec.getType() != this.eventCategory.getType() || !Strings.CS.equals(ec.getCategory(), this.eventCategory.getCategory()) || !Strings.CS.equals(ec.getSubcategory(), this.eventCategory.getSubcategory())) continue;
            this.eventCategory.getOps().addAll(ec.getOps());
        }
        this.eventsContainer.addOrReplace(new Component[]{new EventSelectionPanel("eventsPanel", this.eventCategory, this.model){
            private static final long serialVersionUID = 3513194801190026082L;

            @Override
            public void onEventAction(IEvent<?> event) {
                EventCategoryPanel.this.onEventAction(event);
            }
        }});
        target.add(new Component[]{this.eventsContainer});
    }

    protected static class ChangeCategoryEvent {
        protected final AjaxRequestTarget target;
        protected final Panel changedPanel;

        ChangeCategoryEvent(AjaxRequestTarget target, Panel changedPanel) {
            this.target = target;
            this.changedPanel = changedPanel;
        }

        public AjaxRequestTarget getTarget() {
            return this.target;
        }

        public Panel getChangedPanel() {
            return this.changedPanel;
        }
    }
}

