/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.audit.spi.resource;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apereo.cas.audit.spi.resource.TicketAsFirstParameterResourceResolver;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.configuration.model.core.audit.AuditEngineProperties;
import org.apereo.cas.util.AopUtils;
import org.apereo.cas.validation.Assertion;
import org.apereo.inspektr.audit.AuditTrailManager;
import org.aspectj.lang.JoinPoint;

public class TicketValidationResourceResolver
extends TicketAsFirstParameterResourceResolver {
    public TicketValidationResourceResolver(AuthenticationServiceSelectionPlan serviceSelectionStrategy, AuditEngineProperties properties) {
        super(serviceSelectionStrategy, properties);
    }

    @Override
    public String[] resolveFrom(JoinPoint joinPoint, Object returnValue) {
        String[] stringArray;
        HashMap<String, Object> results = new HashMap<String, Object>();
        Object[] args = AopUtils.unWrapJoinPoint((JoinPoint)joinPoint).getArgs();
        if (args != null && args.length > 0) {
            String ticketId = args[0].toString();
            results.put("ticket", ticketId);
        }
        if (returnValue instanceof Assertion) {
            Assertion assertion = (Assertion)returnValue;
            Authentication authn = assertion.getPrimaryAuthentication();
            results.put("principal", authn.getPrincipal().getId());
            HashMap attributes = new HashMap(authn.getAttributes());
            attributes.putAll(authn.getPrincipal().getAttributes());
            results.put("attributes", attributes);
        }
        AuditTrailManager.AuditFormats auditFormat = AuditTrailManager.AuditFormats.valueOf((String)this.properties.getAuditFormat().name());
        if (results.isEmpty()) {
            stringArray = ArrayUtils.EMPTY_STRING_ARRAY;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = auditFormat.serialize(this.finalizeResources(results, joinPoint, returnValue));
        }
        return stringArray;
    }

    protected Map<String, Object> finalizeResources(Map<String, Object> results, JoinPoint joinPoint, Object returnValue) {
        return results;
    }
}

