/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatch.model.CloudWatchRequest;
import software.amazon.awssdk.services.cloudwatch.model.LabelOptions;
import software.amazon.awssdk.services.cloudwatch.model.MetricDataQueriesCopier;
import software.amazon.awssdk.services.cloudwatch.model.MetricDataQuery;
import software.amazon.awssdk.services.cloudwatch.model.ScanBy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMetricDataRequest
extends CloudWatchRequest
implements ToCopyableBuilder<Builder, GetMetricDataRequest> {
    private static final SdkField<List<MetricDataQuery>> METRIC_DATA_QUERIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MetricDataQueries").getter(GetMetricDataRequest.getter(GetMetricDataRequest::metricDataQueries)).setter(GetMetricDataRequest.setter(Builder::metricDataQueries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricDataQueries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricDataQuery::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(GetMetricDataRequest.getter(GetMetricDataRequest::startTime)).setter(GetMetricDataRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(GetMetricDataRequest.getter(GetMetricDataRequest::endTime)).setter(GetMetricDataRequest.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetMetricDataRequest.getter(GetMetricDataRequest::nextToken)).setter(GetMetricDataRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<String> SCAN_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScanBy").getter(GetMetricDataRequest.getter(GetMetricDataRequest::scanByAsString)).setter(GetMetricDataRequest.setter(Builder::scanBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScanBy").build()}).build();
    private static final SdkField<Integer> MAX_DATAPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxDatapoints").getter(GetMetricDataRequest.getter(GetMetricDataRequest::maxDatapoints)).setter(GetMetricDataRequest.setter(Builder::maxDatapoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxDatapoints").build()}).build();
    private static final SdkField<LabelOptions> LABEL_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LabelOptions").getter(GetMetricDataRequest.getter(GetMetricDataRequest::labelOptions)).setter(GetMetricDataRequest.setter(Builder::labelOptions)).constructor(LabelOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_DATA_QUERIES_FIELD, START_TIME_FIELD, END_TIME_FIELD, NEXT_TOKEN_FIELD, SCAN_BY_FIELD, MAX_DATAPOINTS_FIELD, LABEL_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetMetricDataRequest.memberNameToFieldInitializer();
    private final List<MetricDataQuery> metricDataQueries;
    private final Instant startTime;
    private final Instant endTime;
    private final String nextToken;
    private final String scanBy;
    private final Integer maxDatapoints;
    private final LabelOptions labelOptions;

    private GetMetricDataRequest(BuilderImpl builder) {
        super(builder);
        this.metricDataQueries = builder.metricDataQueries;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.nextToken = builder.nextToken;
        this.scanBy = builder.scanBy;
        this.maxDatapoints = builder.maxDatapoints;
        this.labelOptions = builder.labelOptions;
    }

    public final boolean hasMetricDataQueries() {
        return this.metricDataQueries != null && !(this.metricDataQueries instanceof SdkAutoConstructList);
    }

    public final List<MetricDataQuery> metricDataQueries() {
        return this.metricDataQueries;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final ScanBy scanBy() {
        return ScanBy.fromValue(this.scanBy);
    }

    public final String scanByAsString() {
        return this.scanBy;
    }

    public final Integer maxDatapoints() {
        return this.maxDatapoints;
    }

    public final LabelOptions labelOptions() {
        return this.labelOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricDataQueries() ? this.metricDataQueries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxDatapoints());
        hashCode = 31 * hashCode + Objects.hashCode(this.labelOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMetricDataRequest)) {
            return false;
        }
        GetMetricDataRequest other = (GetMetricDataRequest)((Object)obj);
        return this.hasMetricDataQueries() == other.hasMetricDataQueries() && Objects.equals(this.metricDataQueries(), other.metricDataQueries()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.scanByAsString(), other.scanByAsString()) && Objects.equals(this.maxDatapoints(), other.maxDatapoints()) && Objects.equals(this.labelOptions(), other.labelOptions());
    }

    public final String toString() {
        return ToString.builder((String)"GetMetricDataRequest").add("MetricDataQueries", this.hasMetricDataQueries() ? this.metricDataQueries() : null).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("NextToken", (Object)this.nextToken()).add("ScanBy", (Object)this.scanByAsString()).add("MaxDatapoints", (Object)this.maxDatapoints()).add("LabelOptions", (Object)this.labelOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MetricDataQueries": {
                return Optional.ofNullable(clazz.cast(this.metricDataQueries()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ScanBy": {
                return Optional.ofNullable(clazz.cast(this.scanByAsString()));
            }
            case "MaxDatapoints": {
                return Optional.ofNullable(clazz.cast(this.maxDatapoints()));
            }
            case "LabelOptions": {
                return Optional.ofNullable(clazz.cast(this.labelOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MetricDataQueries", METRIC_DATA_QUERIES_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("ScanBy", SCAN_BY_FIELD);
        map.put("MaxDatapoints", MAX_DATAPOINTS_FIELD);
        map.put("LabelOptions", LABEL_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetMetricDataRequest, T> g) {
        return obj -> g.apply((GetMetricDataRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchRequest.BuilderImpl
    implements Builder {
        private List<MetricDataQuery> metricDataQueries = DefaultSdkAutoConstructList.getInstance();
        private Instant startTime;
        private Instant endTime;
        private String nextToken;
        private String scanBy;
        private Integer maxDatapoints;
        private LabelOptions labelOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMetricDataRequest model) {
            super(model);
            this.metricDataQueries(model.metricDataQueries);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.nextToken(model.nextToken);
            this.scanBy(model.scanBy);
            this.maxDatapoints(model.maxDatapoints);
            this.labelOptions(model.labelOptions);
        }

        public final List<MetricDataQuery.Builder> getMetricDataQueries() {
            List<MetricDataQuery.Builder> result = MetricDataQueriesCopier.copyToBuilder(this.metricDataQueries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricDataQueries(Collection<MetricDataQuery.BuilderImpl> metricDataQueries) {
            this.metricDataQueries = MetricDataQueriesCopier.copyFromBuilder(metricDataQueries);
        }

        @Override
        public final Builder metricDataQueries(Collection<MetricDataQuery> metricDataQueries) {
            this.metricDataQueries = MetricDataQueriesCopier.copy(metricDataQueries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDataQueries(MetricDataQuery ... metricDataQueries) {
            this.metricDataQueries(Arrays.asList(metricDataQueries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDataQueries(Consumer<MetricDataQuery.Builder> ... metricDataQueries) {
            this.metricDataQueries(Stream.of(metricDataQueries).map(c -> (MetricDataQuery)((MetricDataQuery.Builder)MetricDataQuery.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getScanBy() {
            return this.scanBy;
        }

        public final void setScanBy(String scanBy) {
            this.scanBy = scanBy;
        }

        @Override
        public final Builder scanBy(String scanBy) {
            this.scanBy = scanBy;
            return this;
        }

        @Override
        public final Builder scanBy(ScanBy scanBy) {
            this.scanBy(scanBy == null ? null : scanBy.toString());
            return this;
        }

        public final Integer getMaxDatapoints() {
            return this.maxDatapoints;
        }

        public final void setMaxDatapoints(Integer maxDatapoints) {
            this.maxDatapoints = maxDatapoints;
        }

        @Override
        public final Builder maxDatapoints(Integer maxDatapoints) {
            this.maxDatapoints = maxDatapoints;
            return this;
        }

        public final LabelOptions.Builder getLabelOptions() {
            return this.labelOptions != null ? this.labelOptions.toBuilder() : null;
        }

        public final void setLabelOptions(LabelOptions.BuilderImpl labelOptions) {
            this.labelOptions = labelOptions != null ? labelOptions.build() : null;
        }

        @Override
        public final Builder labelOptions(LabelOptions labelOptions) {
            this.labelOptions = labelOptions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetMetricDataRequest build() {
            return new GetMetricDataRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudWatchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMetricDataRequest> {
        public Builder metricDataQueries(Collection<MetricDataQuery> var1);

        public Builder metricDataQueries(MetricDataQuery ... var1);

        public Builder metricDataQueries(Consumer<MetricDataQuery.Builder> ... var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder nextToken(String var1);

        public Builder scanBy(String var1);

        public Builder scanBy(ScanBy var1);

        public Builder maxDatapoints(Integer var1);

        public Builder labelOptions(LabelOptions var1);

        default public Builder labelOptions(Consumer<LabelOptions.Builder> labelOptions) {
            return this.labelOptions((LabelOptions)((LabelOptions.Builder)LabelOptions.builder().applyMutation(labelOptions)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

