/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.common.pooling;

import java.util.LinkedHashMap;

public final class ObjectPoolConfiguration {
    private int maxObjects = 10;
    private int maxIdle = 10;
    private long maxWait = 150000L;
    private long minEvictableIdleTimeMillis = 120000L;
    private long maxIdleTimeMillis = 0L;
    private int minIdle = 1;

    public ObjectPoolConfiguration() {
    }

    public ObjectPoolConfiguration(ObjectPoolConfiguration other) {
        this.setMaxObjects(other.getMaxObjects());
        this.setMaxIdle(other.getMaxIdle());
        this.setMaxWait(other.getMaxWait());
        this.setMinEvictableIdleTimeMillis(other.getMinEvictableIdleTimeMillis());
        this.setMaxIdleTimeMillis(other.getMaxIdleTimeMillis());
        this.setMinIdle(other.getMinIdle());
    }

    public int getMaxObjects() {
        return this.maxObjects;
    }

    public void setMaxObjects(int maxObjects) {
        this.maxObjects = maxObjects;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
    }

    public long getMaxWait() {
        return this.maxWait;
    }

    public void setMaxWait(long maxWait) {
        this.maxWait = maxWait;
    }

    public long getMinEvictableIdleTimeMillis() {
        return this.minEvictableIdleTimeMillis;
    }

    public void setMinEvictableIdleTimeMillis(long minEvictableIdleTimeMillis) {
        this.minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
    }

    public long getMaxIdleTimeMillis() {
        return this.maxIdleTimeMillis;
    }

    public void setMaxIdleTimeMillis(long maxIdleTimeMillis) {
        this.maxIdleTimeMillis = maxIdleTimeMillis;
    }

    public int getMinIdle() {
        return this.minIdle;
    }

    public void setMinIdle(int minIdle) {
        this.minIdle = minIdle;
    }

    public void validate() {
        if (this.minIdle < 0) {
            throw new IllegalArgumentException("Min idle is less than zero.");
        }
        if (this.maxObjects < 0) {
            throw new IllegalArgumentException("Max active is less than zero.");
        }
        if (this.maxIdle < 0) {
            throw new IllegalArgumentException("Max idle is less than zero.");
        }
        if (this.maxWait < 0L) {
            throw new IllegalArgumentException("Max wait is less than zero.");
        }
        if (this.minEvictableIdleTimeMillis < 0L) {
            throw new IllegalArgumentException("Min evictable idle time millis less than zero.");
        }
        if (this.maxIdleTimeMillis < 0L) {
            throw new IllegalArgumentException("Max idle time millis less than zero.");
        }
        if (this.maxIdleTimeMillis > 0L && this.maxIdleTimeMillis < this.minEvictableIdleTimeMillis) {
            throw new IllegalArgumentException("Max idle time millis less than min evictable idle time millis.");
        }
        if (this.minIdle > this.maxIdle) {
            throw new IllegalArgumentException("Min idle is greater than max idle.");
        }
        if (this.maxIdle > this.maxObjects) {
            throw new IllegalArgumentException("Max idle is greater than max objects.");
        }
    }

    public int hashCode() {
        return (int)((long)(this.getMaxObjects() + this.getMaxIdle()) + this.getMaxWait() + this.getMinEvictableIdleTimeMillis() + (long)this.getMinIdle() + this.getMaxIdleTimeMillis());
    }

    public boolean equals(Object obj) {
        if (obj instanceof ObjectPoolConfiguration) {
            ObjectPoolConfiguration other = (ObjectPoolConfiguration)obj;
            if (this.getMaxObjects() != other.getMaxObjects()) {
                return false;
            }
            if (this.getMaxIdle() != other.getMaxIdle()) {
                return false;
            }
            if (this.getMaxWait() != other.getMaxWait()) {
                return false;
            }
            if (this.getMinEvictableIdleTimeMillis() != other.getMinEvictableIdleTimeMillis()) {
                return false;
            }
            if (this.getMinIdle() != other.getMinIdle()) {
                return false;
            }
            return this.getMaxIdleTimeMillis() == other.getMaxIdleTimeMillis();
        }
        return false;
    }

    public String toString() {
        LinkedHashMap<String, Number> bld = new LinkedHashMap<String, Number>();
        bld.put("MaxObjects", this.getMaxObjects());
        bld.put("MaxIdle", this.getMaxIdle());
        bld.put("MaxWait", this.getMaxWait());
        bld.put("MinEvictableIdleTimeMillis", this.getMinEvictableIdleTimeMillis());
        bld.put("MinIdle", this.getMinIdle());
        bld.put("MaxLifetimeMillis", this.getMaxIdleTimeMillis());
        return ((Object)bld).toString();
    }
}

