/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.token;

import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.oidc.issuer.OidcIssuerService;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyCacheKey;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyStoreUtils;
import org.apereo.cas.oidc.token.OidcRegisteredServiceJwtCipherExecutor;
import org.apereo.cas.oidc.util.InternalJwtAccessTokenCipherExecutor;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20RegisteredServiceJwtAccessTokenCipherExecutor;
import org.apereo.cas.token.cipher.JwtTicketCipherExecutor;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcRegisteredServiceJwtAccessTokenCipherExecutor
extends OAuth20RegisteredServiceJwtAccessTokenCipherExecutor
implements OidcRegisteredServiceJwtCipherExecutor {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcRegisteredServiceJwtAccessTokenCipherExecutor.class);
    protected final LoadingCache<OidcJsonWebKeyCacheKey, JsonWebKeySet> defaultJsonWebKeystoreCache;
    protected final LoadingCache<OidcJsonWebKeyCacheKey, Optional<JsonWebKeySet>> registeredServiceJsonWebKeystoreCache;
    protected final OidcIssuerService oidcIssuerService;

    public Optional<String> getSigningKey(RegisteredService registeredService) {
        if (!this.isSigningEnabledForRegisteredService(registeredService)) {
            return Optional.empty();
        }
        Optional result = super.getSigningKey(registeredService);
        if (result.isPresent()) {
            return result;
        }
        if (registeredService instanceof OidcRegisteredService) {
            OidcRegisteredService oidcRegisteredService = (OidcRegisteredService)registeredService;
            Optional<JsonWebKeySet> jsonWebKeySet = OidcJsonWebKeyStoreUtils.fetchJsonWebKeySetForSigning(registeredService, this, true);
            if (jsonWebKeySet.isPresent()) {
                JsonWebKey signingKey = jsonWebKeySet.get().findJsonWebKey(oidcRegisteredService.getJwksKeyId(), null, null, oidcRegisteredService.getJwtAccessTokenSigningAlg());
                return Optional.ofNullable(signingKey).map(key -> key.toJson(JsonWebKey.OutputControlLevel.INCLUDE_PRIVATE)).or(() -> Optional.of(((JsonWebKeySet)jsonWebKeySet.get()).toJson(JsonWebKey.OutputControlLevel.INCLUDE_PRIVATE)));
            }
        }
        return Optional.empty();
    }

    public Optional<String> getEncryptionKey(RegisteredService registeredService) {
        if (!this.isEncryptionEnabledForRegisteredService(registeredService)) {
            return Optional.empty();
        }
        Optional result = super.getEncryptionKey(registeredService);
        if (result.isPresent()) {
            return result;
        }
        if (registeredService instanceof OidcRegisteredService) {
            Optional<JsonWebKeySet> jwks = OidcJsonWebKeyStoreUtils.fetchJsonWebKeySetForEncryption(registeredService, this);
            return jwks.map(JsonWebKeySet::toJson);
        }
        return result;
    }

    protected JwtTicketCipherExecutor createCipherExecutorInstance(String encryptionKey, String signingKey, RegisteredService registeredService) {
        JwtTicketCipherExecutor cipher = InternalJwtAccessTokenCipherExecutor.get(signingKey, encryptionKey, registeredService, this);
        return this.prepareCipherExecutor(cipher, registeredService);
    }

    @Generated
    public OidcRegisteredServiceJwtAccessTokenCipherExecutor(LoadingCache<OidcJsonWebKeyCacheKey, JsonWebKeySet> defaultJsonWebKeystoreCache, LoadingCache<OidcJsonWebKeyCacheKey, Optional<JsonWebKeySet>> registeredServiceJsonWebKeystoreCache, OidcIssuerService oidcIssuerService) {
        this.defaultJsonWebKeystoreCache = defaultJsonWebKeystoreCache;
        this.registeredServiceJsonWebKeystoreCache = registeredServiceJsonWebKeystoreCache;
        this.oidcIssuerService = oidcIssuerService;
    }

    @Override
    @Generated
    public LoadingCache<OidcJsonWebKeyCacheKey, JsonWebKeySet> getDefaultJsonWebKeystoreCache() {
        return this.defaultJsonWebKeystoreCache;
    }

    @Override
    @Generated
    public LoadingCache<OidcJsonWebKeyCacheKey, Optional<JsonWebKeySet>> getRegisteredServiceJsonWebKeystoreCache() {
        return this.registeredServiceJsonWebKeystoreCache;
    }

    @Override
    @Generated
    public OidcIssuerService getOidcIssuerService() {
        return this.oidcIssuerService;
    }
}

